/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.manager;

import com.caucho.amber.AmberException;
import com.caucho.amber.cfg.ColumnResultConfig;
import com.caucho.amber.cfg.EntityResultConfig;
import com.caucho.amber.cfg.FieldResultConfig;
import com.caucho.amber.cfg.SqlResultSetMappingConfig;
import com.caucho.amber.entity.Entity;
import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.ArgExpr;
import com.caucho.amber.expr.LoadEntityExpr;
import com.caucho.amber.manager.AmberConnection;
import com.caucho.amber.query.AbstractQuery;
import com.caucho.amber.query.AmberSelectQuery;
import com.caucho.amber.query.ResultSetImpl;
import com.caucho.amber.query.UserQuery;
import com.caucho.amber.type.CalendarType;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.UtilDateType;
import com.caucho.ejb.EJBExceptionWrapper;
import com.caucho.util.L10N;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.TemporalType;

public class QueryImpl
implements Query {
    private static final L10N L = new L10N(QueryImpl.class);
    private static final Logger log = Logger.getLogger(QueryImpl.class.getName());
    private AbstractQuery _query;
    private UserQuery _userQuery;
    private AmberConnection _aConn;
    private int _firstResult;
    private int _currIndex;
    private FlushModeType _flushMode;
    private Class[] _primitiveColumns;
    private String _nativeSql;
    private PreparedStatement _nativeStmt;
    private SqlResultSetMappingConfig _sqlResultSetMapping;
    private int _currEntityResult;
    private int _currColumnResult;

    QueryImpl(AbstractQuery query, AmberConnection aConn) {
        this._query = query;
        this._aConn = aConn;
        this._userQuery = new UserQuery(query);
        this._userQuery.setSession(this._aConn);
    }

    QueryImpl(AmberConnection aConn) {
        this._aConn = aConn;
    }

    /*
     * WARNING - void declaration
     */
    public List getResultList() {
        ResultSet rs = null;
        try {
            if (this._aConn.isInTransaction()) {
                this._aConn.flush();
            }
            Class constructorClass = null;
            if (this.isSelectQuery()) {
                if (!this.isNativeQuery()) {
                    AmberSelectQuery selectQuery = (AmberSelectQuery)this._query;
                    constructorClass = selectQuery.getConstructorClass();
                }
            } else {
                throw new IllegalStateException(L.l("javax.persistence.Query.getResultList() can only be applied to a SELECT statement"));
            }
            Constructor constructor = null;
            ArrayList<Object> results = new ArrayList<Object>();
            rs = this.executeQuery();
            ResultSetMetaData metaData = null;
            int columnCount = -1;
            int n = 0;
            Object[] row = null;
            ArrayList<Object> columns = new ArrayList<Object>();
            while (rs.next()) {
                int n2;
                Object object = null;
                this._currIndex = 1;
                if (n == 0) {
                    void var11_15;
                    try {
                        metaData = rs.getMetaData();
                        if (metaData != null) {
                            columnCount = metaData.getColumnCount();
                        }
                    }
                    catch (Exception exception) {
                        metaData = null;
                    }
                    if (columnCount <= 0) {
                        columnCount = 10000;
                    }
                    boolean bl = true;
                    while (var11_15 <= columnCount) {
                        int columnType = -1;
                        try {
                            columnType = metaData.getColumnType((int)var11_15);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            if (this.isNativeQuery()) {
                                ArrayList<ColumnResultConfig> columnResults;
                                ArrayList<EntityResultConfig> entityResults = this._sqlResultSetMapping.getEntityResults();
                                if (this._currEntityResult == entityResults.size() && this._currColumnResult == (columnResults = this._sqlResultSetMapping.getColumnResults()).size()) break;
                                object = this.getInternalNative(rs);
                            } else {
                                object = this.getInternalObject(rs, columnType);
                            }
                            columns.add(object);
                        }
                        catch (IndexOutOfBoundsException ex1) {
                            break;
                        }
                        ++var11_15;
                    }
                    n = columns.size();
                    row = columns.toArray();
                    if (constructorClass != null) {
                        this._primitiveColumns = new Class[row.length];
                        StringBuilder stringBuilder = new StringBuilder();
                        try {
                            boolean isFirst = true;
                            for (int i3 = 0; i3 < n; ++i3) {
                                if (isFirst) {
                                    isFirst = false;
                                } else {
                                    stringBuilder.append(", ");
                                }
                                stringBuilder.append(row[i3]);
                            }
                            Constructor<?>[] ctors = constructorClass.getDeclaredConstructors();
                            ArrayList validConstructors = new ArrayList();
                            for (int j = 0; j < ctors.length; ++j) {
                                Class<?>[] paramTypes = ctors[j].getParameterTypes();
                                if (paramTypes.length != row.length) continue;
                                boolean isValid = true;
                                for (int k = 0; k < paramTypes.length; ++k) {
                                    Class<?> columnClass = row[k].getClass();
                                    if (paramTypes[k].isAssignableFrom(columnClass)) continue;
                                    if (!paramTypes[k].isPrimitive()) {
                                        isValid = false;
                                        break;
                                    }
                                    Class primitiveType = (Class)columnClass.getDeclaredField("TYPE").get(null);
                                    if (paramTypes[k].isAssignableFrom(primitiveType)) {
                                        this._primitiveColumns[k] = primitiveType;
                                        continue;
                                    }
                                    isValid = false;
                                    break;
                                }
                                if (!isValid) continue;
                                validConstructors.add(ctors[j]);
                            }
                            constructor = (Constructor)validConstructors.get(0);
                        }
                        catch (Exception ex) {
                            throw this.error(L.l("Unable to find constructor {0}. Make sure there is a public constructor for the given argument values ({1})", (Object)constructorClass.getName(), (Object)stringBuilder));
                        }
                    }
                } else {
                    row = new Object[n];
                    for (n2 = 0; n2 < n; ++n2) {
                        int columnType = -1;
                        try {
                            columnType = metaData.getColumnType(n2 + 1);
                        }
                        catch (Exception ctors) {
                            // empty catch block
                        }
                        row[n2] = this.isNativeQuery() ? this.getInternalNative(rs) : this.getInternalObject(rs, columnType);
                    }
                }
                if (constructor == null) {
                    if (n == 1) {
                        results.add(row[0]);
                        continue;
                    }
                    results.add(row);
                    continue;
                }
                try {
                    boolean bl = false;
                    while (n2 < row.length) {
                        Class primitiveType = this._primitiveColumns[n2];
                        if (primitiveType != null) {
                            if (primitiveType == Boolean.TYPE) {
                                row[n2] = (boolean)((Boolean)row[n2]);
                            } else if (primitiveType == Byte.TYPE) {
                                row[n2] = (byte)((Byte)row[n2]);
                            } else if (primitiveType == Character.TYPE) {
                                row[n2] = Character.valueOf(((Character)row[n2]).charValue());
                            } else if (primitiveType == Double.TYPE) {
                                row[n2] = (double)((Double)row[n2]);
                            } else if (primitiveType == Float.TYPE) {
                                row[n2] = Float.valueOf(((Float)row[n2]).floatValue());
                            } else if (primitiveType == Integer.TYPE) {
                                row[n2] = (int)((Integer)row[n2]);
                            } else if (primitiveType == Long.TYPE) {
                                row[n2] = (long)((Long)row[n2]);
                            } else if (primitiveType == Short.TYPE) {
                                row[n2] = (short)((Short)row[n2]);
                            }
                        }
                        ++n2;
                    }
                    object = constructor.newInstance(row);
                }
                catch (Exception exception) {
                    StringBuilder argTypes = new StringBuilder();
                    boolean isFirst = true;
                    for (int i4 = 0; i4 < row.length; ++i4) {
                        if (isFirst) {
                            isFirst = false;
                        } else {
                            argTypes.append(", ");
                        }
                        if (row[i4] == null) {
                            argTypes.append("null");
                            continue;
                        }
                        argTypes.append(row[i4].toString());
                    }
                    throw this.error(L.l("Unable to instantiate {0} with parameters ({1}).", (Object)constructorClass.getName(), (Object)argTypes));
                }
                results.add(object);
            }
            if (log.isLoggable(Level.FINER) && results != null) {
                log.log(Level.FINER, L.l("query result list size: {0}", results.size()));
                for (Object e : results) {
                    if (e == null) {
                        log.log(Level.FINER, L.l("  result entry: null"));
                        continue;
                    }
                    log.log(Level.FINER, L.l("  result entry: {0}", (Object)e.getClass().getName()));
                }
            }
            if (!this._aConn.isActiveTransaction()) {
                this._aConn.detach();
            }
            ArrayList<Object> arrayList = results;
            return arrayList;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw EJBExceptionWrapper.createRuntime(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
        }
    }

    public Object getSingleResult() {
        ResultSet rs = null;
        try {
            if (!this.isSelectQuery()) {
                throw new IllegalStateException(L.l("javax.persistence.Query.getSingleResult() can only be applied to a SELECT statement"));
            }
            rs = this.executeQuery();
            Object value = null;
            if (!rs.next()) {
                throw new NoResultException("Query returned no results for getSingleResult()");
            }
            value = rs.getObject(1);
            if (rs.next()) {
                throw new NonUniqueResultException("Query returned more than one result for getSingleResult()");
            }
            Object object = value;
            return object;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw EJBExceptionWrapper.createRuntime(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    log.log(Level.FINE, e.toString(), e);
                }
                if (!this._aConn.isActiveTransaction()) {
                    this._aConn.detach();
                }
            }
        }
    }

    public int executeUpdate() {
        try {
            if (this.isSelectQuery()) {
                throw new IllegalStateException(L.l("javax.persistence.Query.executeUpdate() cannot be applied to a SELECT statement"));
            }
            if (this._flushMode == FlushModeType.AUTO) {
                this._aConn.flushNoChecks();
            }
            return this._userQuery.executeUpdate();
        }
        catch (Exception e) {
            throw EJBExceptionWrapper.createRuntime(e);
        }
    }

    protected ResultSet executeQuery() throws SQLException {
        ResultSet rs = null;
        Object pstmt = null;
        try {
            if (this._flushMode == FlushModeType.AUTO) {
                this._aConn.flushNoChecks();
            }
            rs = this._nativeSql == null ? this._userQuery.executeQuery() : this._nativeStmt.executeQuery();
        }
        catch (SQLException e) {
            if (rs != null) {
                rs.close();
            }
            if (pstmt != null) {
                this._aConn.closeStatement(this._nativeSql);
            }
            throw e;
        }
        return rs;
    }

    public Query setMaxResults(int maxResults) {
        if (maxResults < 0) {
            throw new IllegalArgumentException(L.l("setMaxResults() needs a non-negative argument, '{0}' is not allowed", maxResults));
        }
        this._userQuery.setMaxResults(maxResults);
        return this;
    }

    public Query setFirstResult(int startPosition) {
        if (startPosition < 0) {
            throw new IllegalArgumentException("setFirstResult() requires a non-negative argument");
        }
        this._userQuery.setFirstResult(startPosition);
        return this;
    }

    public Query setHint(String hintName, Object value) {
        return this;
    }

    public Query setParameter(String name, Object value) {
        ArrayList<String> mapping = this._query.getPreparedMapping();
        int n = mapping.size();
        boolean found = false;
        for (int i = 0; i < n; ++i) {
            if (!mapping.get(i).equals(name)) continue;
            ArgExpr[] args = this._userQuery.getQuery().getArgList();
            this.setInternalParameter(args[i], i + 1, value);
            found = true;
        }
        if (!found) {
            throw new IllegalArgumentException(L.l("Parameter name '{0}' is invalid", (Object)name));
        }
        return this;
    }

    public Query setParameter(String name, Date value, TemporalType type) {
        ArrayList<String> mapping = this._query.getPreparedMapping();
        int n = mapping.size();
        boolean found = false;
        for (int i = 0; i < n; ++i) {
            if (!mapping.get(i).equals(name)) continue;
            this.setParameter(i + 1, value, type);
            found = true;
        }
        if (!found) {
            throw new IllegalArgumentException(L.l("Parameter name '{0}' is invalid", (Object)name));
        }
        return this;
    }

    public Query setParameter(String name, Calendar value, TemporalType type) {
        ArrayList<String> mapping = this._query.getPreparedMapping();
        int n = mapping.size();
        boolean found = false;
        for (int i = 0; i < n; ++i) {
            if (!mapping.get(i).equals(name)) continue;
            this.setParameter(i + 1, value, type);
            found = true;
        }
        if (!found) {
            throw new IllegalArgumentException(L.l("Parameter name '{0}' is invalid", (Object)name));
        }
        return this;
    }

    public Query setParameter(int index, Object value) {
        if (this._nativeSql == null) {
            ArgExpr arg = this.checkParameterIndex(index);
            this.setInternalParameter(arg, index, value);
        } else {
            QueryImpl.setInternalParameter(this._nativeStmt, null, index, value);
        }
        return this;
    }

    public Query setParameter(int index, Date value, TemporalType type) {
        try {
            this.checkParameterIndex(index);
            if (value == null) {
                this._userQuery.setNull(index, 2000);
            } else {
                switch (type) {
                    case TIME: {
                        this._userQuery.setObject(index, value, UtilDateType.TEMPORAL_TIME_TYPE);
                        break;
                    }
                    case DATE: {
                        this._userQuery.setObject(index, value, UtilDateType.TEMPORAL_DATE_TYPE);
                        break;
                    }
                    default: {
                        this._userQuery.setObject(index, value, UtilDateType.TEMPORAL_TIMESTAMP_TYPE);
                    }
                }
            }
            return this;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(L.l("Parameter index '{0}' is not valid for setParameter()", index));
        }
    }

    public Query setParameter(int index, Calendar value, TemporalType type) {
        try {
            this.checkParameterIndex(index);
            if (value == null) {
                this._userQuery.setNull(index, 2000);
            } else {
                switch (type) {
                    case TIME: {
                        this._userQuery.setObject(index, value, CalendarType.TEMPORAL_TIME_TYPE);
                        break;
                    }
                    case DATE: {
                        this._userQuery.setObject(index, value, CalendarType.TEMPORAL_DATE_TYPE);
                        break;
                    }
                    default: {
                        this._userQuery.setObject(index, value, CalendarType.TEMPORAL_TIMESTAMP_TYPE);
                    }
                }
            }
            return this;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(L.l("Parameter index '{0}' is not valid for setParameter()", index));
        }
    }

    public Query setFlushMode(FlushModeType mode) {
        this._flushMode = mode;
        return this;
    }

    public Query setDouble(int index, double value) {
        this._userQuery.setDouble(index, value);
        return this;
    }

    protected void setNativeSql(String sql) throws SQLException {
        this._nativeSql = sql;
        this._nativeStmt = this._aConn.prepareStatement(sql);
    }

    protected void setSqlResultSetMapping(SqlResultSetMappingConfig map) {
        this._sqlResultSetMapping = map;
    }

    private boolean isSelectQuery() {
        String sql;
        if (this._query instanceof AmberSelectQuery) {
            return true;
        }
        return this.isNativeQuery() && (sql = this._nativeSql.trim().toUpperCase(Locale.ENGLISH)).startsWith("SELECT");
    }

    private boolean isNativeQuery() {
        return this._nativeSql != null;
    }

    private AmberException error(String msg) {
        msg = msg + "\nin \"" + this._query.getQueryString() + "\"";
        return new AmberException(msg);
    }

    private Object getInternalNative(ResultSet rs) throws Exception {
        int oldEntityResult = this._currEntityResult;
        ArrayList<EntityResultConfig> entityResults = this._sqlResultSetMapping.getEntityResults();
        if (oldEntityResult == entityResults.size()) {
            ArrayList<ColumnResultConfig> columnResults = this._sqlResultSetMapping.getColumnResults();
            int oldColumnResult = this._currColumnResult;
            if (this._currColumnResult == columnResults.size()) {
                this._currColumnResult = 0;
            }
            if (entityResults.size() == 0 || oldColumnResult < columnResults.size()) {
                ++this._currColumnResult;
                if (columnResults.size() > 0) {
                    Object object = rs.getObject(this._currIndex++);
                    return object;
                }
            }
            oldEntityResult = 0;
            this._currEntityResult = 0;
        }
        ++this._currEntityResult;
        EntityResultConfig entityResult = entityResults.get(oldEntityResult);
        String className = entityResult.getEntityClass();
        EntityType entityType = this._aConn.getPersistenceUnit().getEntityType(className);
        if (entityType == null) {
            throw new IllegalStateException(L.l("Unable to locate entity '{0}' for native query.", (Object)className));
        }
        int oldIndex = this._currIndex++;
        int keyLength = entityType.getId().getKeyCount();
        ArrayList<FieldResultConfig> fieldResults = entityResult.getFieldResults();
        Entity entity = null;
        int consumed = 0;
        try {
            entity = (Entity)this._aConn.load(className, rs.getObject(oldIndex));
            ArrayList<String> columnNameList = new ArrayList<String>();
            entityType.generateNativeColumnNames(columnNameList);
            String[] columnNames = new String[columnNameList.size()];
            columnNameList.toArray(columnNames);
            entity.__caucho_load_native(rs, columnNames);
        }
        catch (Exception e) {
            throw new IllegalStateException(L.l("Unable to load an entity of class '{0}' using a native query. When mapped to @EntityResult, a native query should select all fields for the corresponding entity in '{1}'", (Object)className, (Object)this._nativeSql));
        }
        this._currIndex += consumed;
        return entity;
    }

    private Object getInternalObject(ResultSet rs, int columnType) throws Exception {
        int oldIndex;
        Object object;
        if ((object = rs.getObject(oldIndex = this._currIndex++)) instanceof Entity) {
            ArrayList<AmberExpr> resultList = ((AmberSelectQuery)this._query).getResultList();
            AmberExpr expr = resultList.get(oldIndex - 1);
            if (expr instanceof LoadEntityExpr) {
                LoadEntityExpr entityExpr = (LoadEntityExpr)expr;
                this.joinFetch((ResultSetImpl)rs, entityExpr, (Entity)object);
            }
            return object;
        }
        if (object == null) {
            return null;
        }
        switch (columnType) {
            case -7: 
            case 16: {
                if (object instanceof Boolean) break;
                object = rs.getBoolean(oldIndex);
                break;
            }
            case -6: {
                if (object instanceof Number) break;
                object = rs.getByte(oldIndex);
                break;
            }
            case 5: {
                if (object instanceof Number) break;
                object = rs.getShort(oldIndex);
                break;
            }
            case 4: {
                if (object instanceof Number) break;
                object = rs.getLong(oldIndex);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                if (object instanceof Number) break;
                object = rs.getDouble(oldIndex);
                break;
            }
            case 6: {
                if (object instanceof Number) break;
                object = Float.valueOf(rs.getFloat(oldIndex));
            }
        }
        return object;
    }

    private ArgExpr checkParameterIndex(int index) {
        ArgExpr[] args = this._userQuery.getQuery().getArgList();
        int len = args.length;
        for (int i = 0; i < len; ++i) {
            if (args[i].getIndex() != index) continue;
            return args[i];
        }
        throw new IllegalArgumentException(L.l("Parameter index '{0}' is invalid for query {1}", (Object)index, (Object)this._userQuery.getQuery()));
    }

    private void joinFetch(ResultSetImpl rs, LoadEntityExpr entityExpr, Entity entity) {
        String property = rs.getJoinFetchMap().get(entityExpr.getExpr());
        EntityType entityType = entity.__caucho_getEntityType();
        Iterator<String> eagerFieldsIterator = null;
        HashSet<String> eagerFieldNames = entityType.getEagerFieldNames();
        if (eagerFieldNames != null) {
            eagerFieldsIterator = eagerFieldNames.iterator();
        }
        if (!entityType.isFieldAccess() && property == null && eagerFieldsIterator != null && eagerFieldsIterator.hasNext()) {
            property = eagerFieldsIterator.next();
        }
        if (property != null) {
            try {
                Class cl = entityType.getInstanceClass();
                do {
                    String methodName;
                    Method method;
                    Object field;
                    if ((field = (method = cl.getDeclaredMethod(methodName = "get" + Character.toUpperCase(property.charAt(0)) + property.substring(1), null)).invoke((Object)entity, null)) == null) {
                        try {
                            methodName = "__caucho_item_" + methodName;
                            method = cl.getDeclaredMethod(methodName, AmberConnection.class);
                            field = method.invoke((Object)entity, this._aConn);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (field != null) {
                        Class<?> fieldClass = field.getClass();
                        method = fieldClass.getMethod("toString", null);
                        method.invoke(field, null);
                    }
                    property = null;
                    if (eagerFieldsIterator == null || !eagerFieldsIterator.hasNext()) continue;
                    property = eagerFieldsIterator.next();
                } while (property != null);
            }
            catch (NoSuchMethodException e) {
                log.log(Level.FINER, e.toString(), e);
            }
            catch (IllegalAccessException e) {
                log.log(Level.FINER, e.toString(), e);
            }
            catch (InvocationTargetException e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
    }

    private Query setInternalParameter(ArgExpr arg, int index, Object value) {
        try {
            boolean typeIsNumber;
            if (value == null) {
                this._userQuery.setNull(index, 2000);
                return this;
            }
            boolean valueIsNumber = value instanceof Number;
            if (valueIsNumber && arg.getType() != null && !(typeIsNumber = arg.getType().isNumeric())) {
                throw new IllegalArgumentException(L.l("Type mismatch for parameter index '{0}'. Value '{1}' for type '{2}' is not valid in query '{3}'", (Object)index, value, (Object)arg.getType().getClass().getName(), (Object)this._userQuery.getQuery().getSQL()));
            }
            QueryImpl.setInternalParameter(null, this._userQuery, index, value);
            return this;
        }
        catch (IndexOutOfBoundsException e) {
            log.log(Level.FINE, e.toString(), e);
            throw new IllegalArgumentException(L.l("Parameter index '{0}' is not valid for setParameter()", index));
        }
    }

    private static void setInternalParameter(PreparedStatement pstmt, UserQuery userQuery, int index, Object value) {
        try {
            if (value instanceof Byte) {
                byte arg = (Byte)value;
                if (pstmt == null) {
                    userQuery.setByte(index, arg);
                } else {
                    pstmt.setByte(index, arg);
                }
            } else if (value instanceof Short) {
                short arg = (Short)value;
                if (pstmt == null) {
                    userQuery.setShort(index, arg);
                } else {
                    pstmt.setShort(index, arg);
                }
            } else if (value instanceof Integer) {
                int arg = (Integer)value;
                if (pstmt == null) {
                    userQuery.setInt(index, arg);
                } else {
                    pstmt.setInt(index, arg);
                }
            } else if (value instanceof Long) {
                long arg = (Long)value;
                if (pstmt == null) {
                    userQuery.setLong(index, arg);
                } else {
                    pstmt.setLong(index, arg);
                }
            } else if (value instanceof Float) {
                float arg = ((Float)value).floatValue();
                if (pstmt == null) {
                    userQuery.setFloat(index, arg);
                } else {
                    pstmt.setFloat(index, arg);
                }
            } else if (value instanceof Double) {
                double arg = (Double)value;
                if (pstmt == null) {
                    userQuery.setDouble(index, arg);
                } else {
                    pstmt.setDouble(index, arg);
                }
            } else if (value instanceof Character) {
                if (pstmt == null) {
                    userQuery.setString(index, value.toString());
                } else {
                    pstmt.setString(index, value.toString());
                }
            } else if (value instanceof Entity) {
                Object pk = ((Entity)value).__caucho_getPrimaryKey();
                if (pstmt == null) {
                    userQuery.setObject(index, pk);
                } else {
                    pstmt.setObject(index, pk);
                }
            } else if (pstmt == null) {
                userQuery.setObject(index, value);
            } else {
                pstmt.setObject(index, value);
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            throw new IllegalArgumentException(L.l("Parameter index '{0}' is not valid for setParameter()", index));
        }
    }

    public int getMaxResults() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public int getFirstResult() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public Map getHints() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public Set<String> getSupportedHints() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public Map getNamedParameters() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public List getPositionalParameters() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public FlushModeType getFlushMode() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public Query setLockMode(LockModeType lockMode) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public LockModeType getLockMode() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public Parameter<?> getParameter(String name) {
        return null;
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        return null;
    }

    public Parameter<?> getParameter(int pos) {
        return null;
    }

    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        return null;
    }

    public <T> T getParameterValue(Parameter<T> param) {
        return null;
    }

    public Object getParameterValue(String name) {
        return null;
    }

    public Object getParameterValue(int position) {
        return null;
    }

    public Set<Parameter<?>> getParameters() {
        return null;
    }

    public boolean isBound(Parameter<?> param) {
        return false;
    }

    public <T> Query setParameter(Parameter<T> param, T value) {
        return null;
    }

    public Query setParameter(Parameter<Calendar> param, Calendar date, TemporalType type) {
        return null;
    }

    public Query setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        return null;
    }

    public <T> T unwrap(Class<T> cl) {
        return null;
    }
}

