/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.query;

import com.caucho.amber.AmberException;
import com.caucho.amber.entity.AmberEntityHome;
import com.caucho.amber.expr.AbstractPathExpr;
import com.caucho.amber.expr.AllExpr;
import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.AndExpr;
import com.caucho.amber.expr.AnyExpr;
import com.caucho.amber.expr.ArgExpr;
import com.caucho.amber.expr.BetweenExpr;
import com.caucho.amber.expr.BinaryExpr;
import com.caucho.amber.expr.CollectionIdExpr;
import com.caucho.amber.expr.EmbeddedExpr;
import com.caucho.amber.expr.EmbeddedSchemaExpr;
import com.caucho.amber.expr.EmptyExpr;
import com.caucho.amber.expr.EnumExpr;
import com.caucho.amber.expr.ExistsExpr;
import com.caucho.amber.expr.FromIdSchemaExpr;
import com.caucho.amber.expr.IdExpr;
import com.caucho.amber.expr.InExpr;
import com.caucho.amber.expr.KeyColumnExpr;
import com.caucho.amber.expr.LikeExpr;
import com.caucho.amber.expr.LiteralExpr;
import com.caucho.amber.expr.LoadEntityExpr;
import com.caucho.amber.expr.LoadExpr;
import com.caucho.amber.expr.ManyToOneExpr;
import com.caucho.amber.expr.ManyToOneJoinExpr;
import com.caucho.amber.expr.MemberExpr;
import com.caucho.amber.expr.NullExpr;
import com.caucho.amber.expr.OneToManyExpr;
import com.caucho.amber.expr.OneToManySchemaExpr;
import com.caucho.amber.expr.OrExpr;
import com.caucho.amber.expr.PathExpr;
import com.caucho.amber.expr.SchemaExpr;
import com.caucho.amber.expr.SubSelectExpr;
import com.caucho.amber.expr.TableIdExpr;
import com.caucho.amber.expr.UnaryExpr;
import com.caucho.amber.expr.fun.AbsFunExpr;
import com.caucho.amber.expr.fun.ConcatFunExpr;
import com.caucho.amber.expr.fun.CurrentDateFunExpr;
import com.caucho.amber.expr.fun.CurrentTimeFunExpr;
import com.caucho.amber.expr.fun.CurrentTimestampFunExpr;
import com.caucho.amber.expr.fun.DateTimeFunExpr;
import com.caucho.amber.expr.fun.FunExpr;
import com.caucho.amber.expr.fun.LengthFunExpr;
import com.caucho.amber.expr.fun.LocateFunExpr;
import com.caucho.amber.expr.fun.LowerFunExpr;
import com.caucho.amber.expr.fun.MaxFunExpr;
import com.caucho.amber.expr.fun.MinFunExpr;
import com.caucho.amber.expr.fun.ModFunExpr;
import com.caucho.amber.expr.fun.SizeFunExpr;
import com.caucho.amber.expr.fun.SqrtFunExpr;
import com.caucho.amber.expr.fun.SubstringFunExpr;
import com.caucho.amber.expr.fun.SumFunExpr;
import com.caucho.amber.expr.fun.TrimFunExpr;
import com.caucho.amber.expr.fun.UpperFunExpr;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.query.AbstractQuery;
import com.caucho.amber.query.AmberDeleteQuery;
import com.caucho.amber.query.AmberSelectQuery;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.QueryParseException;
import com.caucho.amber.query.UpdateQuery;
import com.caucho.amber.table.AmberTable;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.type.AmberBeanType;
import com.caucho.amber.type.EntityType;
import com.caucho.jdbc.JdbcMetaData;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;

public class QueryParser {
    static final Logger log = Logger.getLogger(QueryParser.class.getName());
    static final L10N L = new L10N(QueryParser.class);
    public static final int IDENTIFIER = 128;
    public static final int INTEGER = 129;
    public static final int LONG = 130;
    public static final int DOUBLE = 131;
    public static final int STRING = 132;
    public static final int TRUE = 133;
    public static final int FALSE = 134;
    public static final int UNKNOWN = 135;
    public static final int MEMBER = 136;
    public static final int OF = 137;
    public static final int EMPTY = 138;
    public static final int NULL = 139;
    public static final int FROM = 140;
    public static final int IN = 141;
    public static final int SELECT = 142;
    public static final int UPDATE = 143;
    public static final int DELETE = 144;
    public static final int DISTINCT = 145;
    public static final int WHERE = 146;
    public static final int AS = 147;
    public static final int SET = 148;
    public static final int ORDER = 149;
    public static final int GROUP = 150;
    public static final int BY = 151;
    public static final int ASC = 152;
    public static final int DESC = 153;
    public static final int LIMIT = 154;
    public static final int OFFSET = 155;
    public static final int JOIN = 156;
    public static final int INNER = 157;
    public static final int LEFT = 158;
    public static final int OUTER = 159;
    public static final int FETCH = 160;
    public static final int BETWEEN = 161;
    public static final int LIKE = 162;
    public static final int ESCAPE = 163;
    public static final int IS = 164;
    public static final int CONCAT_OP = 165;
    public static final int EQ = 166;
    public static final int NE = 167;
    public static final int LT = 168;
    public static final int LE = 169;
    public static final int GT = 170;
    public static final int GE = 171;
    public static final int AND = 172;
    public static final int OR = 173;
    public static final int NOT = 174;
    public static final int LENGTH = 175;
    public static final int LOCATE = 176;
    public static final int ABS = 177;
    public static final int SQRT = 178;
    public static final int MOD = 179;
    public static final int SIZE = 180;
    public static final int MAX = 181;
    public static final int MIN = 182;
    public static final int SUM = 183;
    public static final int CONCAT = 184;
    public static final int LOWER = 185;
    public static final int UPPER = 186;
    public static final int SUBSTRING = 187;
    public static final int TRIM = 188;
    public static final int BOTH = 189;
    public static final int LEADING = 190;
    public static final int TRAILING = 191;
    public static final int CURRENT_DATE = 192;
    public static final int CURRENT_TIME = 193;
    public static final int CURRENT_TIMESTAMP = 194;
    public static final int EXTERNAL_DOT = 195;
    public static final int ARG = 196;
    public static final int NAMED_ARG = 197;
    public static final int NEW = 198;
    public static final int THIS = 199;
    public static final int NOT_NULL = 200;
    public static final int HAVING = 201;
    private static IntMap _reserved = new IntMap();
    private AmberPersistenceUnit _persistenceUnit;
    private String _sql;
    private boolean _isLazyResult;
    private AbstractQuery _query;
    private HashMap<PathExpr, PathExpr> _pathMap = new HashMap();
    private int _parseIndex;
    private int _token;
    private int _unique;
    private int _parameterCount;
    private String _lexeme;
    private ArrayList<ArgExpr> _argList = new ArrayList();
    private HashMap<AmberExpr, String> _joinFetchMap;
    ArrayList<AmberExpr> _groupList = null;
    private int _sqlArgCount;
    private FromItem.JoinSemantics _joinSemantics = FromItem.JoinSemantics.UNKNOWN;
    private boolean _isJoinFetch = false;
    private int _depth = 0;
    private boolean _parsingResult;
    private boolean _parsingFrom;
    private boolean _parsingHaving;
    private boolean _isSizeFunExpr;
    private AmberExpr _havingExpr;
    ArrayList<AmberExpr> _appendResultList = null;
    private boolean _isDerbyDBMS;
    private boolean _isPostgresDBMS;

    public QueryParser(String query) {
        this._sql = query;
    }

    public boolean isDerbyDBMS() {
        return this._isDerbyDBMS;
    }

    public boolean isPostgresDBMS() {
        return this._isPostgresDBMS;
    }

    public void setPersistenceUnit(AmberPersistenceUnit persistenceUnit) {
        this._persistenceUnit = persistenceUnit;
        this._isDerbyDBMS = false;
        this._isPostgresDBMS = false;
        if (persistenceUnit == null) {
            return;
        }
        this._isDerbyDBMS = !persistenceUnit.hasPositionFunction();
        this._isPostgresDBMS = persistenceUnit.getFalseLiteral().equalsIgnoreCase("false");
    }

    public void setLazyResult(boolean isLazy) {
        this._isLazyResult = isLazy;
    }

    public String getQuery() {
        return this._sql;
    }

    public AbstractQuery getSelectQuery() {
        return this._query;
    }

    private void init() {
        this._parseIndex = 0;
        this._unique = 0;
        this._token = -1;
        this._depth = 0;
        this._parsingResult = false;
        this._parsingFrom = false;
        this._parsingHaving = false;
        this._havingExpr = null;
        this._appendResultList = null;
        this._groupList = null;
        this._joinFetchMap = new HashMap();
    }

    public int generateSQLArg() {
        return this._sqlArgCount++;
    }

    public AbstractQuery parse() throws AmberException {
        this.init();
        int token = this.scanToken();
        if (token == 143) {
            return this.parseUpdate();
        }
        if (token == 144) {
            return this.parseDelete();
        }
        this._token = token;
        return this.parseSelect(false);
    }

    private AmberSelectQuery parseSelect(boolean innerSelect) throws QueryParseException {
        int token;
        int oldParseIndex = this._parseIndex;
        int oldToken = this._token;
        FromItem.JoinSemantics oldJoinSemantics = this._joinSemantics;
        boolean oldIsJoinFetch = this._isJoinFetch;
        AbstractQuery oldQuery = this._query;
        int oldDepth = this._depth;
        AmberExpr oldHavingExpr = this._havingExpr;
        ArrayList<AmberExpr> oldAppendResultList = this._appendResultList;
        this._depth = 0;
        this._havingExpr = null;
        this._appendResultList = null;
        AmberSelectQuery query = new AmberSelectQuery(this._sql, this.getMetaData());
        query.setParentQuery(this._query);
        this._query = query;
        while ((token = this.scanToken()) >= 0 && (token != 140 || this._depth > 0)) {
        }
        boolean hasFrom = token == 140;
        this._token = token;
        if (hasFrom) {
            this._parsingFrom = true;
            do {
                this.scanToken();
                this._isJoinFetch = false;
                if (token == 156 && (token = this.peekToken()) == 160) {
                    this.scanToken();
                    this._isJoinFetch = true;
                }
                FromItem from = this.parseFrom();
                token = this.peekToken();
                this._joinSemantics = FromItem.JoinSemantics.UNKNOWN;
                if (token == 157) {
                    this.scanToken();
                    token = this.peekToken();
                    if (token != 156) {
                        throw this.error(L.l("expected JOIN at {0}", (Object)this.tokenName(token)));
                    }
                    this._joinSemantics = FromItem.JoinSemantics.INNER;
                    continue;
                }
                if (token == 158) {
                    this.scanToken();
                    token = this.peekToken();
                    if (token == 159) {
                        this.scanToken();
                        token = this.peekToken();
                    }
                    if (token != 156) {
                        throw this.error(L.l("expected JOIN at {0}", (Object)this.tokenName(token)));
                    }
                    this._joinSemantics = FromItem.JoinSemantics.OUTER;
                    continue;
                }
                if (token != 156) continue;
                this._joinSemantics = FromItem.JoinSemantics.INNER;
            } while (token == 44 || token == 156);
            this._parsingFrom = false;
        }
        int fromParseIndex = this._parseIndex;
        int fromToken = this._token;
        this._parseIndex = oldParseIndex;
        this._token = oldToken;
        ArrayList<AmberExpr> resultList = new ArrayList<AmberExpr>();
        this._parsingResult = true;
        if (this.peekToken() == 142) {
            this.scanToken();
            if (this.peekToken() == 145) {
                this.scanToken();
                query.setDistinct(true);
            }
            String constructorName = null;
            if (this.peekToken() == 198) {
                this.scanToken();
                String s = "";
                boolean isDot = false;
                while ((token = this.scanToken()) != 40) {
                    if (!isDot) {
                        s = s + this._lexeme;
                        isDot = true;
                        continue;
                    }
                    if (token == 46) {
                        s = s + '.';
                        isDot = false;
                        continue;
                    }
                    throw this.error(L.l("Constructor with SELECT NEW must be fully qualified. Expected '.' at {0}", (Object)this.tokenName(token)));
                }
                constructorName = s;
            }
            do {
                AmberExpr expr = this.parseExpr();
                if (!hasFrom) {
                    if (!(expr instanceof DateTimeFunExpr)) {
                        throw this.error(L.l("expected FROM clause when the select clause has not date/time functions only"));
                    }
                } else {
                    if (expr == null) continue;
                    expr = expr.bindSelect(this);
                    if (!this._isLazyResult && expr instanceof PathExpr) {
                        PathExpr pathExpr = (PathExpr)expr;
                        FromItem rootItem = null;
                        AmberBeanType targetType = pathExpr.getTargetType();
                        if (targetType instanceof EntityType) {
                            EntityType relatedType;
                            EntityType parentType = relatedType = (EntityType)targetType;
                            while (parentType.getParentType() != null && parentType.getParentType() instanceof EntityType) {
                                parentType = parentType.getParentType();
                            }
                            if (parentType != relatedType) {
                                FromItem child = pathExpr.getChildFromItem();
                                AmberTable table = relatedType.getTable();
                                ArrayList<LinkColumns> outgoingLinks = table.getOutgoingLinks();
                                for (LinkColumns link : outgoingLinks) {
                                    if (!link.getTargetTable().equals(parentType.getTable())) continue;
                                    rootItem = this.addFromItem(parentType, parentType.getTable());
                                    ManyToOneJoinExpr join = new ManyToOneJoinExpr(link, rootItem, child);
                                    rootItem.setJoinExpr(join);
                                    rootItem.setJoinSemantics(FromItem.JoinSemantics.INNER);
                                    break;
                                }
                            }
                        }
                        expr = LoadExpr.create(pathExpr, rootItem);
                        expr = expr.bindSelect(this);
                    }
                }
                resultList.add(expr);
            } while ((token = this.scanToken()) == 44);
            query.setHasFrom(hasFrom);
            if (hasFrom && constructorName != null) {
                if (token != 41) {
                    throw this.error(L.l("Expected ')' at {0} when calling constructor with SELECT NEW", (Object)this.tokenName(token)));
                }
                token = this.scanToken();
                try {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    Class<?> cl = Class.forName(constructorName, false, loader);
                    query.setConstructorClass(cl);
                }
                catch (ClassNotFoundException ex) {
                    throw this.error(L.l("Unable to find class {0}. Make sure the class is fully qualified.", (Object)constructorName));
                }
            }
            this._token = token;
        }
        if (hasFrom && this.peekToken() != 140) {
            throw this.error(L.l("expected FROM at {0}", (Object)this.tokenName(token)));
        }
        if (resultList.size() == 0) {
            if (this._joinFetchMap.size() > 0) {
                throw this.error(L.l("All associations referenced by JOIN FETCH must belong to an entity that is returned as a result of the query"));
            }
            ArrayList<FromItem> fromList = this._query.getFromList();
            if (fromList.size() > 0) {
                FromItem fromItem = fromList.get(0);
                AmberExpr expr = fromItem.getIdExpr();
                if (!this._isLazyResult && expr instanceof PathExpr) {
                    PathExpr pathExpr = expr;
                    expr = LoadExpr.create(pathExpr);
                    expr = expr.bindSelect(this);
                }
                resultList.add(expr);
            }
        } else if (hasFrom) {
            int size = resultList.size();
            int matches = 0;
            for (int i = 0; i < size; ++i) {
                AmberExpr expr = resultList.get(i);
                if (!(expr instanceof LoadEntityExpr) || this._joinFetchMap.get(expr = ((LoadEntityExpr)expr).getExpr()) == null) continue;
                ++matches;
            }
            if (matches < this._joinFetchMap.size()) {
                throw this.error(L.l("All associations referenced by JOIN FETCH must belong to an entity that is returned as a result of the query"));
            }
        }
        if (this._appendResultList != null) {
            resultList.addAll(this._appendResultList);
        }
        query.setResultList(resultList);
        this._parsingResult = false;
        this._parseIndex = fromParseIndex;
        this._token = fromToken;
        token = this.peekToken();
        boolean hasWhere = false;
        if (token == 146) {
            this.scanToken();
            hasWhere = true;
            AmberExpr expr = this.parseExpr();
            if (expr != null) {
                expr = expr.createBoolean();
                query.setWhere(expr.bindSelect(this));
            }
        }
        boolean hasGroupBy = false;
        ArrayList<AmberExpr> groupList = this._groupList;
        token = this.peekToken();
        if (token == 150) {
            this.scanToken();
            if (this.peekToken() == 151) {
                this.scanToken();
                hasGroupBy = true;
            }
            if (groupList == null) {
                groupList = new ArrayList();
            }
            while (true) {
                AmberExpr groupExpr = this.parseExpr();
                if ((groupExpr = groupExpr.bindSelect(this)) instanceof PathExpr) {
                    PathExpr pathExpr = (PathExpr)groupExpr;
                    groupExpr = LoadExpr.create(pathExpr);
                    groupExpr = groupExpr.bindSelect(this);
                }
                groupList.add(groupExpr);
                if (this.peekToken() != 44) break;
                this.scanToken();
            }
            query.setGroupList(groupList);
            this._groupList = null;
        }
        if ((token = this.peekToken()) == 201) {
            if (!hasGroupBy) {
                throw this.error(L.l("Use of HAVING without GROUP BY is not currently supported"));
            }
            this._parsingHaving = true;
            this.scanToken();
            AmberExpr havingExpr = this.parseExpr();
            if (this._havingExpr != null) {
                havingExpr = AndExpr.create(havingExpr, this._havingExpr);
            }
            query.setHaving(havingExpr.createBoolean().bindSelect(this));
            this._parsingHaving = false;
        } else if (hasWhere && this._havingExpr != null) {
            query.setHaving(this._havingExpr.createBoolean().bindSelect(this));
        }
        token = this.peekToken();
        if (token == 149) {
            this.scanToken();
            if (this.peekToken() == 151) {
                this.scanToken();
            }
            ArrayList<AmberExpr> orderList = new ArrayList<AmberExpr>();
            ArrayList<Boolean> ascList = new ArrayList<Boolean>();
            while (true) {
                AmberExpr expr;
                if (this.isCollectionExpr(expr = this.parseExpr())) {
                    throw this.error(L.l("Unexpected collection at ORDER BY '{0}'.", (Object)expr.getClass().getName()));
                }
                expr = expr.bindSelect(this);
                orderList.add(expr);
                if (this.peekToken() == 153) {
                    this.scanToken();
                    ascList.add(Boolean.FALSE);
                } else if (this.peekToken() == 152) {
                    this.scanToken();
                    ascList.add(Boolean.TRUE);
                } else {
                    ascList.add(Boolean.TRUE);
                }
                if (this.peekToken() != 44) break;
                this.scanToken();
            }
            query.setOrderList(orderList, ascList);
        }
        if ((token = this.peekToken()) == 155) {
            this.scanToken();
            token = this.scanToken();
            if (token != 129) {
                throw this.error(L.l("Expected INTEGER at {0}", (Object)this.tokenName(token)));
            }
            int offset = Integer.parseInt(this._lexeme);
            token = this.peekToken();
            query.setOffset(offset);
        }
        if (token == 154) {
            this.scanToken();
            token = this.scanToken();
            if (token != 129) {
                throw this.error(L.l("Expected INTEGER at {0}", (Object)this.tokenName(token)));
            }
            int limit = Integer.parseInt(this._lexeme);
            query.setLimit(limit);
            token = this.peekToken();
        }
        if (!innerSelect) {
            query.setJoinFetchMap(this._joinFetchMap);
            if (token > 0) {
                throw this.error(L.l("expected end of query at {0}", (Object)this.tokenName(token)));
            }
            if (!query.setArgList(this._argList.toArray(new ArgExpr[this._argList.size()]))) {
                throw this.error(L.l("Unable to parse all query parameters. Make sure named parameters are not mixed with positional parameters"));
            }
        }
        query.init();
        this._joinSemantics = oldJoinSemantics;
        this._isJoinFetch = oldIsJoinFetch;
        this._query = oldQuery;
        this._depth = oldDepth;
        this._havingExpr = oldHavingExpr;
        this._appendResultList = oldAppendResultList;
        return query;
    }

    private AbstractQuery parseUpdate() throws QueryParseException {
        UpdateQuery query = new UpdateQuery(this._sql, this.getMetaData());
        this._query = query;
        FromItem fromItem = this.parseFrom();
        int token = this.scanToken();
        if (token != 148) {
            throw this.error(L.l("expected 'SET' at {0}", (Object)this.tokenName(token)));
        }
        ArrayList<AmberExpr> fields = new ArrayList<AmberExpr>();
        ArrayList<AmberExpr> values = new ArrayList<AmberExpr>();
        this.parseSetValues(fromItem, fields, values);
        query.setFieldList(fields);
        query.setValueList(values);
        token = this.scanToken();
        if (token == 146) {
            AmberExpr expr = this.parseExpr();
            query.setWhere(expr.createBoolean().bindSelect(this));
            token = this.scanToken();
        }
        if (token >= 0) {
            throw this.error(L.l("'{0}' not expected at end of query.", (Object)this.tokenName(token)));
        }
        if (!query.setArgList(this._argList.toArray(new ArgExpr[this._argList.size()]))) {
            throw this.error(L.l("Unable to parse all query parameters. Make sure named parameters are not mixed with positional parameters"));
        }
        query.init();
        return query;
    }

    private AbstractQuery parseDelete() throws QueryParseException {
        AmberDeleteQuery query = new AmberDeleteQuery(this._sql, this.getMetaData());
        this._query = query;
        int token = this.peekToken();
        if (token == 140) {
            this.scanToken();
        }
        FromItem fromItem = this.parseFrom();
        token = this.scanToken();
        if (token == 146) {
            query.setWhere(this.parseExpr().createBoolean().bindSelect(this));
            token = this.scanToken();
        }
        if (token >= 0) {
            throw this.error(L.l("'{0}' not expected at end of query.", (Object)this.tokenName(token)));
        }
        if (!query.setArgList(this._argList.toArray(new ArgExpr[this._argList.size()]))) {
            throw this.error(L.l("Unable to parse all query parameters. Make sure named parameters are not mixed with positional parameters"));
        }
        query.init();
        return query;
    }

    private void parseSetValues(FromItem fromItem, ArrayList<AmberExpr> fields, ArrayList<AmberExpr> values) throws QueryParseException {
        EntityType entity = fromItem.getEntityType();
        int token = -1;
        do {
            token = this.scanToken();
            AmberExpr expr = null;
            String name = this._lexeme.toString();
            IdExpr tableExpr = this.getIdentifier(name);
            if (tableExpr != null) {
                expr = this.parsePath(tableExpr);
            } else {
                tableExpr = fromItem.getIdExpr();
                AmberExpr next = tableExpr.createField(this, name);
                if (next instanceof PathExpr) {
                    expr = this.addPath((PathExpr)next);
                } else if (next != null) {
                    expr = next;
                }
            }
            expr = expr.bindSelect(this);
            fields.add(expr);
            token = this.peekToken();
            if (token != 166) {
                throw this.error(L.l("expected '=' at {0}", (Object)this.tokenName(token)));
            }
            this.scanToken();
            expr = this.parseConcatExpr();
            if (expr.hasRelationship()) {
                throw this.error(L.l("UPDATE cannot set values with relationships. Unexpected path expression at {0}", (Object)expr));
            }
            expr = expr.bindSelect(this);
            values.add(expr);
        } while ((token = this.scanToken()) == 44);
        this._token = token;
    }

    private FromItem parseFrom() throws QueryParseException {
        String id;
        SchemaExpr schema = this.parseSchema();
        int token = this.peekToken();
        if (token == 147) {
            this.scanToken();
            token = this.peekToken();
            id = this.parseIdentifier();
        } else {
            id = token == 128 ? this.parseIdentifier() : (schema instanceof OneToManySchemaExpr ? this.createTableName() : schema.getTailName());
        }
        FromItem item = schema.addFromItem(this, id);
        if (schema instanceof EmbeddedSchemaExpr) {
            EmbeddedSchemaExpr embeddedSchema = (EmbeddedSchemaExpr)schema;
            this._query.addEmbeddedAlias(id, embeddedSchema.getExpr());
        }
        item.setJoinSemantics(this._joinSemantics);
        return item;
    }

    public FromItem addFromItem(AmberTable table) {
        return this.addFromItem(null, table, this.createTableName());
    }

    public FromItem addFromItem(EntityType entityType, AmberTable table) {
        return this.addFromItem(entityType, table, this.createTableName());
    }

    public String createTableName() {
        return "caucho" + this._unique++;
    }

    public FromItem addFromItem(AmberTable table, String id) {
        return this.addFromItem(null, table, id);
    }

    public FromItem addFromItem(EntityType entityType, AmberTable table, String id) {
        if (id == null) {
            id = this.createTableName();
        }
        FromItem item = this._query.createFromItem(entityType, table, id);
        item.setJoinSemantics(this._joinSemantics);
        return item;
    }

    public FromItem createDependentFromItem(FromItem item, LinkColumns link) {
        item = this._query.createDependentFromItem(item, link, this.createTableName());
        item.setJoinSemantics(this._joinSemantics);
        return item;
    }

    void addLink(AmberExpr expr) {
        throw new IllegalStateException();
    }

    public PathExpr addPath(PathExpr path) {
        PathExpr oldPath = this._pathMap.get(path);
        if (oldPath != null) {
            return oldPath;
        }
        this._pathMap.put(path, path);
        return path;
    }

    public void addArg(ArgExpr arg) {
        this._argList.add(arg);
    }

    private SchemaExpr parseSchema() throws QueryParseException {
        AmberEntityHome home;
        boolean isIn;
        int token = this.peekToken();
        boolean bl = isIn = token == 141;
        if (isIn) {
            this.scanToken();
            this._joinSemantics = FromItem.JoinSemantics.INNER;
            token = this.scanToken();
            if (token != 40) {
                throw this.error(L.l("expected '(' at '{0}'", (Object)this.tokenName(token)));
            }
        }
        String name = this.parseIdentifier();
        SchemaExpr schema = null;
        if (!isIn && (home = this._persistenceUnit.getHomeBySchema(name)) != null) {
            EntityType type = home.getEntityType();
            schema = new TableIdExpr(home.getEntityType(), type.getTable().getName());
        }
        IdExpr id = null;
        if (schema == null && (id = this.getIdentifier(name)) != null) {
            schema = new FromIdSchemaExpr(id);
        }
        if (!isIn && schema == null) {
            while (this.peekToken() == 46) {
                this.scanToken();
                String segment = this.parseIdentifier();
                AmberEntityHome home2 = this._persistenceUnit.getHomeBySchema(name = name + '.' + segment);
                if (home2 == null) continue;
                schema = new TableIdExpr(home2.getEntityType(), name);
                break;
            }
        }
        if (schema == null) {
            throw this.error(L.l("'{0}' is an unknown entity.", (Object)name));
        }
        name = "";
        boolean isFirst = true;
        while (this.peekToken() == 46) {
            this.scanToken();
            String segment = this.parseIdentifier();
            if (isFirst) {
                name = name + segment;
                isFirst = false;
            } else {
                name = name + "." + segment;
            }
            schema = schema.createField(this, segment);
        }
        if (this._isJoinFetch && !name.equals("")) {
            this._joinFetchMap.put(id, name);
        }
        if (isIn && (token = this.scanToken()) != 41) {
            throw this.error(L.l("expected ')' at '{0}'", (Object)this.tokenName(token)));
        }
        return schema;
    }

    private AmberExpr parseExpr() throws QueryParseException {
        if (this.peekToken() == 142) {
            AmberSelectQuery select = this.parseSelect(true);
            return new SubSelectExpr(select);
        }
        AmberExpr expr = this.parseOrExpr();
        return expr;
    }

    private AmberExpr parseOrExpr() throws QueryParseException {
        AmberExpr expr = this.parseAndExpr();
        OrExpr orExpr = null;
        while (this.peekToken() == 173) {
            AmberExpr andExpr;
            this.scanToken();
            if (orExpr == null) {
                orExpr = new OrExpr();
                orExpr.add(expr);
            }
            if ((andExpr = this.parseAndExpr()) == null) continue;
            orExpr.add(andExpr);
        }
        return orExpr == null ? expr : orExpr;
    }

    private AmberExpr parseAndExpr() throws QueryParseException {
        AmberExpr expr = this.parseNotExpr();
        AndExpr andExpr = null;
        while (this.peekToken() == 172) {
            AmberExpr notExpr;
            this.scanToken();
            if (andExpr == null) {
                andExpr = new AndExpr();
                andExpr.add(expr);
            }
            if ((notExpr = this.parseNotExpr()) == null) continue;
            andExpr.add(notExpr);
        }
        return andExpr == null ? expr : andExpr;
    }

    private AmberExpr parseNotExpr() throws QueryParseException {
        AmberExpr expr;
        if (this.peekToken() == 174) {
            this.scanToken();
            expr = new UnaryExpr(174, this.parseCmpExpr());
        } else {
            expr = this.parseCmpExpr();
        }
        if (this._parsingResult || this._parsingHaving) {
            return expr;
        }
        if (!this._isSizeFunExpr) {
            return expr;
        }
        if (this._havingExpr == null) {
            this._havingExpr = expr;
        } else if (expr != null) {
            this._havingExpr = AndExpr.create(this._havingExpr, expr);
        }
        return null;
    }

    private AmberExpr parseCmpExpr() throws QueryParseException {
        AmberExpr expr = this.parseConcatExpr();
        int token = this.peekToken();
        boolean isNot = false;
        if (token == 174) {
            this.scanToken();
            isNot = true;
            token = this.peekToken();
            if (token != 161 && token != 162 && token != 136 && token != 141) {
                throw this.error(L.l("'NOT' is not expected here."));
            }
        }
        if (token >= 166 && token <= 171) {
            this.scanToken();
            AmberExpr concatExpr = this.parseConcatExpr();
            return this.parseIs(new BinaryExpr(token, expr, concatExpr));
        }
        if (token == 161) {
            this.scanToken();
            AmberExpr min = this.parseConcatExpr();
            token = this.scanToken();
            if (token != 172) {
                throw this.error(L.l("Expected 'AND' at {0}", (Object)this.tokenName(token)));
            }
            AmberExpr max = this.parseConcatExpr();
            if (!this.isCompatibleExpression(expr, min)) {
                throw this.error(L.l("Expected compatible expression at {0} BETWEEN {1}", (Object)expr, (Object)min));
            }
            if (!this.isCompatibleExpression(expr, max)) {
                throw this.error(L.l("Expected compatible expression at BETWEEN {0} AND {1}", (Object)min, (Object)max));
            }
            return new BetweenExpr(expr, min, max, isNot);
        }
        if (token == 162) {
            LiteralExpr literalExpr;
            this.scanToken();
            AmberExpr pattern = this.parseConcatExpr();
            if (pattern instanceof LiteralExpr ? (literalExpr = (LiteralExpr)pattern).getJavaType() != String.class : !(pattern instanceof ArgExpr)) {
                throw this.error(L.l("Expected string at {0}", (Object)pattern));
            }
            String escape = null;
            if (this.peekToken() == 163) {
                this.scanToken();
                token = this.scanToken();
                if (token != 132) {
                    throw this.error(L.l("Expected string at {0}", (Object)this.tokenName(token)));
                }
                escape = this._lexeme.toString();
            }
            return this.parseIs(new LikeExpr(expr, pattern, escape, isNot));
        }
        if (token == 141) {
            IdExpr idExpr;
            this.scanToken();
            token = this.scanToken();
            if (token != 40) {
                throw this.error(L.l("Expected '(' after IN at {0}", (Object)this.tokenName(token)));
            }
            ArrayList<AmberExpr> args = new ArrayList<AmberExpr>();
            while ((token = this.peekToken()) > 0 && token != 41) {
                AmberExpr arg = this.parseExpr();
                args.add(arg);
                token = this.peekToken();
                if (token != 44) continue;
                this.scanToken();
                token = this.peekToken();
            }
            if (this.peekToken() != 41) {
                throw this.error(L.l("Expected ')' after IN at {0}", (Object)this.tokenName(token)));
            }
            this.scanToken();
            if (expr instanceof IdExpr && (idExpr = (IdExpr)expr).getFromItem().isEntityType()) {
                throw this.error(L.l("Unexpected entity at '{0} IN'", (Object)expr));
            }
            return new InExpr(expr, args, isNot);
        }
        if (token == 136) {
            this.scanToken();
            token = this.peekToken();
            if (token == 137) {
                token = this.scanToken();
            }
            AmberExpr collection = this.parseExpr();
            if (expr instanceof ArgExpr) {
                this.addArg((ArgExpr)expr);
            } else if (!(expr instanceof PathExpr)) {
                throw this.error(L.l("MEMBER OF requires an entity-valued item."));
            }
            if (!this.isCollectionExpr(collection)) {
                throw this.error(L.l("MEMBER OF requires an entity-valued collection at '{0}'.", (Object)collection.getClass().getName()));
            }
            return this.parseIs(MemberExpr.create(this, expr, collection, isNot));
        }
        return this.parseIs(expr);
    }

    private AmberExpr parseIs(AmberExpr expr) throws QueryParseException {
        int token = this.peekToken();
        if (token != 164) {
            return expr;
        }
        this.scanToken();
        boolean isNot = false;
        token = this.scanToken();
        if (token == 174) {
            isNot = true;
            token = this.scanToken();
        }
        if (token == 139) {
            IdExpr idExpr;
            if (expr instanceof KeyColumnExpr) {
                expr = ((KeyColumnExpr)expr).getParent();
            } else if (expr instanceof IdExpr && (idExpr = (IdExpr)expr).getFromItem().isEntityType()) {
                throw this.error(L.l("Unexpected entity at '{0} IS'", (Object)expr));
            }
            if (isNot) {
                return new UnaryExpr(200, expr);
            }
            return new UnaryExpr(139, expr);
        }
        if (token == 138) {
            if (!this.isCollectionExpr(expr)) {
                throw this.error(L.l("IS EMPTY requires an entity-valued collection at '{0}'.", (Object)expr.getClass().getName()));
            }
            expr = new EmptyExpr(expr);
            if (!isNot) {
                expr = new UnaryExpr(174, expr);
            }
            return expr;
        }
        throw this.error(L.l("expected NULL at '{0}'", (Object)this.tokenName(token)));
    }

    private AmberExpr parseConcatExpr() throws QueryParseException {
        AmberExpr expr = this.parseAddExpr();
        block3: while (true) {
            int token = this.peekToken();
            switch (token) {
                case 165: {
                    this.scanToken();
                    ArrayList<AmberExpr> args = new ArrayList<AmberExpr>();
                    args.add(expr);
                    args.add(this.parseAddExpr());
                    expr = ConcatFunExpr.create(this, args);
                    continue block3;
                }
            }
            break;
        }
        return expr;
    }

    private AmberExpr parseAddExpr() throws QueryParseException {
        AmberExpr expr = this.parseMulExpr();
        block3: while (true) {
            int token = this.peekToken();
            switch (token) {
                case 43: 
                case 45: {
                    this.scanToken();
                    expr = new BinaryExpr(token, expr, this.parseMulExpr());
                    continue block3;
                }
            }
            break;
        }
        return expr;
    }

    private AmberExpr parseMulExpr() throws QueryParseException {
        AmberExpr expr = this.parseTerm();
        block3: while (true) {
            int token = this.peekToken();
            switch (token) {
                case 42: 
                case 47: {
                    this.scanToken();
                    expr = new BinaryExpr(token, expr, this.parseTerm());
                    continue block3;
                }
            }
            break;
        }
        return expr;
    }

    private AmberExpr parseTerm() throws QueryParseException {
        int token = this.peekToken();
        switch (token) {
            case 43: 
            case 45: 
            case 174: {
                this.scanToken();
                return new UnaryExpr(token, this.parseTerm());
            }
        }
        return this.parseSimpleTerm();
    }

    private AmberExpr parseSimpleTerm() throws QueryParseException {
        int token = this.scanToken();
        switch (token) {
            case 128: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: {
                String name = this._lexeme.toString();
                if (this.peekToken() != 40) {
                    AmberExpr amberExpr;
                    AbstractPathExpr tableExpr = this.getIdentifier(name);
                    if (tableExpr == null) {
                        tableExpr = this.getEmbeddedAlias(name);
                    }
                    if (tableExpr == null && (amberExpr = this.parseEnum(name)) != null) {
                        return amberExpr;
                    }
                    if (tableExpr != null) {
                        amberExpr = this.parsePath(tableExpr);
                        return amberExpr;
                    }
                    if (this._query.getFromList().size() == 0) {
                        throw this.error(L.l("Expected a FROM clause before '{0}'", (Object)name));
                    }
                    FromItem fromItem = this._query.getFromList().get(0);
                    tableExpr = fromItem.getIdExpr();
                    AmberExpr next = tableExpr.createField(this, name);
                    if (next instanceof PathExpr) {
                        return this.addPath((PathExpr)next);
                    }
                    if (next != null) {
                        return next;
                    }
                    throw this.error(L.l("'{0}' is an unknown table or column", (Object)name));
                }
                if ((name = name.toLowerCase(Locale.ENGLISH)).equals("exists") || name.equals("all") || name.equals("any") || name.equals("some")) {
                    this.scanToken();
                    if (this.peekToken() != 142 && this.peekToken() != 140) {
                        throw this.error(L.l(name.toUpperCase(Locale.ENGLISH) + " requires '(SELECT'"));
                    }
                    AmberSelectQuery select = this.parseSelect(true);
                    if (this.peekToken() != 41) {
                        throw this.error(L.l(name.toUpperCase(Locale.ENGLISH) + " requires ')'"));
                    }
                    this.scanToken();
                    ArrayList<FromItem> parentFromList = select.getParentQuery().getFromList();
                    select.getFromList().addAll(0, parentFromList);
                    if (name.equals("exists")) {
                        return new ExistsExpr(select);
                    }
                    if (name.equals("all")) {
                        return new AllExpr(select);
                    }
                    return new AnyExpr(select);
                }
                return this.parseFunction(name, token);
            }
            case 192: 
            case 193: 
            case 194: {
                String name = this._lexeme.toString();
                return this.parseFunction(name, token);
            }
            case 134: {
                return new LiteralExpr(this, this._lexeme, Boolean.TYPE);
            }
            case 133: {
                return new LiteralExpr(this, this._lexeme, Boolean.TYPE);
            }
            case 139: {
                return new NullExpr();
            }
            case 129: {
                return new LiteralExpr(this, this._lexeme, Integer.TYPE);
            }
            case 130: {
                return new LiteralExpr(this, this._lexeme, Long.TYPE);
            }
            case 131: {
                return new LiteralExpr(this, this._lexeme, Double.TYPE);
            }
            case 132: {
                return new LiteralExpr(this, this._lexeme, String.class);
            }
            case 196: {
                ArgExpr arg = new ArgExpr(this, Integer.parseInt(this._lexeme));
                return arg;
            }
            case 197: {
                ArgExpr arg = new ArgExpr(this, this._lexeme, this._parameterCount);
                return arg;
            }
            case 40: {
                AmberExpr expr = this.parseExpr();
                token = this.scanToken();
                if (token != 41) {
                    throw this.error(L.l("expected `)' at {0}", (Object)this.tokenName(token)));
                }
                return expr;
            }
        }
        throw this.error(L.l("expected term at {0}", (Object)this.tokenName(token)));
    }

    private AmberExpr parsePath(PathExpr path) throws QueryParseException {
        while (this.peekToken() == 46) {
            this.scanToken();
            String field = this.parseIdentifier();
            AmberExpr next = path.createField(this, field);
            if (next == null) {
                throw this.error(L.l("'{0}' does not have a field '{1}'", (Object)path, (Object)field));
            }
            if (!(next instanceof PathExpr)) {
                return next;
            }
            PathExpr nextPath = this.addPath((PathExpr)next);
            if (this.peekToken() == 91) {
                this.scanToken();
                AmberExpr index = this.parseExpr();
                next = nextPath.createArray(index);
                if (next == null) {
                    throw this.error(L.l("'{0}' does not have a map field '{1}'", (Object)path, (Object)field));
                }
                if (this.peekToken() != 93) {
                    throw this.error(L.l("expected ']' at '{0}'", (Object)this.tokenName(this.peekToken())));
                }
                this.scanToken();
            }
            if (next instanceof PathExpr) {
                path = this.addPath((PathExpr)next);
                continue;
            }
            return next;
        }
        return path;
    }

    private EnumExpr parseEnum(String head) throws QueryParseException {
        int token;
        CharBuffer cb = CharBuffer.allocate();
        while ((token = this.scanToken()) == 46) {
            if (cb.length() > 0) {
                cb.append('.');
            }
            cb.append(head);
            token = this.scanToken();
            if (token != 128) {
                throw this.error(L.l("expected identifier for enumerated type {0} at {1}", (Object)cb.toString(), (Object)this.tokenName(token)));
            }
            head = this._lexeme.toString();
        }
        int value = -1;
        Class<?> cl = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            cl = Class.forName(cb.toString(), false, loader);
            Object enumValue = Enum.valueOf(cl, head);
            value = ((Enum)enumValue).ordinal();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        return new EnumExpr(cl, head, value);
    }

    private AmberExpr parseFunction(String id, int functionToken) throws QueryParseException {
        FunExpr funExpr;
        AmberExpr arg;
        switch (functionToken) {
            case 192: {
                return CurrentDateFunExpr.create(this);
            }
            case 193: {
                return CurrentTimeFunExpr.create(this);
            }
            case 194: {
                return CurrentTimestampFunExpr.create(this);
            }
        }
        this.scanToken();
        AmberExpr trimChar = null;
        TrimFunExpr.TrimSemantics trimSemantics = TrimFunExpr.TrimSemantics.BOTH;
        boolean distinct = false;
        ArrayList<AmberExpr> args = new ArrayList<AmberExpr>();
        if (functionToken == 188) {
            String v;
            switch (this.peekToken()) {
                case 190: {
                    trimSemantics = TrimFunExpr.TrimSemantics.LEADING;
                    this.scanToken();
                    break;
                }
                case 191: {
                    trimSemantics = TrimFunExpr.TrimSemantics.TRAILING;
                    this.scanToken();
                    break;
                }
                case 189: {
                    this.scanToken();
                }
            }
            arg = null;
            if (this.peekToken() != 140 && (arg = this.parseExpr()) instanceof LiteralExpr && (v = ((LiteralExpr)arg).getValue()).length() != 3) {
                throw this.error(L.l("expected a single char expression for TRIM at {0}", (Object)v));
            }
            if (this.peekToken() == 140) {
                this.scanToken();
                trimChar = arg;
                arg = this.parseExpr();
            }
            args.add(arg);
        } else {
            if (this.peekToken() == 145) {
                distinct = true;
                this.scanToken();
            }
            while (this.peekToken() >= 0 && this.peekToken() != 41) {
                arg = this.parseExpr();
                if (id.equalsIgnoreCase("object") && arg instanceof PathExpr) {
                    PathExpr pathExpr = (PathExpr)arg;
                    arg = LoadExpr.create(pathExpr);
                    arg = arg.bindSelect(this);
                    int token = this.scanToken();
                    if (token != 41) {
                        throw this.error(L.l("expected ')' at '{0}'", (Object)this.tokenName(token)));
                    }
                    return arg;
                }
                args.add(arg);
                if (this.peekToken() != 44) break;
                this.scanToken();
            }
        }
        if (this.peekToken() != 41) {
            throw this.error(L.l("expected ')' at '{0}'", (Object)this.tokenName(this.scanToken())));
        }
        this.scanToken();
        switch (functionToken) {
            case 176: {
                funExpr = LocateFunExpr.create(this, args);
                break;
            }
            case 175: {
                funExpr = LengthFunExpr.create(this, args);
                break;
            }
            case 181: {
                funExpr = MaxFunExpr.create(this, id, args, distinct);
                break;
            }
            case 182: {
                funExpr = MinFunExpr.create(this, id, args, distinct);
                break;
            }
            case 183: {
                funExpr = SumFunExpr.create(this, id, args, distinct);
                break;
            }
            case 177: {
                funExpr = AbsFunExpr.create(this, args);
                break;
            }
            case 178: {
                funExpr = SqrtFunExpr.create(this, args);
                break;
            }
            case 179: {
                funExpr = ModFunExpr.create(this, args);
                break;
            }
            case 180: {
                if (!(this._query instanceof AmberSelectQuery)) {
                    throw this.error(L.l("The SIZE() function is only supported for SELECT or subselect queries"));
                }
                AmberExpr arg2 = args.get(0);
                if (arg2 instanceof ManyToOneExpr) {
                    arg2 = ((ManyToOneExpr)arg2).getParent();
                }
                if (!(arg2 instanceof OneToManyExpr)) {
                    throw this.error(L.l("The SIZE() function is only supported for @ManyToMany or @OneToMany relationships. The argument '{0}' is not supported.", (Object)args.get(0)));
                }
                OneToManyExpr oneToMany = (OneToManyExpr)arg2;
                this._groupList = new ArrayList();
                LinkColumns linkColumns = oneToMany.getLinkColumns();
                ForeignColumn fkColumn = linkColumns.getColumns().get(0);
                AmberExpr groupExpr = oneToMany.getParent();
                if (groupExpr instanceof PathExpr) {
                    PathExpr pathExpr = groupExpr;
                    groupExpr = LoadExpr.create(pathExpr);
                    groupExpr = groupExpr.bindSelect(this);
                }
                this._groupList.add(groupExpr);
                ((AmberSelectQuery)this._query).setGroupList(this._groupList);
                funExpr = SizeFunExpr.create(this, args);
                if (this._parsingResult) break;
                if (this._query instanceof AmberSelectQuery) {
                    AmberSelectQuery query = (AmberSelectQuery)this._query;
                    ArrayList<AmberExpr> resultList = query.getResultList();
                    for (AmberExpr expr : resultList) {
                        if (!(expr instanceof SizeFunExpr)) continue;
                        SizeFunExpr sizeFun = (SizeFunExpr)expr;
                        AmberExpr amberExpr = sizeFun.getArgs().get(0);
                        if (amberExpr instanceof ManyToOneExpr) {
                            amberExpr = ((ManyToOneExpr)amberExpr).getParent();
                        }
                        if (!amberExpr.equals(arg2)) continue;
                        args.set(0, amberExpr);
                    }
                }
                if (this._appendResultList == null) {
                    this._appendResultList = new ArrayList();
                }
                this._appendResultList.add(funExpr.bindSelect(this));
                this._isSizeFunExpr = true;
                break;
            }
            case 184: {
                funExpr = ConcatFunExpr.create(this, args);
                break;
            }
            case 185: {
                funExpr = LowerFunExpr.create(this, args);
                break;
            }
            case 186: {
                funExpr = UpperFunExpr.create(this, args);
                break;
            }
            case 187: {
                funExpr = SubstringFunExpr.create(this, args);
                break;
            }
            case 188: {
                TrimFunExpr trimFunExpr = TrimFunExpr.create(this, args);
                trimFunExpr.setTrimChar(trimChar);
                trimFunExpr.setTrimSemantics(trimSemantics);
                funExpr = trimFunExpr;
                break;
            }
            default: {
                funExpr = FunExpr.create(this, id, args, distinct);
            }
        }
        return funExpr;
    }

    private IdExpr getIdentifier(String name) throws QueryParseException {
        for (AbstractQuery query = this._query; query != null; query = query.getParentQuery()) {
            ArrayList<FromItem> fromList = query.getFromList();
            for (int i = 0; i < fromList.size(); ++i) {
                FromItem from = fromList.get(i);
                if (!from.getName().equalsIgnoreCase(name)) continue;
                return from.getIdExpr();
            }
        }
        return null;
    }

    private EmbeddedExpr getEmbeddedAlias(String name) throws QueryParseException {
        for (AbstractQuery query = this._query; query != null; query = query.getParentQuery()) {
            HashMap<String, EmbeddedExpr> embeddedAliases = query.getEmbeddedAliases();
            for (Map.Entry<String, EmbeddedExpr> entry : embeddedAliases.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(name)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    private boolean isCollectionExpr(AmberExpr expr) {
        if (expr instanceof ManyToOneExpr && ((ManyToOneExpr)expr).getParent() instanceof OneToManyExpr) {
            return true;
        }
        if (expr instanceof OneToManyExpr) {
            return true;
        }
        return expr instanceof CollectionIdExpr;
    }

    private boolean isCompatibleExpression(AmberExpr expr1, AmberExpr expr2) {
        if (expr1 instanceof LiteralExpr && expr2 instanceof LiteralExpr) {
            Class javaType2;
            Class javaType1 = ((LiteralExpr)expr1).getJavaType();
            return javaType1.isAssignableFrom(javaType2 = ((LiteralExpr)expr2).getJavaType());
        }
        return true;
    }

    private String parseIdentifier() throws QueryParseException {
        int token = this.scanToken();
        String identifier = this._lexeme;
        if (token == 149) {
            int parseIndex = this._parseIndex;
            this.scanToken();
            if (this.peekToken() != 151) {
                token = 128;
                this._parseIndex = parseIndex;
                this._lexeme = identifier;
                this._token = -1;
            }
        } else if (this._parsingFrom && token == 136) {
            token = 128;
        }
        if (token != 128) {
            throw this.error(L.l("expected identifier at `{0}'", (Object)this.tokenName(token)));
        }
        return identifier;
    }

    private int peekToken() throws QueryParseException {
        if (this._token > 0) {
            return this._token;
        }
        this._token = this.scanToken();
        return this._token;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int scanToken() throws QueryParseException {
        if (this._token > 0) {
            int value = this._token;
            this._token = -1;
            return value;
        }
        int sign = 1;
        int ch = this.read();
        while (Character.isWhitespace((char)ch)) {
            ch = this.read();
        }
        switch (ch) {
            case -1: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 91: 
            case 93: {
                return ch;
            }
            case 40: {
                ++this._depth;
                return ch;
            }
            case 41: {
                --this._depth;
                return ch;
            }
            case 61: {
                ch = this.read();
                if (ch == 62) {
                    return 195;
                }
                this.unread(ch);
                return 166;
            }
            case 33: {
                ch = this.read();
                if (ch == 61) {
                    return 167;
                }
                this.unread(ch);
                return 33;
            }
            case 60: {
                ch = this.read();
                if (ch == 61) {
                    return 169;
                }
                if (ch == 62) {
                    return 167;
                }
                this.unread(ch);
                return 168;
            }
            case 62: {
                ch = this.read();
                if (ch == 61) {
                    return 171;
                }
                this.unread(ch);
                return 170;
            }
            case 63: {
                CharBuffer cb = CharBuffer.allocate();
                int index = 0;
                ch = this.read();
                while (ch >= 48 && ch <= 57) {
                    cb.append((char)ch);
                    index = 10 * index + ch - 48;
                    ch = this.read();
                }
                this.unread(ch);
                this._lexeme = cb.close();
                if (this._lexeme.length() == 0) {
                    this._lexeme = String.valueOf(++this._parameterCount);
                    return 196;
                }
                if (index > 0) return 196;
                throw this.error(L.l("`{0}' must refer to a positive argument", (Object)("?" + this._lexeme)));
            }
            case 58: {
                ch = this.read();
                if (!Character.isJavaIdentifierStart((char)ch)) throw this.error(L.l("`{0}' must be a valid parameter identifier", (Object)(":" + (char)ch)));
                CharBuffer cb = CharBuffer.allocate();
                while (ch > 0 && Character.isJavaIdentifierPart((char)ch)) {
                    cb.append((char)ch);
                    ch = this.read();
                }
                this.unread(ch);
                this._lexeme = cb.close();
                ++this._parameterCount;
                return 197;
            }
            case 124: {
                ch = this.read();
                if (ch != 124) throw this.error(L.l("unexpected char at {0}", (Object)String.valueOf((char)ch)));
                return 165;
            }
            case 64: {
                ch = this.read();
                if (ch == 64) return this.scanToken();
                throw this.error(L.l("`@' expected at {0}", (Object)this.charName(ch)));
            }
        }
        if (Character.isJavaIdentifierStart((char)ch)) {
            CharBuffer cb = CharBuffer.allocate();
            while (ch > 0 && Character.isJavaIdentifierPart((char)ch)) {
                cb.append((char)ch);
                ch = this.read();
            }
            this.unread(ch);
            this._lexeme = cb.close();
            String lower = this._lexeme.toLowerCase(Locale.ENGLISH);
            int token = _reserved.get(lower);
            if (token <= 0) return 128;
            return token;
        }
        if (ch >= 48 && ch <= 57) {
            CharBuffer cb = CharBuffer.allocate();
            int type = 129;
            if (sign < 0) {
                cb.append('-');
            }
            while (ch >= 48 && ch <= 57) {
                cb.append((char)ch);
                ch = this.read();
            }
            if (ch == 46) {
                type = 131;
                cb.append('.');
                ch = this.read();
                while (ch >= 48 && ch <= 57) {
                    cb.append((char)ch);
                    ch = this.read();
                }
            }
            if (ch == 101 || ch == 69) {
                type = 131;
                cb.append('e');
                ch = this.read();
                if (ch == 43 || ch == 45) {
                    cb.append((char)ch);
                    ch = this.read();
                }
                if (ch < 48) throw this.error(L.l("exponent needs digits at {0}", (Object)this.charName(ch)));
                if (ch > 57) {
                    throw this.error(L.l("exponent needs digits at {0}", (Object)this.charName(ch)));
                }
                while (ch >= 48 && ch <= 57) {
                    cb.append((char)ch);
                    ch = this.read();
                }
            }
            if (ch == 70 || ch == 68) {
                type = 131;
            } else if (ch == 76) {
                type = 130;
            } else {
                this.unread(ch);
            }
            this._lexeme = cb.close();
            return type;
        }
        if (ch != 39) throw this.error(L.l("unexpected char at {0}", (Object)("" + (char)ch)));
        CharBuffer cb = CharBuffer.allocate();
        cb.append("'");
        ch = this.read();
        while (ch >= 0) {
            block42: {
                if (ch == 39) {
                    ch = this.read();
                    if (ch == 39) {
                        cb.append("''");
                        break block42;
                    } else {
                        this.unread(ch);
                        break;
                    }
                }
                cb.append((char)ch);
            }
            ch = this.read();
        }
        cb.append("'");
        this._lexeme = cb.close();
        return 132;
    }

    private int read() {
        if (this._parseIndex < this._sql.length()) {
            return this._sql.charAt(this._parseIndex++);
        }
        return -1;
    }

    private void unread(int ch) {
        if (ch >= 0) {
            --this._parseIndex;
        }
    }

    private JdbcMetaData getMetaData() {
        if (this._persistenceUnit == null) {
            return null;
        }
        return this._persistenceUnit.getMetaData();
    }

    public QueryParseException error(String msg) {
        msg = msg + "\nin \"" + this._sql + "\"";
        return new QueryParseException(msg);
    }

    private String charName(int ch) {
        if (ch < 0) {
            return L.l("end of query");
        }
        return String.valueOf((char)ch);
    }

    private String tokenName(int token) {
        switch (token) {
            case 147: {
                return "AS";
            }
            case 140: {
                return "FROM";
            }
            case 141: {
                return "IN";
            }
            case 142: {
                return "SELECT";
            }
            case 146: {
                return "WHERE";
            }
            case 173: {
                return "OR";
            }
            case 172: {
                return "AND";
            }
            case 174: {
                return "NOT";
            }
            case 161: {
                return "BETWEEN";
            }
            case 199: {
                return "THIS";
            }
            case 133: {
                return "FALSE";
            }
            case 138: {
                return "EMPTY";
            }
            case 136: {
                return "MEMBER";
            }
            case 137: {
                return "OF";
            }
            case 139: {
                return "NULL";
            }
            case 149: {
                return "ORDER";
            }
            case 151: {
                return "BY";
            }
            case 152: {
                return "ASC";
            }
            case 153: {
                return "DESC";
            }
            case 154: {
                return "LIMIT";
            }
            case 195: {
                return "=>";
            }
            case -1: {
                return L.l("end of query");
            }
        }
        if (token < 128) {
            return "'" + String.valueOf((char)token) + "'";
        }
        return "'" + this._lexeme + "'";
    }

    public String toString() {
        return "QueryParser[]";
    }

    static {
        _reserved.put("as", 147);
        _reserved.put("from", 140);
        _reserved.put("in", 141);
        _reserved.put("select", 142);
        _reserved.put("update", 143);
        _reserved.put("delete", 144);
        _reserved.put("set", 148);
        _reserved.put("distinct", 145);
        _reserved.put("where", 146);
        _reserved.put("order", 149);
        _reserved.put("group", 150);
        _reserved.put("by", 151);
        _reserved.put("having", 201);
        _reserved.put("asc", 152);
        _reserved.put("desc", 153);
        _reserved.put("limit", 154);
        _reserved.put("offset", 155);
        _reserved.put("join", 156);
        _reserved.put("inner", 157);
        _reserved.put("left", 158);
        _reserved.put("outer", 159);
        _reserved.put("fetch", 160);
        _reserved.put("or", 173);
        _reserved.put("and", 172);
        _reserved.put("not", 174);
        _reserved.put("length", 175);
        _reserved.put("locate", 176);
        _reserved.put("abs", 177);
        _reserved.put("sqrt", 178);
        _reserved.put("mod", 179);
        _reserved.put("size", 180);
        _reserved.put("max", 181);
        _reserved.put("min", 182);
        _reserved.put("sum", 183);
        _reserved.put("concat", 184);
        _reserved.put("lower", 185);
        _reserved.put("upper", 186);
        _reserved.put("substring", 187);
        _reserved.put("trim", 188);
        _reserved.put("both", 189);
        _reserved.put("leading", 190);
        _reserved.put("trailing", 191);
        _reserved.put("current_date", 192);
        _reserved.put("current_time", 193);
        _reserved.put("current_timestamp", 194);
        _reserved.put("between", 161);
        _reserved.put("like", 162);
        _reserved.put("escape", 163);
        _reserved.put("is", 164);
        _reserved.put("new", 198);
        _reserved.put("this", 199);
        _reserved.put("true", 133);
        _reserved.put("false", 134);
        _reserved.put("unknown", 135);
        _reserved.put("empty", 138);
        _reserved.put("member", 136);
        _reserved.put("of", 137);
        _reserved.put("null", 139);
    }
}

