/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.type.AmberType;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ShortType
extends AmberType {
    private static final L10N L = new L10N(ShortType.class);
    private static final ShortType SHORT_TYPE = new ShortType();

    private ShortType() {
    }

    public static ShortType create() {
        return SHORT_TYPE;
    }

    @Override
    public String getName() {
        return "java.lang.Short";
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public String generateCreateColumnSQL(AmberPersistenceUnit manager, int length, int precision, int scale) {
        return manager.getCreateColumnSQL(5, length, precision, scale);
    }

    @Override
    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print("com.caucho.amber.type.ShortType.toShort(" + rs + ".getShort(" + indexVar + " + " + index + "), " + rs + ".wasNull())");
        return index + 1;
    }

    @Override
    public int generateLoadNative(JavaWriter out, int index) throws IOException {
        out.print("com.caucho.amber.type.ShortType.toShort(rs.getShort(columnNames[" + index + "]),rs.wasNull())");
        return index + 1;
    }

    @Override
    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println("if (" + value + " == null)");
        out.println("  " + pstmt + ".setNull(" + index + "++, java.sql.Types.SMALLINT);");
        out.println("else");
        out.println("  " + pstmt + ".setShort(" + index + "++, " + value + ".shortValue());");
    }

    @Override
    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(pstmt + ".setNull(" + index + "++, java.sql.Types.SMALLINT);");
    }

    @Override
    public void generateSetVersion(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println("if (" + value + " == null)");
        out.println("  " + pstmt + ".setShort(" + index + "++, 1);");
        out.println("else");
        out.println("  " + pstmt + ".setShort(" + index + "++, " + value + ".shortValue() + 1);");
    }

    @Override
    public String generateIncrementVersion(String value) throws IOException {
        return value + ".shortValue() + 1";
    }

    @Override
    public Object toObject(long value) {
        return new Short((short)value);
    }

    public static Short toShort(int value, boolean wasNull) {
        if (wasNull) {
            return null;
        }
        return new Short((short)value);
    }

    @Override
    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        if (value == null) {
            pstmt.setNull(index, 0);
        } else {
            pstmt.setShort(index, ((Number)value).shortValue());
        }
    }

    @Override
    public Object getObject(ResultSet rs, int index) throws SQLException {
        short value = rs.getShort(index);
        return rs.wasNull() ? null : new Short(value);
    }
}

