/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amqp.io;

import com.caucho.amqp.io.AmqpAbstractComposite;
import com.caucho.amqp.io.AmqpReader;
import com.caucho.amqp.io.AmqpWriter;
import com.caucho.amqp.io.LinkSource;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class LinkTarget
extends AmqpAbstractComposite {
    private String _address;
    private LinkSource.Durability _durable;
    private LinkSource.ExpiryPolicy _expiryPolicy;
    private long _timeout;
    private boolean _isDynamic;
    private Map<String, Object> _dynamicNodeProperties;
    private List<String> _capabilities;

    public String getAddress() {
        return this._address;
    }

    public void setAddress(String address) {
        this._address = address;
    }

    public LinkSource.Durability getDurable() {
        return this._durable;
    }

    public LinkSource.ExpiryPolicy getExpiryPolicy() {
        return this._expiryPolicy;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public boolean isDynamic() {
        return this._isDynamic;
    }

    public void setDynamicNodeProperties(Map<String, Object> props) {
        this._dynamicNodeProperties = props;
    }

    public Map<String, Object> getDynamicNodeProperties() {
        return this._dynamicNodeProperties;
    }

    public List<String> getCapabilities() {
        return this._capabilities;
    }

    @Override
    public long getDescriptorCode() {
        return 41L;
    }

    @Override
    public LinkTarget createInstance() {
        return new LinkTarget();
    }

    @Override
    public void readBody(AmqpReader in, int count) throws IOException {
        this._address = in.readString();
        this._durable = LinkSource.Durability.values()[in.readInt()];
        this._expiryPolicy = LinkSource.ExpiryPolicy.find(in.readSymbol());
        this._timeout = in.readLong();
        this._isDynamic = in.readBoolean();
        this._dynamicNodeProperties = in.readMap();
        this._capabilities = in.readSymbolArray();
    }

    @Override
    public int writeBody(AmqpWriter out) throws IOException {
        out.writeString(this._address);
        if (this._durable != null) {
            out.writeUint(this._durable.ordinal());
        } else {
            out.writeNull();
        }
        if (this._expiryPolicy != null) {
            out.writeSymbol(this._expiryPolicy.getName());
        } else {
            out.writeNull();
        }
        out.writeUint((int)this._timeout);
        out.writeBoolean(this._isDynamic);
        out.writeFieldsMap(this._dynamicNodeProperties);
        out.writeSymbolArray(this._capabilities);
        return 7;
    }
}

