/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bam.proxy;

import com.caucho.bam.BamError;
import com.caucho.bam.actor.AbstractActorSender;
import com.caucho.bam.actor.ActorSender;
import com.caucho.bam.actor.BamActorRef;
import com.caucho.bam.broker.Broker;
import com.caucho.bam.proxy.CallPayload;
import com.caucho.bam.proxy.ReplyCallback;
import com.caucho.bam.proxy.ReplyPayload;
import com.caucho.bam.query.QueryCallback;
import com.caucho.bam.query.QueryFutureCallback;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;

class BamProxyHandler
implements InvocationHandler {
    private static final L10N L = new L10N(BamProxyHandler.class);
    private static final HashMap<Class<?>, Object> _nullResultMap = new HashMap();
    private final Class<?> _api;
    private final HashMap<Method, Call> _callMap = new HashMap();
    private final ActorSender _sender;
    private final BamActorRef _to;
    private final long _timeout;

    BamProxyHandler(Class<?> api, ActorSender sender, BamActorRef to, long timeout) {
        this._api = api;
        this._sender = sender;
        this._to = to;
        this._timeout = timeout;
        for (Method m : api.getMethods()) {
            if (m.getDeclaringClass() == Object.class) continue;
            Call call = null;
            Class<?>[] param = m.getParameterTypes();
            Object nullResult = _nullResultMap.get(m.getReturnType());
            call = param.length > 0 && ReplyCallback.class.isAssignableFrom(param[param.length - 1]) ? new ReplyCallbackCall(m.getName(), param.length - 1, nullResult) : (param.length > 0 && QueryCallback.class.isAssignableFrom(param[param.length - 1]) ? new QueryCallbackCall(m.getName(), param.length - 1) : (Void.TYPE.equals(m.getReturnType()) ? new MessageCall(m.getName()) : new QueryCall(m.getName(), nullResult)));
            this._callMap.put(m, call);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        int size;
        Call call = this._callMap.get(method);
        if (call != null) {
            return call.invoke(this._sender, this._to, args, this._timeout);
        }
        String name = method.getName();
        int n = size = args != null ? args.length : 0;
        if ("toString".equals(name) && size == 0) {
            return "BamProxyHandler[" + this._to + "," + this._api.getSimpleName() + "]";
        }
        return null;
    }

    static {
        _nullResultMap.put(Boolean.TYPE, Boolean.FALSE);
        _nullResultMap.put(Byte.TYPE, new Byte(0));
        _nullResultMap.put(Character.TYPE, new Character('\u0000'));
        _nullResultMap.put(Short.TYPE, new Short(0));
        _nullResultMap.put(Integer.TYPE, new Integer(0));
        _nullResultMap.put(Long.TYPE, new Long(0L));
        _nullResultMap.put(Float.TYPE, new Float(0.0f));
        _nullResultMap.put(Double.TYPE, new Double(0.0));
    }

    static class CallReplyCallback
    implements QueryCallback {
        private final ReplyCallback _delegate;

        CallReplyCallback(ReplyCallback delegate) {
            this._delegate = delegate;
        }

        @Override
        public void onQueryResult(String to, String from, Serializable payload) {
            if (payload == null) {
                this._delegate.onReply(null);
            } else if (payload instanceof ReplyPayload) {
                ReplyPayload reply = (ReplyPayload)payload;
                this._delegate.onReply(reply.getValue());
            } else {
                this._delegate.onReply(payload);
            }
        }

        @Override
        public void onQueryError(String to, String from, Serializable payload, BamError error) {
            this._delegate.onError(error);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._delegate + "]";
        }
    }

    static class ProxySender
    extends AbstractActorSender {
        private String _address;
        private Broker _broker;

        ProxySender(String address, Broker broker) {
            this._address = address;
            this._broker = broker;
        }

        @Override
        public String getAddress() {
            return this._address;
        }

        @Override
        public Broker getBroker() {
            return this._broker;
        }
    }

    static class MessageCall
    extends Call {
        private final String _name;

        MessageCall(String name) {
            this._name = name;
        }

        @Override
        Object invoke(ActorSender sender, BamActorRef to, Object[] args, long timeout) {
            CallPayload payload = new CallPayload(this._name, args);
            sender.message(to, (Serializable)payload);
            return null;
        }
    }

    static class QueryCallbackCall
    extends Call {
        private final String _name;
        private final int _paramLen;

        QueryCallbackCall(String name, int paramLen) {
            this._name = name;
            this._paramLen = paramLen;
        }

        @Override
        Object invoke(ActorSender sender, BamActorRef to, Object[] args, long timeout) {
            Object[] param = new Object[args.length - 1];
            System.arraycopy(args, 0, param, 0, param.length);
            QueryCallback cb = (QueryCallback)args[this._paramLen];
            CallPayload payload = new CallPayload(this._name, param);
            sender.query(to, (Serializable)payload, cb);
            return null;
        }
    }

    static class ReplyCallbackCall
    extends Call {
        private final String _name;
        private final int _paramLen;
        private final Object _nullResult;

        ReplyCallbackCall(String name, int paramLen, Object nullResult) {
            this._name = name;
            this._paramLen = paramLen;
            this._nullResult = nullResult;
        }

        @Override
        Object invoke(ActorSender sender, BamActorRef to, Object[] args, long timeout) {
            Object[] param = new Object[args.length - 1];
            System.arraycopy(args, 0, param, 0, param.length);
            ReplyCallback cb = (ReplyCallback)args[this._paramLen];
            CallPayload payload = new CallPayload(this._name, param);
            CallReplyCallback callCb = new CallReplyCallback(cb);
            sender.query(to, (Serializable)payload, (QueryCallback)callCb);
            return this._nullResult;
        }
    }

    static class QueryCall
    extends Call {
        private final String _name;
        private final Object _nullResult;

        QueryCall(String name, Object nullResult) {
            this._name = name;
            this._nullResult = nullResult;
        }

        @Override
        Object invoke(ActorSender sender, BamActorRef to, Object[] args, long timeout) {
            CallPayload payload = new CallPayload(this._name, args);
            QueryFutureCallback cb = new QueryFutureCallback();
            sender.query(to, (Serializable)payload, (QueryCallback)cb);
            Serializable result = cb.get(timeout);
            if (result instanceof ReplyPayload) {
                return ((ReplyPayload)result).getValue();
            }
            if (result == null) {
                return this._nullResult;
            }
            throw new IllegalStateException(L.l("'{0}' is an unexpected bam proxy result class.", (Object)result.getClass().getName()));
        }
    }

    static abstract class Call {
        Call() {
        }

        abstract Object invoke(ActorSender var1, BamActorRef var2, Object[] var3, long var4);
    }
}

