/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.BootOption;

public abstract class AbstractBootOption
implements BootOption {
    private String _name;
    private String _description;
    private boolean _deprecated = false;

    public AbstractBootOption(String name, String description) {
        this(name, description, false);
    }

    public AbstractBootOption(String name, String description, boolean deprecated) {
        this._name = name;
        this._description = description;
        this._deprecated = deprecated;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    protected String getValueName() {
        return "value";
    }

    @Override
    public boolean isDeprecated() {
        return this._deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this._deprecated = deprecated;
    }

    @Override
    public String getUsage() {
        StringBuilder sb = new StringBuilder();
        sb.append("  --");
        sb.append(this.getName());
        if (this.isIntValue()) {
            sb.append(" <" + this.getValueName() + ">");
        } else if (this.isValue()) {
            sb.append(" <" + this.getValueName() + ">");
        }
        while (sb.length() < 22) {
            sb.append(" ");
        }
        sb.append(" : ").append(this.getDescription());
        if (this.isDeprecated()) {
            sb.append(" (deprecated)");
        }
        return sb.toString();
    }

    @Override
    public boolean isFlag() {
        return false;
    }

    @Override
    public boolean isValue() {
        return false;
    }

    @Override
    public boolean isIntValue() {
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._name + "]";
    }
}

