/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.AbstractBootCommand;
import com.caucho.boot.BootClusterConfig;
import com.caucho.boot.BootResinConfig;
import com.caucho.boot.ResinBoot;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.boot.WatchdogManager;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.util.ArrayList;

public abstract class AbstractStartCommand
extends AbstractBootCommand {
    private static final L10N L = new L10N(AbstractStartCommand.class);

    @Override
    protected void initBootOptions() {
        this.addValueOption("server", "id", "select a configured server");
        this.addSpacerOption();
        this.addFlagOption("elastic-server", "join a cluster as an elastic server (pro)");
        this.addValueOption("elastic-server-address", "ip", "cluster IP address for an elastic server");
        this.addIntValueOption("elastic-server-port", "port", "cluster port for an elastic server");
        this.addValueOption("cluster", "id", "cluster to join as an elastic server (pro)");
        this.addValueOption("join-cluster", "id", "cluster to join as an elastic server (pro)", true);
        this.addSpacerOption();
        this.addFlagOption("preview", "run as a preview (staging) server");
        this.addValueOption("stage", "stage", "select a configuration stage (production, preview)");
        this.addSpacerOption();
        this.addIntValueOption("debug-port", "port", "listen to a JVM debug port");
        this.addIntValueOption("jmx-port", "port", "listen to an unauthenticated JMX port");
        this.addIntValueOption("watchdog-port", "port", "set watchdog port to listen to");
        this.addValueOption("name", "name", "name for win32 service");
        super.initBootOptions();
    }

    @Override
    public int doCommand(ResinBoot boot, WatchdogArgs args) {
        if (boot.isElasticServer(args)) {
            this.validateElasticServer(boot, args);
        }
        return super.doCommand(boot, args);
    }

    private void validateElasticServer(ResinBoot boot, WatchdogArgs args) {
        for (BootResinConfig.ElasticServer server : boot.getElasticServerList()) {
            BootClusterConfig cluster;
            String clusterId = server.getCluster();
            if (clusterId == null) {
                clusterId = boot.getHomeCluster(args);
            }
            if ((cluster = boot.findCluster(clusterId)) == null) {
                if (clusterId == null) {
                    throw new ConfigException(L.l("--elastic-server requires a --cluster or <home-cluster> configuration. --elastic-server needs to know which cluster to join."));
                }
                throw new ConfigException(L.l("--cluster '{0}' is an unknown cluster.  --elastic-server requires a configured --cluster.", (Object)clusterId));
            }
            ArrayList<WatchdogClient> serverList = cluster.getServerList();
            for (int i = 0; i < serverList.size() && i < 3; ++i) {
                WatchdogClient watchdogClient = serverList.get(i);
            }
        }
    }

    @Override
    public void doWatchdogStart(WatchdogManager manager) {
        WatchdogArgs args = manager.getArgs();
        String serverId = args.getClientServerId();
        manager.startServer(serverId, args.getArgv());
    }

    @Override
    protected WatchdogClient findNamedClient(ResinBoot boot, WatchdogArgs args, String serverId) {
        WatchdogClient client = this.findNamedClientImpl(boot, args, serverId);
        return client;
    }

    @Override
    protected WatchdogClient findLocalClient(ResinBoot boot, WatchdogArgs args) {
        if (boot.isElasticServer(args)) {
            return this.findLocalClientImpl(boot, args);
        }
        return this.findUniqueLocalClient(boot, args);
    }

    @Override
    protected WatchdogClient findWatchdogClient(ResinBoot boot, WatchdogArgs args) {
        if (boot.isElasticServer(args)) {
            return this.findWatchdogClientImpl(boot, args);
        }
        return null;
    }

    protected String getServerUsageArg(WatchdogArgs args, String clientId) {
        if (args.getServerId() != null) {
            return " -server '" + args.getServerId() + "'";
        }
        if (args.isElasticServer()) {
            return " -server '" + args.getElasticServerId() + "'";
        }
        return " -server '" + clientId + "'";
    }

    @Override
    public boolean isRetry() {
        return true;
    }
}

