/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.VersionFactory;
import com.caucho.boot.AbstractStartCommand;
import com.caucho.boot.BootArgumentException;
import com.caucho.boot.BootResinConfig;
import com.caucho.boot.ResinBoot;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.boot.WatchdogManager;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StartAllCommand
extends AbstractStartCommand {
    private static Logger _log;
    private static L10N _L;

    protected StartAllCommand() {
        this.addFlagOption("elastic-dns", "retry DNS address lookup on start until success");
    }

    @Override
    public String getDescription() {
        return "starts all servers listening to the machine's IP interfaces";
    }

    @Override
    public boolean isStart() {
        return true;
    }

    @Override
    public boolean isStartAll() {
        return true;
    }

    @Override
    public int doCommand(ResinBoot boot, WatchdogArgs args) throws BootArgumentException {
        ArrayList<WatchdogClient> clientList = boot.findLocalClients();
        if (clientList.size() == 0 && !boot.isElasticIp(args)) {
            System.out.println(StartAllCommand.L().l("Resin/{0} cannot find any local servers to start in the configuration.", (Object)VersionFactory.getVersion()));
            return 0;
        }
        return super.doCommand(boot, args);
    }

    @Override
    protected WatchdogClient findLocalClient(ResinBoot boot, WatchdogArgs args) {
        return this.findLocalClientImpl(boot, args);
    }

    @Override
    protected WatchdogClient findWatchdogClient(ResinBoot boot, WatchdogArgs args) {
        if (boot.isElasticIp(args)) {
            return this.findWatchdogClientImpl(boot, args);
        }
        return super.findWatchdogClient(boot, args);
    }

    @Override
    public int doCommand(WatchdogArgs args, WatchdogClient client) throws BootArgumentException {
        try {
            client.startAllWatchdog(args.getArgv(), true);
            System.out.println(StartAllCommand.L().l("Resin/{0} start-all with watchdog at {1}:{2}", (Object)VersionFactory.getVersion(), (Object)client.getWatchdogAddress(), (Object)client.getWatchdogPort()));
        }
        catch (Exception e) {
            String eMsg = e instanceof ConfigException ? e.getMessage() : e.toString();
            System.out.println(StartAllCommand.L().l("Resin/{0} can't start-all for watchdog at {1}:{2}.\n  {3}", (Object)VersionFactory.getVersion(), (Object)client.getWatchdogAddress(), (Object)client.getWatchdogPort(), (Object)eMsg));
            StartAllCommand.log().log(Level.FINE, e.toString(), e);
            System.exit(1);
        }
        return 0;
    }

    @Override
    public void doWatchdogStart(WatchdogManager manager) {
        ArrayList<WatchdogClient> clientList;
        BootResinConfig boot = manager.getManagerConfig();
        WatchdogArgs args = manager.getArgs();
        String serverId = args.getClientServerId();
        if (serverId != null && boot.isElasticServer(args)) {
            manager.startServerAll(serverId, args.getArgv());
            return;
        }
        do {
            if ((clientList = boot.findLocalClients(null)).size() != 0 || !boot.isElasticDns(args)) continue;
            try {
                StartAllCommand.log().info("No local IP address found, waiting...");
                Thread.sleep(10000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (clientList.size() == 0 && boot.isElasticDns(args));
        for (WatchdogClient client : clientList) {
            try {
                manager.startServer(client.getId(), args.getArgv());
            }
            catch (Exception e) {
                String eMsg = e instanceof ConfigException ? e.getMessage() : e.toString();
                System.out.println(StartAllCommand.L().l("Resin/{0} can't start -server '{1}' for watchdog at {2}:{3}.\n  {4}", (Object)VersionFactory.getVersion(), (Object)client.getId(), (Object)client.getWatchdogAddress(), (Object)client.getWatchdogPort(), (Object)eMsg));
                StartAllCommand.log().log(Level.FINE, e.toString(), e);
            }
        }
    }

    @Override
    public boolean isRetry() {
        return true;
    }

    private static Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(StartAllCommand.class.getName());
        }
        return _log;
    }

    private static L10N L() {
        if (_L == null) {
            _L = new L10N(StartAllCommand.class);
        }
        return _L;
    }
}

