/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.AbstractManagementCommand;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.server.admin.AddUserQueryReply;
import com.caucho.server.admin.ManagerClient;
import com.caucho.util.L10N;
import java.util.Arrays;

public class UserAddCommand
extends AbstractManagementCommand {
    private static final L10N L = new L10N(UserAddCommand.class);

    @Override
    protected void initBootOptions() {
        this.addValueOption("u", "new user name", "specifies name for a new user.");
        this.addValueOption("p", "new user password", "specifies password for a new user.");
        super.initBootOptions();
    }

    @Override
    public String getDescription() {
        return "adds an administration user and password";
    }

    @Override
    public int doCommand(WatchdogArgs args, WatchdogClient client, ManagerClient managerClient) {
        String user = args.getArg("-u");
        if (user == null) {
            this.usage(false);
            return 3;
        }
        String passwordString = args.getArg("-p");
        char[] password = null;
        if (passwordString != null) {
            password = passwordString.toCharArray();
        }
        while (password == null) {
            char[] passwordEntry = System.console().readPassword("%s", "enter password:");
            if (passwordEntry.length <= 8) {
                System.out.println("password must be greater than 8 characters");
                continue;
            }
            char[] passwordConfirm = System.console().readPassword("%s", "re-enter password:");
            if (Arrays.equals(passwordEntry, passwordConfirm)) {
                password = passwordEntry;
                continue;
            }
            System.out.println("passwords do not match");
        }
        String[] roles = args.getDefaultArgs();
        AddUserQueryReply result = managerClient.addUser(user, password, roles);
        System.out.println(L.l("user `{0}' added", (Object)result.getUser().getName()));
        return 0;
    }

    @Override
    public boolean isDefaultArgsAccepted() {
        return true;
    }

    @Override
    public String getUsageArgs() {
        return " [<role>] [<role>] ...";
    }
}

