/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.ByteCodeWriter;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.ConstantPoolEntry;
import java.io.IOException;

public class NameAndTypeConstant
extends ConstantPoolEntry {
    private int _nameIndex;
    private int _descriptorIndex;

    NameAndTypeConstant(ConstantPool pool, int index, int nameIndex, int descriptorIndex) {
        super(pool, index);
        this._nameIndex = nameIndex;
        this._descriptorIndex = descriptorIndex;
    }

    public String getName() {
        return this.getConstantPool().getUtf8(this._nameIndex).getValue();
    }

    public String getType() {
        return this.getConstantPool().getUtf8(this._descriptorIndex).getValue();
    }

    @Override
    void write(ByteCodeWriter out) throws IOException {
        out.write(12);
        out.writeShort(this._nameIndex);
        out.writeShort(this._descriptorIndex);
    }

    @Override
    public int export(ConstantPool target) {
        return target.addNameAndType(this.getName(), this.getType()).getIndex();
    }

    public String toString() {
        return "NameAndTypeConstant[" + this.getName() + ", " + this.getType() + "]";
    }
}

