/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.ByteCodeWriter;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.ConstantPoolEntry;
import java.io.IOException;
import java.util.logging.Logger;

public class Utf8Constant
extends ConstantPoolEntry {
    private static final Logger log = Logger.getLogger(Utf8Constant.class.getName());
    private String _value;

    Utf8Constant(ConstantPool pool, int index, String value) {
        super(pool, index);
        this._value = value;
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        this._value = value;
    }

    @Override
    void write(ByteCodeWriter out) throws IOException {
        out.write(1);
        out.writeUTF8(this._value);
    }

    @Override
    public int export(ConstantPool target) {
        return target.addUTF8(this._value).getIndex();
    }

    public String toString() {
        return "Utf8Constant[" + this._value + "]";
    }
}

