/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cloud.loadbalance;

import com.caucho.cloud.loadbalance.LoadBalanceBackend;
import com.caucho.cloud.loadbalance.LoadBalanceManager;
import com.caucho.cloud.loadbalance.LoadBalanceStrategy;
import com.caucho.cloud.loadbalance.SingleLoadBalanceManager;
import com.caucho.cloud.loadbalance.StickyRequestHashGenerator;
import com.caucho.cloud.topology.CloudPod;
import com.caucho.config.ConfigException;
import com.caucho.network.balance.ClientSocketFactory;
import com.caucho.server.cluster.ServletService;
import com.caucho.util.L10N;
import java.util.ArrayList;

public class LoadBalanceBuilder {
    private static final L10N L = new L10N(LoadBalanceBuilder.class);
    private LoadBalanceStrategy _strategy = LoadBalanceStrategy.ADAPTIVE;
    private String _meterCategory = null;
    private LoadBalanceBackend _defaults = new LoadBalanceBackend();
    private ArrayList<ClientSocketFactory> _clientList = new ArrayList();

    public void setStrategy(LoadBalanceStrategy strategy) {
        if (strategy == null) {
            throw new NullPointerException();
        }
        this._strategy = strategy;
    }

    public LoadBalanceStrategy getStrategy() {
        return this._strategy;
    }

    public void setStickyRequestHashGenerator(StickyRequestHashGenerator gen) {
    }

    public void setTargetCluster(String clusterId) {
        throw new IllegalStateException(L.l("{0}: setCluster requires Resin Professional.", (Object)this));
    }

    public void setTargetCluster(CloudPod pod) {
        throw new IllegalStateException(L.l("{0}: setCluster requires Resin Professional.", (Object)this));
    }

    public void setTargetPort(int port) {
        throw new IllegalStateException(L.l("{0}: setPort requires Resin Professional.", (Object)this));
    }

    public void setConnectTimeout(long connectTimeout) {
        this._defaults.setConnectTimeoutMs(connectTimeout);
    }

    public void setConnectionMin(int connectionMin) {
        this._defaults.setConnectionMin(connectionMin);
    }

    public void setSocketTimeout(long socketTimeout) {
        this._defaults.setSocketTimeoutMs(socketTimeout);
    }

    public void setIdleTime(long idleTime) {
        this._defaults.setIdleTimeMs(idleTime);
    }

    public void setRecoverTime(long recoverTime) {
        this._defaults.setRecoverTimeMs(recoverTime);
    }

    public void setWarmupTime(long warmupTime) {
        this._defaults.setWarmupTimeMs(warmupTime);
    }

    public LoadBalanceBackend getDefaults() {
        return this._defaults;
    }

    public void setMeterCategory(String category) {
        this._meterCategory = category;
    }

    public String getMeterCategory() {
        return this._meterCategory;
    }

    public void addAddress(String address) {
        this.addBackend(new LoadBalanceBackend(address));
    }

    public void addBackend(LoadBalanceBackend backend) {
        this.addClient(this.createClientSocketFactory(backend));
    }

    public void addClient(ClientSocketFactory client) {
        client.init();
        client.start();
        this._clientList.add(client);
    }

    public ArrayList<ClientSocketFactory> getClientList() {
        return this._clientList;
    }

    public LoadBalanceManager create() {
        ClientSocketFactory socketFactory = null;
        if (this.getClientList().size() > 0) {
            socketFactory = this.getClientList().get(0);
        }
        return new SingleLoadBalanceManager(socketFactory, this.getMeterCategory());
    }

    protected ClientSocketFactory createClientSocketFactory(String address) {
        int p = address.lastIndexOf(58);
        int q = address.lastIndexOf(93);
        if (p < 0 && q <= p) {
            throw new ConfigException(L.l("'{0}' is an invalid address because it does not specify the port.", (Object)address));
        }
        String host = address.substring(0, p);
        int port = Integer.parseInt(address.substring(p + 1));
        ServletService server = ServletService.getCurrent();
        boolean isSecure = false;
        ClientSocketFactory factory = new ClientSocketFactory(server.getServerId(), address, this.getMeterCategory(), address, host, port, isSecure);
        this.applyDefaults(factory);
        return factory;
    }

    protected ClientSocketFactory createClientSocketFactory(LoadBalanceBackend backend) {
        ClientSocketFactory factory = this.createClientSocketFactory(backend.getAddress());
        this.applyBackendConfig(factory, backend);
        return factory;
    }

    protected void applyDefaults(ClientSocketFactory factory) {
        this.applyBackendConfig(factory, this._defaults);
    }

    protected void applyBackendConfig(ClientSocketFactory factory, LoadBalanceBackend backend) {
        if (backend.hasConnectionMin()) {
            factory.setLoadBalanceConnectionMin(backend.getConnectionMin());
        }
        if (backend.hasConnectTimeout()) {
            factory.setLoadBalanceConnectTimeout(backend.getConnectTimeout());
        }
        if (backend.hasIdleTime()) {
            factory.setLoadBalanceIdleTime(backend.getIdleTime());
        }
        if (backend.hasRecoverTime()) {
            factory.setLoadBalanceRecoverTime(backend.getRecoverTime());
        }
        if (backend.hasBusyRecoverTime()) {
            factory.setLoadBalanceBusyRecoverTime(backend.getBusyRecoverTime());
        }
        if (backend.hasSocketTimeout()) {
            factory.setLoadBalanceSocketTimeout(backend.getSocketTimeout());
        }
        if (backend.hasWarmupTime()) {
            factory.setLoadBalanceWarmupTime(backend.getWarmupTime());
        }
        if (backend.hasWeight()) {
            factory.setLoadBalanceWeight(backend.getWeight());
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

