/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cloud.network;

import com.caucho.cloud.network.ClusterServer;
import com.caucho.util.CurrentTime;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ServerHeartbeatState {
    private static final Logger log = Logger.getLogger(ServerHeartbeatState.class.getName());
    private final AtomicReference<State> _heartbeatState = new AtomicReference<State>(State.STOP);
    private final AtomicLong _stateTimestamp = new AtomicLong();
    private final AtomicLong _lastHeartbeatTime = new AtomicLong();
    private final ClusterServer _server;

    ServerHeartbeatState(ClusterServer server) {
        this._server = server;
        this._stateTimestamp.set(CurrentTime.getCurrentTime());
    }

    public boolean isHeartbeatActive() {
        return this._heartbeatState.get().isActive();
    }

    public String getHeartbeatState() {
        return this._heartbeatState.get().toString();
    }

    public long getStateTimestamp() {
        return this._stateTimestamp.get();
    }

    public long getLastHeartbeatTime() {
        return this._lastHeartbeatTime.get();
    }

    public boolean notifyHeartbeatStart() {
        long now = CurrentTime.getCurrentTime();
        long oldHeartbeatTime = this._lastHeartbeatTime.getAndSet(now);
        State oldState = this._heartbeatState.getAndSet(State.ACTIVE);
        if (oldState == State.ACTIVE) {
            return false;
        }
        this._stateTimestamp.set(now);
        if (oldHeartbeatTime > 0L) {
            log.warning(this + " notify-heartbeat-start");
        } else if (log.isLoggable(Level.FINER)) {
            log.finer(this + " notify-heartbeat-start");
        }
        return true;
    }

    public boolean notifyHeartbeatStop() {
        this._lastHeartbeatTime.set(0L);
        State oldState = this._heartbeatState.getAndSet(State.STOP);
        if (oldState == State.STOP) {
            return false;
        }
        this._stateTimestamp.set(CurrentTime.getCurrentTime());
        return true;
    }

    public void updateTimeout(long timeout) {
        long lastTime;
        State oldState = this._heartbeatState.get();
        if (oldState != State.ACTIVE) {
            return;
        }
        long now = CurrentTime.getCurrentTime();
        if (timeout < now - (lastTime = this._lastHeartbeatTime.get()) && this._heartbeatState.compareAndSet(State.ACTIVE, State.TIMEOUT)) {
            log.warning(this._server + " heartbeat timeout " + (now - lastTime) + "ms");
            this._server.onHeartbeatTimeout();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._server + "," + (Object)((Object)this._heartbeatState.get()) + "]";
    }

    static enum State {
        STOP,
        TIMEOUT,
        ACTIVE{

            @Override
            public boolean isActive() {
                return true;
            }
        };


        public boolean isActive() {
            return false;
        }
    }
}

