/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.attribute;

import com.caucho.config.ConfigException;
import com.caucho.config.attribute.Attribute;
import com.caucho.config.type.ConfigType;
import com.caucho.config.type.RawStringArrayType;
import com.caucho.config.type.RawStringType;
import com.caucho.config.type.TypeFactory;
import com.caucho.config.types.AnnotationConfig;
import com.caucho.xml.QName;

public class AnnotationAttribute<T>
extends Attribute {
    private String _name;
    private ConfigType<T> _type;

    public AnnotationAttribute(String name, Class<T> type, boolean isEL) {
        this._name = name;
        this._type = isEL ? TypeFactory.getType(type) : (String.class.equals(type) ? RawStringType.TYPE : (String[].class.equals(type) ? RawStringArrayType.TYPE : TypeFactory.getType(type)));
    }

    public ConfigType<T> getConfigType() {
        return this._type;
    }

    @Override
    public boolean isInlineType(ConfigType<?> type) {
        if (type == null) {
            return false;
        }
        if (type.isReplace()) {
            return true;
        }
        if (this._type.isInlineType(type)) {
            return true;
        }
        return this._type.getType().isAssignableFrom(type.getType());
    }

    @Override
    public Object create(Object parent, QName name) throws ConfigException {
        return this._type.create(parent, name);
    }

    @Override
    public void setText(Object bean, QName name, String value) throws ConfigException {
        try {
            AnnotationConfig ann = (AnnotationConfig)bean;
            ann.setAttribute(name.getLocalName(), this._type.valueOf(value));
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    @Override
    public void setValue(Object bean, QName name, Object value) throws ConfigException {
        try {
            AnnotationConfig ann = (AnnotationConfig)bean;
            ann.setAttribute(name.getLocalName(), value);
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }
}

