/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.gen;

import com.caucho.config.gen.AspectBeanFactory;
import com.caucho.config.gen.AspectFactory;
import com.caucho.config.gen.AspectGenerator;
import com.caucho.config.gen.AsynchronousFactory;
import com.caucho.config.gen.CacheFactory;
import com.caucho.config.gen.CandiMethodHeadFactory;
import com.caucho.config.gen.InterceptorFactory;
import com.caucho.config.gen.LockFactory;
import com.caucho.config.gen.MethodTailFactory;
import com.caucho.config.gen.SecurityFactory;
import com.caucho.config.gen.XaFactory;
import com.caucho.config.inject.InjectManager;
import com.caucho.inject.Module;
import com.caucho.java.JavaWriter;
import java.io.IOException;
import java.util.HashMap;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;

@Module
public class CandiAspectBeanFactory<X>
implements AspectBeanFactory<X> {
    private InjectManager _manager;
    private AnnotatedType<X> _beanType;
    private AspectFactory<X> _factory;

    public CandiAspectBeanFactory(InjectManager manager, AnnotatedType<X> beanType) {
        this._manager = manager;
        this._beanType = beanType;
        this._factory = this.createAspectFactory();
    }

    @Override
    public AnnotatedType<X> getBeanType() {
        return this._beanType;
    }

    @Override
    public String getGeneratedClassName() {
        return this.getBeanType().getJavaClass().getSimpleName() + "__ResinWebBean";
    }

    @Override
    public String getInstanceClassName() {
        return this.getBeanType().getJavaClass().getSimpleName();
    }

    @Override
    public AspectFactory<X> getHeadAspectFactory() {
        return this._factory;
    }

    @Override
    public boolean isProxy() {
        return true;
    }

    @Override
    public String getBeanInstance() {
        return "_bean";
    }

    @Override
    public String getInterceptorInstance() {
        return this.getBeanInstance();
    }

    @Override
    public String getBeanSuper() {
        return "_bean";
    }

    @Override
    public String getBeanProxy() {
        return "this";
    }

    @Override
    public String getBeanInfo() {
        return "this";
    }

    @Override
    public AspectGenerator<X> create(AnnotatedMethod<? super X> method) {
        return this._factory.create(method, false);
    }

    protected AspectFactory<X> createAspectFactory() {
        InjectManager manager = this._manager;
        AspectFactory next = new MethodTailFactory(this);
        next = new InterceptorFactory(this, next, manager);
        next = new CacheFactory(this, next);
        next = new XaFactory(this, next);
        next = new LockFactory(this, next);
        next = new AsynchronousFactory(this, next);
        next = new SecurityFactory(this, next);
        return new CandiMethodHeadFactory(this, next);
    }

    @Override
    public boolean isEnhanced() {
        if (this._factory != null) {
            return this._factory.isEnhanced();
        }
        return false;
    }

    @Override
    public void generateInject(JavaWriter out, HashMap<String, Object> map) throws IOException {
        if (this._factory != null) {
            this._factory.generateInject(out, map);
        }
    }

    @Override
    public void generatePostConstruct(JavaWriter out, HashMap<String, Object> map) throws IOException {
        if (this._factory != null) {
            this._factory.generatePostConstruct(out, map);
        }
    }

    @Override
    public void generatePreDestroy(JavaWriter out, HashMap<String, Object> map) throws IOException {
        if (this._factory != null) {
            this._factory.generatePreDestroy(out, map);
        }
    }

    @Override
    public void generateEpilogue(JavaWriter out, HashMap<String, Object> map) throws IOException {
        if (this._factory != null) {
            this._factory.generateEpilogue(out, map);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._beanType + "]";
    }
}

