/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.gen;

import com.caucho.config.gen.AbstractAspectFactory;
import com.caucho.config.gen.AspectBeanFactory;
import com.caucho.config.gen.AspectFactory;
import com.caucho.config.gen.AspectGenerator;
import com.caucho.config.gen.XaGenerator;
import com.caucho.inject.Module;
import javax.ejb.Remove;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;

@Module
public class XaFactory<X>
extends AbstractAspectFactory<X> {
    private TransactionAttributeType _classXa;
    private TransactionManagementType _classXaManagement;

    public XaFactory(AspectBeanFactory<X> beanFactory, AspectFactory<X> next) {
        super(beanFactory, next);
        AnnotatedType<X> beanType = beanFactory.getBeanType();
        TransactionAttribute xa = (TransactionAttribute)beanType.getAnnotation(TransactionAttribute.class);
        TransactionManagement xaManagement = (TransactionManagement)beanType.getAnnotation(TransactionManagement.class);
        if (xa != null) {
            this._classXa = xa.value();
        }
        if (xaManagement != null) {
            this._classXaManagement = xaManagement.value();
        }
    }

    @Override
    public AspectGenerator<X> create(AnnotatedMethod<? super X> method, boolean isEnhanced) {
        boolean isBeanManaged;
        if (method.isAnnotationPresent(Remove.class)) {
            return super.create(method, isEnhanced);
        }
        AnnotatedType declType = method.getDeclaringType();
        TransactionManagement xaManagement = (TransactionManagement)method.getAnnotation(TransactionManagement.class);
        TransactionManagementType xaManagementType = this._classXaManagement;
        if (xaManagement != null) {
            xaManagementType = xaManagement.value();
        }
        TransactionAttribute xa = (TransactionAttribute)method.getAnnotation(TransactionAttribute.class);
        TransactionAttributeType xaType = this._classXa;
        if (xa != null) {
            xaType = xa.value();
        } else if (declType != null && (xa = (TransactionAttribute)declType.getAnnotation(TransactionAttribute.class)) != null) {
            xaType = xa.value();
        }
        boolean bl = isBeanManaged = xaManagementType == TransactionManagementType.BEAN;
        if (isBeanManaged) {
            xaType = TransactionAttributeType.NOT_SUPPORTED;
        }
        if (xaType != null) {
            isEnhanced = true;
            AspectGenerator<? super X> next = super.create(method, isEnhanced);
            return new XaGenerator<X>(this, method, next, xaType, isBeanManaged);
        }
        return super.create(method, isEnhanced);
    }
}

