/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.inject;

import com.caucho.config.ConfigException;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.InterceptorLiteral;
import com.caucho.config.inject.InterceptorRuntimeBean;
import com.caucho.config.inject.ManagedBeanImpl;
import com.caucho.config.reflect.AnnotatedTypeImpl;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.decorator.Decorator;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.interceptor.InterceptorBinding;

public class InterceptorBean<X>
extends InterceptorRuntimeBean<X> {
    private static final L10N L = new L10N(InterceptorBean.class);
    private Class<X> _type;
    private ManagedBeanImpl<X> _bean;
    private HashSet<Annotation> _qualifiers = new HashSet();

    public InterceptorBean(InjectManager beanManager, Class<X> type) {
        super(null, type);
        this._type = type;
        if (Modifier.isAbstract(type.getModifiers())) {
            throw new IllegalStateException(type + " is an unexpected abstract type");
        }
        AnnotatedType<X> annType = beanManager.createAnnotatedType(this._type);
        AnnotatedTypeImpl<X> enhAnnType = AnnotatedTypeImpl.create(annType);
        enhAnnType.addAnnotation((Annotation)((Object)new InterceptorLiteral()));
        this._bean = beanManager.createManagedBean(enhAnnType);
        this.init();
    }

    public InterceptorBean(Class<X> type) {
        this(InjectManager.create(), type);
    }

    @Override
    public Bean<X> getBean() {
        return this;
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return this._bean.getQualifiers();
    }

    @Override
    public Set<Class<? extends Annotation>> getStereotypes() {
        return this._bean.getStereotypes();
    }

    @Override
    public String getName() {
        return this._bean.getName();
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isAlternative() {
        return false;
    }

    public boolean isPassivationCapable() {
        return false;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return this._bean.getScope();
    }

    @Override
    public Set<Type> getTypes() {
        return this._bean.getTypes();
    }

    @Override
    public Class<?> getBeanClass() {
        return this._bean.getBeanClass();
    }

    @Override
    public X create(CreationalContext<X> creationalContext) {
        X instance = this._bean.create(creationalContext);
        return instance;
    }

    @Override
    public void destroy(X instance, CreationalContext<X> env) {
    }

    @Override
    public Set<Annotation> getInterceptorBindings() {
        return this._qualifiers;
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this._bean.getInjectionPoints();
    }

    public void init() {
        this.introspect();
    }

    protected void introspect() {
        this.introspectQualifiers(this._type.getAnnotations());
        if (this._type.isAnnotationPresent(Decorator.class)) {
            throw new ConfigException(L.l("@Interceptor {0} cannot have a @Decorator annotation", (Object)this._type.getName()));
        }
    }

    protected void introspectQualifiers(Annotation[] annList) {
        for (Annotation ann : annList) {
            if (!ann.annotationType().isAnnotationPresent(InterceptorBinding.class)) continue;
            this._qualifiers.add(ann);
        }
    }

    public AnnotatedType getAnnotatedType() {
        return this._bean.getAnnotatedType();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        if (this._type != null) {
            sb.append(this._type.getSimpleName());
        }
        sb.append("]");
        return sb.toString();
    }
}

