/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.inject;

import com.caucho.config.ConfigException;
import com.caucho.config.bytecode.ScopeAdapter;
import com.caucho.config.bytecode.ScopeProxy;
import com.caucho.config.inject.AbstractIntrospectedBean;
import com.caucho.config.inject.CreationalContextImpl;
import com.caucho.config.inject.DisposesProducer;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.InjectionPointArg;
import com.caucho.config.inject.InjectionPointImpl;
import com.caucho.config.inject.ProducesCreationalContext;
import com.caucho.config.inject.ScopeAdapterBean;
import com.caucho.config.program.Arg;
import com.caucho.config.reflect.AnnotatedElementImpl;
import com.caucho.config.reflect.AnnotatedTypeUtil;
import com.caucho.inject.Module;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.IllegalProductException;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Producer;
import javax.inject.Named;
import javax.inject.Qualifier;

@Module
public class ProducesMethodBean<X, T>
extends AbstractIntrospectedBean<T>
implements ScopeAdapterBean<X> {
    private static final Logger log = Logger.getLogger(ProducesMethodBean.class.getName());
    private static final L10N L = new L10N(ProducesMethodBean.class);
    private static final Object[] NULL_ARGS = new Object[0];
    private final Bean<X> _producerBean;
    private final AnnotatedMethod<? super X> _producesMethod;
    private AnnotatedParameter<? super X> _disposedParam;
    private LinkedHashSet<InjectionPoint> _injectionPointSet = new LinkedHashSet();
    private MethodProducer _methodProducer;
    private DisposesProducer<T, X> _disposesProducer;
    private Producer<T> _producer;
    private boolean _isPassivating;
    private Arg<?>[] _producesArgs;
    private boolean _isBound;
    private Object _scopeAdapter;

    private ProducesMethodBean(InjectManager manager, Bean<X> producerBean, AnnotatedMethod<? super X> producesMethod, Arg<?>[] producesArgs, AnnotatedMethod<? super X> disposesMethod, Arg<?>[] disposesArgs) {
        super(manager, producesMethod.getBaseType(), (Annotated)producesMethod);
        this._producerBean = producerBean;
        this._producesMethod = producesMethod;
        this._producesArgs = producesArgs;
        if (producesMethod == null) {
            throw new NullPointerException();
        }
        if (producesArgs == null) {
            throw new NullPointerException();
        }
        producesMethod.getJavaMember().setAccessible(true);
        if (disposesMethod != null) {
            this._disposesProducer = new DisposesProducer(manager, producerBean, disposesMethod, disposesArgs);
            for (AnnotatedParameter param : disposesMethod.getParameters()) {
                if (!param.isAnnotationPresent(Disposes.class)) continue;
                this._disposedParam = param;
            }
        }
        this.introspectInjectionPoints();
        this._producer = this._methodProducer = new MethodProducer();
        Method javaMethod = producesMethod.getJavaMember();
        int modifiers = javaMethod.getModifiers();
        if (producesMethod.isAnnotationPresent(Specializes.class)) {
            if (Modifier.isStatic(modifiers)) {
                throw new ConfigException(L.l("{0}.{1} is an invalid @Specializes @Producer because the method is static.", (Object)javaMethod.getDeclaringClass().getName(), (Object)javaMethod.getName()));
            }
            Method parentMethod = this.getSpecializedMethod(javaMethod);
            if (parentMethod == null) {
                throw new ConfigException(L.l("{0}.{1} is an invalid @Specializes @Producer because it does not directly specialize a parent method", (Object)javaMethod.getDeclaringClass().getName(), (Object)javaMethod.getName()));
            }
            if (producesMethod.getJavaMember().isAnnotationPresent(Named.class) && parentMethod.isAnnotationPresent(Named.class)) {
                throw new ConfigException(L.l("{0}.{1} is an invalid @Specializes @Producer because both it and its parent defines @Named", (Object)javaMethod.getDeclaringClass().getName(), (Object)javaMethod.getName()));
            }
            for (Annotation ann : parentMethod.getAnnotations()) {
                if (!ann.annotationType().isAnnotationPresent(Qualifier.class) || !(producesMethod instanceof AnnotatedElementImpl)) continue;
                ((AnnotatedElementImpl)producesMethod).addAnnotation(ann);
            }
        }
    }

    private Method getSpecializedMethod(Method javaMethod) {
        Class<?> childClass = javaMethod.getDeclaringClass();
        Class<?> parentClass = childClass.getSuperclass();
        return AnnotatedTypeUtil.findMethod(parentClass.getDeclaredMethods(), javaMethod);
    }

    public static <X, T> ProducesMethodBean<X, T> create(InjectManager manager, Bean<X> producer, AnnotatedMethod<? super X> producesMethod, Arg<? super X>[] producesArgs, AnnotatedMethod<? super X> disposesMethod, Arg<? super X>[] disposesArgs) {
        ProducesMethodBean<X, T> bean = new ProducesMethodBean<X, T>(manager, producer, producesMethod, producesArgs, disposesMethod, disposesArgs);
        bean.introspect();
        bean.introspect((Annotated)producesMethod);
        return bean;
    }

    public Producer<T> getProducer() {
        return this._producer;
    }

    public void setProducer(Producer<T> producer) {
        this._producer = producer;
    }

    public Bean<?> getProducerBean() {
        return this._producerBean;
    }

    @Override
    protected String getDefaultName() {
        String methodName = this._producesMethod.getJavaMember().getName();
        if (methodName.startsWith("get") && methodName.length() > 3) {
            return Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
        }
        return methodName;
    }

    public boolean isInjectionPoint() {
        for (Class<?> paramType : this._producesMethod.getJavaMember().getParameterTypes()) {
            if (!InjectionPoint.class.equals(paramType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNullable() {
        return !this.getBaseType().isPrimitive();
    }

    @Override
    public Class<?> getBeanClass() {
        return this._producerBean.getBeanClass();
    }

    public AnnotatedMethod<? super X> getProducesMethod() {
        return this._producesMethod;
    }

    public AnnotatedParameter<? super X> getDisposedParameter() {
        return this._disposedParam;
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this._injectionPointSet;
    }

    @Override
    protected void introspectSpecializes(Annotated annotated) {
        if (!annotated.isAnnotationPresent(Specializes.class)) {
            return;
        }
    }

    private void introspectInjectionPoints() {
        for (AnnotatedParameter param : this._producesMethod.getParameters()) {
            InjectionPointImpl ip = new InjectionPointImpl(this.getBeanManager(), this, param);
            this._injectionPointSet.add(ip);
        }
    }

    @Override
    public void introspect() {
        super.introspect();
        this._isPassivating = this.getBeanManager().isPassivatingScope(this.getScope());
    }

    @Override
    public T create(CreationalContext<T> createEnv) {
        Object value = this._producer.produce(createEnv);
        createEnv.push(value);
        return (T)value;
    }

    @Override
    public X getScopeAdapter(Bean<?> topBean, CreationalContextImpl<X> cxt) {
        NormalScope scopeType = this.getScope().getAnnotation(NormalScope.class);
        if (scopeType != null) {
            Object value = this._scopeAdapter;
            if (value == null) {
                ScopeAdapter scopeAdapter = ScopeAdapter.create(this.getJavaClass());
                value = this._scopeAdapter = scopeAdapter.wrap(this.getBeanManager().createNormalInstanceFactory(topBean));
            }
            return (X)value;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind() {
        ProducesMethodBean producesMethodBean = this;
        synchronized (producesMethodBean) {
            if (this._isBound) {
                return;
            }
            this._isBound = true;
        }
    }

    @Override
    public void destroy(T instance, CreationalContext<T> cxt) {
        if (this._producer == this._methodProducer) {
            this._methodProducer.destroy(instance, (CreationalContextImpl)cxt);
        } else {
            this._producer.dispose(instance);
        }
        if (cxt instanceof CreationalContextImpl) {
            CreationalContextImpl env = (CreationalContextImpl)cxt;
            env.clearTarget();
        }
        cxt.release();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        Method method = this._producesMethod.getJavaMember();
        sb.append(this.getTargetSimpleName());
        sb.append(", ");
        sb.append(method.getDeclaringClass().getSimpleName());
        sb.append(".");
        sb.append(method.getName());
        sb.append("()");
        sb.append(", {");
        boolean isFirst = true;
        for (Annotation ann : this.getQualifiers()) {
            if (!isFirst) {
                sb.append(", ");
            }
            sb.append(ann);
            isFirst = false;
        }
        sb.append("}");
        if (this.getName() != null) {
            sb.append(", name=");
            sb.append(this.getName());
        }
        sb.append("]");
        return sb.toString();
    }

    class MethodProducer
    implements Producer<T> {
        MethodProducer() {
        }

        public T produce(CreationalContext<T> cxt) {
            Class type = ProducesMethodBean.this._producerBean.getBeanClass();
            CreationalContextImpl env = null;
            if (cxt instanceof CreationalContextImpl) {
                env = (CreationalContextImpl)cxt;
            }
            ProducesCreationalContext factoryEnv = null;
            Object factory = CreationalContextImpl.find(env, ProducesMethodBean.this._producerBean);
            if (factory == null) {
                factoryEnv = new ProducesCreationalContext(ProducesMethodBean.this._producerBean, env);
                factory = ProducesMethodBean.this.getBeanManager().getReference(ProducesMethodBean.this._producerBean, factoryEnv);
            }
            if (factory == null) {
                throw new IllegalStateException(L.l("{0}: unexpected null factory for {1}", (Object)this, (Object)ProducesMethodBean.this._producerBean));
            }
            Object instance = this.produce(factory, env);
            if (env != null && ProducesMethodBean.this._producerBean.getScope() == Dependent.class) {
                factoryEnv.release();
            }
            if (ProducesMethodBean.this._isPassivating && !(instance instanceof Serializable)) {
                throw new IllegalProductException(L.l("'{0}' is an invalid @{1} instance because it's not serializable for bean {2}", instance, (Object)ProducesMethodBean.this.getScope().getSimpleName(), (Object)this));
            }
            return instance;
        }

        private T produce(X factory, CreationalContextImpl<T> env) {
            try {
                Object[] args;
                if (ProducesMethodBean.this._producesArgs.length > 0) {
                    args = new Object[ProducesMethodBean.this._producesArgs.length];
                    for (int i = 0; i < args.length; ++i) {
                        args[i] = ProducesMethodBean.this._producesArgs[i] instanceof InjectionPointArg ? env.findInjectionPoint() : ProducesMethodBean.this._producesArgs[i].eval(env);
                    }
                } else {
                    args = NULL_ARGS;
                }
                Method method = ProducesMethodBean.this._producesMethod.getJavaMember();
                if (factory instanceof ScopeProxy && !Modifier.isPublic(method.getModifiers())) {
                    ScopeProxy proxy = (ScopeProxy)factory;
                    factory = proxy.__caucho_getDelegate();
                }
                Object value = method.invoke(factory, args);
                env.push(value);
                if (value != null) {
                    return value;
                }
                if (Dependent.class.equals(ProducesMethodBean.this.getScope())) {
                    return null;
                }
                throw new IllegalProductException(L.l("producer {0} returned null, which is not allowed by the CDI spec.", (Object)this));
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new CreationException(e.getCause());
            }
            catch (Exception e) {
                throw new CreationException((Throwable)e);
            }
        }

        public void dispose(T instance) {
            this.destroy(instance, null);
        }

        public void destroy(T instance, CreationalContextImpl<T> cxt) {
            if (ProducesMethodBean.this._disposesProducer != null) {
                ProducesMethodBean.this._disposesProducer.destroy(instance, cxt);
            }
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return ProducesMethodBean.this.getInjectionPoints();
        }

        public String toString() {
            Method javaMethod = ProducesMethodBean.this._producesMethod.getJavaMember();
            return this.getClass().getSimpleName() + "[" + javaMethod.getDeclaringClass().getSimpleName() + "." + javaMethod.getName() + "]";
        }
    }
}

