/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.type;

import com.caucho.config.ConfigException;
import com.caucho.config.type.ConfigType;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import java.util.Date;

public class DateType
extends ConfigType {
    private static final L10N L = new L10N(DateType.class);
    public static final DateType TYPE = new DateType();

    private DateType() {
    }

    public Class getType() {
        return Date.class;
    }

    @Override
    public Object valueOf(String text) {
        try {
            if (text == null) {
                return null;
            }
            if ("".equals(text)) {
                return new Date(CurrentTime.getCurrentTime());
            }
            QDate date = new QDate();
            date.parseDate(text);
            return new Date(date.getGMTTime());
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    @Override
    public Object valueOf(Object value) {
        if (value instanceof Date) {
            return value;
        }
        if (value instanceof QDate) {
            return new Date(((QDate)value).getGMTTime());
        }
        if (value instanceof String) {
            return this.valueOf((String)value);
        }
        if (value instanceof Number) {
            return new Date(((Number)value).longValue());
        }
        if (value == null) {
            return null;
        }
        return this.valueOf(String.valueOf(value));
    }
}

