/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.blob;

import com.caucho.db.block.Block;
import com.caucho.db.block.BlockStore;
import java.io.IOException;

public class InodeUpdate {
    private final BlockStore _store;
    private final byte[] _inode;
    private final int _inodeOffset;
    private Block _lastBlock;

    public InodeUpdate(BlockStore store, byte[] bytes, int offset) {
        this._store = store;
        this._inode = bytes;
        this._inodeOffset = offset;
    }

    public BlockStore getStore() {
        return this._store;
    }

    public byte[] getBuffer() {
        return this._inode;
    }

    public long getLength() {
        return InodeUpdate.readLong(this._inode, this._inodeOffset);
    }

    long readBlockLong(long blockAddress, int offset) throws IOException {
        long blockId = this._store.addressToBlockId(blockAddress);
        Block block = this._lastBlock;
        if (block == null) {
            this._lastBlock = block = this._store.readBlock(blockAddress);
        } else if (block.getBlockId() != blockId) {
            block.free();
            this._lastBlock = block = this._store.readBlock(blockAddress);
        }
        byte[] blockBuffer = block.getBuffer();
        return InodeUpdate.readLong(blockBuffer, offset);
    }

    public void close() {
        Block block = this._lastBlock;
        this._lastBlock = null;
        if (block != null) {
            block.free();
            block.save();
        }
    }

    public void writeBlockLong(long blockAddress, int offset, long value) throws IOException {
        long blockId = this._store.addressToBlockId(blockAddress);
        Block block = this._lastBlock;
        if (block == null) {
            this._lastBlock = block = this._store.readBlock(blockAddress);
        } else if (block.getBlockId() != blockId) {
            block.free();
            block.save();
            this._lastBlock = block = this._store.readBlock(blockAddress);
        }
        byte[] blockBuffer = block.getBuffer();
        InodeUpdate.writeLong(blockBuffer, offset, value);
        block.setDirty(offset, offset + 8);
    }

    public static long readLong(byte[] buffer, int offset) {
        return (((long)buffer[offset + 0] & 0xFFL) << 56) + (((long)buffer[offset + 1] & 0xFFL) << 48) + (((long)buffer[offset + 2] & 0xFFL) << 40) + (((long)buffer[offset + 3] & 0xFFL) << 32) + (((long)buffer[offset + 4] & 0xFFL) << 24) + (((long)buffer[offset + 5] & 0xFFL) << 16) + (((long)buffer[offset + 6] & 0xFFL) << 8) + ((long)buffer[offset + 7] & 0xFFL);
    }

    public static void writeLong(byte[] buffer, int offset, long v) {
        buffer[offset + 0] = (byte)(v >> 56);
        buffer[offset + 1] = (byte)(v >> 48);
        buffer[offset + 2] = (byte)(v >> 40);
        buffer[offset + 3] = (byte)(v >> 32);
        buffer[offset + 4] = (byte)(v >> 24);
        buffer[offset + 5] = (byte)(v >> 16);
        buffer[offset + 6] = (byte)(v >> 8);
        buffer[offset + 7] = (byte)v;
    }
}

