/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.block;

public enum BlockState {
    INIT{

        @Override
        public BlockState toValid() {
            return VALID;
        }

        @Override
        public BlockState toWrite() {
            return this;
        }

        @Override
        public BlockState toDestroy() {
            return DESTROYED;
        }
    }
    ,
    VALID{

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public BlockState toValid() {
            return VALID;
        }

        @Override
        public BlockState toWrite() {
            return WRITE_QUEUED;
        }

        @Override
        public BlockState toDestroy() {
            return DESTROYED;
        }
    }
    ,
    WRITE_QUEUED{

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public boolean isWrite() {
            return true;
        }

        @Override
        public BlockState toValid() {
            return VALID;
        }

        @Override
        public BlockState toWrite() {
            return this;
        }

        @Override
        public BlockState toDestroy() {
            return this;
        }
    }
    ,
    DESTROYED{

        @Override
        public boolean isDestroyed() {
            return true;
        }

        @Override
        public BlockState toWrite() {
            return this;
        }

        @Override
        public BlockState toDestroy() {
            return this;
        }
    };


    public boolean isValid() {
        return false;
    }

    public boolean isWrite() {
        return false;
    }

    public boolean isDestroyed() {
        return false;
    }

    public BlockState toValid() {
        throw new IllegalStateException(this.toString() + ": toValid()");
    }

    public BlockState toWrite() {
        throw new IllegalStateException(this.toString() + ": toWrite()");
    }

    public BlockState toDestroy() {
        throw new IllegalStateException(this.toString() + ": toDestroy()");
    }

    public BlockState toState(BlockState toState) {
        switch (toState) {
            case VALID: {
                return this.toValid();
            }
            case WRITE_QUEUED: {
                return this.toWrite();
            }
            case DESTROYED: {
                return this.toDestroy();
            }
        }
        throw new IllegalStateException(this.toString() + ": toState " + String.valueOf((Object)toState));
    }
}

