/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import java.sql.SQLException;
import java.util.ArrayList;

class BinaryColumnEqExpr
extends Expr {
    private Expr _column;
    private Expr _right;

    BinaryColumnEqExpr(Expr left, Expr right) {
        this._column = left;
        this._right = right;
    }

    @Override
    public Expr bind(Query query) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        return this._column.subCost(fromList) + this._right.subCost(fromList);
    }

    @Override
    public Class<?> getType() {
        return Boolean.TYPE;
    }

    @Override
    public boolean isNull(QueryContext context) throws SQLException {
        return this._column.isNull(context);
    }

    @Override
    public int evalBoolean(QueryContext context) throws SQLException {
        if (this._right.isNull(context)) {
            return -1;
        }
        if (this._column.isNull(context)) {
            return -1;
        }
        if (this._column.evalEqual(context, this._right.evalBytes(context))) {
            return 1;
        }
        return 0;
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        throw new SQLException("can't convert blob to boolean");
    }

    public String toString() {
        return "(" + this._column + " = " + this._right + ")";
    }
}

