/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.Database;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.table.Table;
import com.caucho.db.table.TableIterator;
import com.caucho.db.xa.DbTransaction;
import com.caucho.util.CharBuffer;
import com.caucho.util.SQLExceptionWrapper;
import java.io.IOException;
import java.sql.SQLException;

class DeleteQuery
extends Query {
    private final Table _table;

    DeleteQuery(Database db, String sql, Table table) throws SQLException {
        super(db, sql, null);
        this._table = table;
        this.setFromItems(new FromItem[]{new FromItem(table, table.getName())});
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute(QueryContext context, DbTransaction xa) throws SQLException {
        int count = 0;
        TableIterator[] rows = new TableIterator[1];
        try {
            Table table = this._table;
            synchronized (table) {
                try {
                    rows[0] = this._table.createTableIterator();
                    context.init(xa, rows, this.isReadOnly());
                    if (!this.start(rows, rows.length, context, xa)) {
                        return;
                    }
                    do {
                        if (!context.lock()) {
                            throw new IllegalStateException("unable to lock for delete");
                        }
                        try {
                            if (this.isSelect(context) && rows[0].delete()) {
                                context.setRowUpdateCount(++count);
                            }
                        }
                        finally {
                            context.unlock();
                        }
                        xa.commit();
                    } while (this.nextTuple(rows, rows.length, context, xa));
                }
                catch (IOException e) {
                    throw new SQLExceptionWrapper(e);
                }
                finally {
                    context.close();
                    this.freeRows(rows, rows.length);
                }
                return;
            }
        }
        finally {
            this._table.wakeWriter();
        }
    }

    public String toString() {
        CharBuffer cb = new CharBuffer();
        cb.append("DeleteQuery[");
        if (this._whereExpr != null) {
            cb.append(",where:" + this._whereExpr);
        }
        cb.append("]");
        return cb.close();
    }
}

