/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.Database;
import com.caucho.db.sql.AndExpr;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.IdExpr;
import com.caucho.db.sql.OidExpr;
import com.caucho.db.sql.ParamExpr;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.RowIterateExpr;
import com.caucho.db.sql.SelectCursor;
import com.caucho.db.sql.SubSelectExpr;
import com.caucho.db.sql.SubSelectParamExpr;
import com.caucho.db.table.Column;
import com.caucho.db.table.Table;
import com.caucho.db.table.TableIterator;
import com.caucho.db.xa.DbTransaction;
import com.caucho.inject.Module;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.SQLExceptionWrapper;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

@Module
public abstract class Query {
    private static final Logger log = Logger.getLogger(Query.class.getName());
    private static final L10N L = new L10N(Query.class);
    private Database _db;
    private String _sql;
    private FromItem[] _fromItems;
    private ParamExpr[] _params;
    private boolean _isGroup;
    private int _dataFieldCount;
    private Query _parent;
    private SubSelectExpr _parentSubSelect;
    private Expr[] _whereExprs;
    protected Expr _whereExpr;
    private RowIterateExpr[] _indexExprs;
    private ArrayList<SubSelectParamExpr> _paramExprs = new ArrayList();
    private InitRow _initRow;
    private InitRow[] _initRowArray;

    protected Query(Database db, String sql) {
        this._db = db;
        this._sql = sql;
    }

    protected Query(Database db, String sql, FromItem[] fromItems) {
        this._db = db;
        this._sql = sql;
        this._fromItems = fromItems;
    }

    public Database getDatabase() {
        return this._db;
    }

    public void setParent(Query query) {
        this._parent = query;
    }

    public Query getParent() {
        return this._parent;
    }

    public void setSubSelect(SubSelectExpr subSelect) {
        this._parentSubSelect = subSelect;
    }

    public SubSelectExpr getSubSelect() {
        return this._parentSubSelect;
    }

    public int getDataFields() {
        return this._dataFieldCount;
    }

    public void setDataFields(int fieldCount) {
        this._dataFieldCount = fieldCount;
    }

    public void setLimit(int limit) {
    }

    public final FromItem[] getFromItems() {
        return this._fromItems;
    }

    protected void setFromItems(FromItem[] fromItems) {
        this._fromItems = fromItems;
    }

    protected void setFromItems(ArrayList<FromItem> fromItems) {
        this._fromItems = new FromItem[fromItems.size()];
        fromItems.toArray(this._fromItems);
    }

    public void setWhereExpr(Expr expr) {
        this._whereExpr = expr;
    }

    public Expr[] getWhereExprs() {
        return this._whereExprs;
    }

    protected void setWhereExprs(Expr[] whereExprs) {
        this._whereExprs = whereExprs;
    }

    public void setParams(ParamExpr[] params) {
        this._params = params;
    }

    public ArrayList<SubSelectParamExpr> getParamExprs() {
        return this._paramExprs;
    }

    String getSQL() {
        return this._sql;
    }

    public boolean isSelect() {
        return false;
    }

    public boolean isReadOnly() {
        return true;
    }

    public void setGroup(boolean isGroup) {
        this._isGroup = isGroup;
    }

    public boolean isGroup() {
        return this._isGroup;
    }

    protected void bind() throws SQLException {
        Expr expr;
        int i;
        if (this._whereExpr != null) {
            this.generateWhere(this._whereExpr);
            for (i = 0; i < this._whereExprs.length; ++i) {
                expr = this._whereExprs[i];
                if (expr == null) continue;
                this._whereExprs[i] = expr.bind(this);
            }
        } else if (this._fromItems != null) {
            this._whereExprs = new Expr[this._fromItems.length + 1];
            this._indexExprs = new RowIterateExpr[this._fromItems.length];
        } else {
            this._whereExprs = new Expr[2];
            this._indexExprs = new RowIterateExpr[1];
        }
        for (i = 0; i < this._indexExprs.length; ++i) {
            expr = this._indexExprs[i];
            this._indexExprs[i] = expr != null ? (RowIterateExpr)this._indexExprs[i].bind(this) : RowIterateExpr.DEFAULT;
        }
        for (i = 0; i < this._paramExprs.size(); ++i) {
            expr = this._paramExprs.get(i);
            expr = (SubSelectParamExpr)((SubSelectParamExpr)expr).bind(this._parent);
            this._paramExprs.set(i, (SubSelectParamExpr)expr);
        }
        this._initRowArray = this._indexExprs.length > 0 ? new InitRow[this._indexExprs.length] : new InitRow[1];
        InitRow initRow = this._whereExprs[0] != null ? (this._indexExprs.length == 0 || this._indexExprs[0] == RowIterateExpr.DEFAULT ? new ExprTailNonIndexInitRow(this._whereExprs[0]) : new ExprTailInitRow(this._indexExprs[0], this._whereExprs[0])) : new TailInitRow(this._indexExprs[0]);
        this._initRowArray[0] = initRow;
        for (int i2 = 1; i2 < this._indexExprs.length; ++i2) {
            RowIterateExpr indexExpr = this._indexExprs[i2];
            if (indexExpr == null) {
                indexExpr = new RowIterateExpr();
            }
            initRow = this._whereExprs[i2] != null ? new ExprNonTailInitRow(i2, indexExpr, this._whereExprs[i2], initRow) : new NonTailInitRow(i2, indexExpr, initRow);
            this._initRowArray[i2] = initRow;
        }
        this._initRow = initRow;
    }

    protected void generateWhere(Expr whereExpr) throws SQLException {
        int i;
        ArrayList<Expr> andProduct = new ArrayList<Expr>();
        whereExpr.splitAnd(andProduct);
        FromItem[] fromItems = this.getFromItems();
        Expr[] whereExprs = new Expr[fromItems.length + 1];
        RowIterateExpr[] indexExprs = new RowIterateExpr[fromItems.length];
        this._whereExprs = whereExprs;
        this._indexExprs = indexExprs;
        ArrayList<FromItem> costItems = new ArrayList<FromItem>();
        this.orderFromItems(costItems, andProduct);
        costItems.clear();
        for (i = fromItems.length; i >= 0; --i) {
            long bestCost;
            if (i < fromItems.length) {
                costItems.add(fromItems[i]);
            }
            AndExpr subWhereExpr = null;
            int bestIndex = -1;
            do {
                bestCost = Long.MAX_VALUE;
                for (int j = andProduct.size() - 1; j >= 0; --j) {
                    Expr subExpr = andProduct.get(j);
                    long cost = subExpr.cost(costItems);
                    if (Integer.MAX_VALUE <= cost && i != 0 || cost >= bestCost) continue;
                    bestCost = cost;
                    bestIndex = j;
                }
                if (bestCost >= Long.MAX_VALUE) continue;
                Expr expr = andProduct.remove(bestIndex);
                RowIterateExpr indexExpr = null;
                if (i < fromItems.length) {
                    indexExpr = expr.getIndexExpr(fromItems[i]);
                }
                if (indexExpr != null && indexExprs[i] == null) {
                    indexExprs[i] = indexExpr;
                    continue;
                }
                if (subWhereExpr == null) {
                    subWhereExpr = new AndExpr();
                }
                subWhereExpr.add(expr);
            } while (bestCost < Long.MAX_VALUE);
            if (subWhereExpr == null) continue;
            whereExprs[i] = subWhereExpr.getSingleExpr();
        }
        for (i = 0; i < whereExprs.length; ++i) {
            Expr expr;
            whereExprs[i] = expr = whereExprs[i];
        }
        this.setWhereExprs(whereExprs);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("where-" + (whereExprs.length - 1) + ": static " + whereExprs[whereExprs.length - 1]);
            for (i = whereExprs.length - 2; i >= 0; --i) {
                if (this._indexExprs[i] != null) {
                    log.finest("index-" + i + ": " + this._fromItems[i] + " " + this._indexExprs[i]);
                }
                log.finest("where-" + i + ": " + this._fromItems[i] + " " + whereExprs[i]);
            }
        }
    }

    private void orderFromItems(ArrayList<FromItem> costItems, ArrayList<Expr> topAndProduct) {
        FromItem[] fromItems = this.getFromItems();
        ArrayList<Expr> andProduct = new ArrayList<Expr>(topAndProduct);
        for (int i = fromItems.length - 1; i >= 0; --i) {
            this.orderFromItemsTail(i, costItems, andProduct, fromItems);
            this.orderFromItemsUpdateAnd(andProduct, costItems);
        }
    }

    private void orderFromItemsTail(int i, ArrayList<FromItem> costItems, ArrayList<Expr> andProduct, FromItem[] fromItems) {
        costItems.clear();
        for (int j = i + 1; j < fromItems.length; ++j) {
            costItems.add(fromItems[j]);
        }
        int bestIndex = i;
        long bestCost = 9223372036854775L;
        for (int j = 0; j <= i; ++j) {
            long cost;
            FromItem item = fromItems[j];
            costItems.add(item);
            long indexCost = this.calculateOrderIndexCost(costItems, andProduct);
            if (indexCost < bestCost) {
                bestCost = indexCost;
                bestIndex = j;
            }
            if (this.isFromOrderValid(costItems, fromItems) && (cost = this.calculateOrderExprCost(costItems, andProduct)) >= 0L && cost < bestCost) {
                bestCost = cost;
                bestIndex = j;
            }
            costItems.remove(costItems.size() - 1);
        }
        FromItem tempItem = fromItems[i];
        fromItems[i] = fromItems[bestIndex];
        fromItems[bestIndex] = tempItem;
        costItems.add(fromItems[i]);
    }

    private boolean isFromOrderValid(ArrayList<FromItem> costItems, FromItem[] fromItems) {
        for (int k = 0; k < fromItems.length; ++k) {
            if (fromItems[k].isValid(costItems)) continue;
            return false;
        }
        return true;
    }

    private long calculateOrderExprCost(ArrayList<FromItem> costItems, ArrayList<Expr> andProduct) {
        long cost = Long.MAX_VALUE;
        int count = 0;
        for (int k = 0; k < andProduct.size(); ++k) {
            Expr expr = andProduct.get(k);
            long subCost = expr.cost(costItems);
            if (9223372036854775L <= subCost) {
                return -1L;
            }
            if (subCost < cost) {
                cost = subCost;
                count = 0;
                continue;
            }
            if (subCost != cost) continue;
            ++count;
        }
        return cost - (long)count;
    }

    private long calculateOrderIndexCost(ArrayList<FromItem> costItems, ArrayList<Expr> andProduct) {
        long cost = Long.MAX_VALUE;
        int count = 0;
        for (int k = 0; k < andProduct.size(); ++k) {
            Expr expr = andProduct.get(k);
            long subCost = expr.indexCost(costItems);
            if (subCost < cost) {
                cost = subCost;
                count = 0;
                continue;
            }
            if (subCost != cost) continue;
            ++count;
        }
        return cost - (long)count;
    }

    private void orderFromItemsUpdateAnd(ArrayList<Expr> andProduct, ArrayList<FromItem> costItems) {
        for (int k = andProduct.size() - 1; k >= 0; --k) {
            Expr expr = andProduct.get(k);
            long subCost = expr.cost(costItems);
            if (subCost >= Integer.MAX_VALUE) continue;
            andProduct.remove(k);
        }
    }

    private String logWhere() {
        CharBuffer cb = CharBuffer.allocate();
        cb.append("[");
        for (int i = 0; i < this._whereExprs.length; ++i) {
            if (i != 0) {
                cb.append(", ");
            }
            if (this._whereExprs[i] == null) continue;
            cb.append(this._whereExprs[i]);
        }
        cb.append("]");
        return cb.close();
    }

    protected Expr bind(String tableName, String columnName) throws SQLException {
        FromItem[] fromItems = this.getFromItems();
        if (tableName == null) {
            if ("resin_oid".equals(columnName)) {
                return new OidExpr(fromItems[0], fromItems[0].getTable(), 0);
            }
            for (int i = 0; i < fromItems.length; ++i) {
                Table table = fromItems[i].getTable();
                int columnIndex = table.getColumnIndex(columnName);
                if (columnIndex < 0) continue;
                Column column = table.getColumn(columnName);
                return new IdExpr(fromItems[i], column);
            }
            Expr expr = this.bindParent(tableName, columnName);
            if (expr != null) {
                return expr;
            }
            throw new SQLException(L.l("`{0}' is an unknown column.", (Object)columnName));
        }
        for (int i = 0; i < fromItems.length; ++i) {
            if (!tableName.equals(fromItems[i].getName())) continue;
            Table table = fromItems[i].getTable();
            if ("resin_oid".equals(columnName)) {
                return new OidExpr(fromItems[i], table, i);
            }
            int columnIndex = table.getColumnIndex(columnName);
            if (columnIndex < 0) {
                Expr expr = this.bindParent(tableName, columnName);
                if (expr != null) {
                    return expr;
                }
                throw new SQLException(L.l("`{0}' is an unknown column in \n  {1}.", (Object)columnName, (Object)this._sql));
            }
            Column column = table.getColumn(columnName);
            return new IdExpr(fromItems[i], column);
        }
        Expr expr = this.bindParent(tableName, columnName);
        if (expr != null) {
            return expr;
        }
        throw new SQLException(L.l("`{0}' is an unknown table.\n{1}", (Object)tableName, (Object)this.getSQL()));
    }

    private Expr bindParent(String tableName, String columnName) throws SQLException {
        Expr expr;
        if (this._parent != null && (expr = this._parent.bind(tableName, columnName)) != null) {
            SubSelectParamExpr paramExpr = new SubSelectParamExpr(this, expr, this._paramExprs.size());
            this._paramExprs.add(paramExpr);
            return paramExpr;
        }
        return null;
    }

    public abstract void execute(QueryContext var1, DbTransaction var2) throws SQLException;

    public SelectCursor executeCursor(QueryContext queryCtx, DbTransaction xa) throws SQLException {
        throw new UnsupportedOperationException(this.toString());
    }

    protected boolean start(TableIterator[] rows, int rowLength, QueryContext queryContext, DbTransaction xa) throws SQLException {
        try {
            Expr[] whereExprs = this._whereExprs;
            if (whereExprs != null && whereExprs[rowLength] != null && !whereExprs[rowLength].isSelect(queryContext)) {
                return false;
            }
            if (rowLength == 0) {
                return true;
            }
            for (int i = rowLength - 1; i >= 0; --i) {
                RowIterateExpr iterExpr = this._indexExprs[i];
                TableIterator row = rows[i];
                if (iterExpr.init(queryContext, row)) continue;
                return false;
            }
            return this._initRow.initBlockRow(rows, queryContext) || this.nextBlock(rowLength - 1, rows, rowLength, queryContext);
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper(e);
        }
    }

    protected boolean nextTuple(TableIterator[] rows, int rowLength, QueryContext queryContext, DbTransaction xa) throws IOException, SQLException {
        if (rowLength == 0) {
            return false;
        }
        RowIterateExpr[] indexExprs = this._indexExprs;
        Expr[] whereExprs = this._whereExprs;
        for (int i = 0; i < rowLength; ++i) {
            Expr whereExpr;
            TableIterator tableIter = rows[i];
            RowIterateExpr indexExpr = indexExprs[i];
            Expr expr = whereExpr = whereExprs == null ? null : whereExprs[i];
            while (indexExpr.nextRow(queryContext, tableIter)) {
                if (whereExpr != null && !whereExpr.isSelect(queryContext) || i != 0 && !this._initRowArray[i - 1].initBlockRow(rows, queryContext)) continue;
                return true;
            }
        }
        return this.nextBlock(rowLength - 1, rows, rowLength, queryContext);
    }

    protected boolean isSelect(QueryContext queryContext) throws SQLException {
        Expr[] whereExprs = this._whereExprs;
        for (int i = 0; i < whereExprs.length; ++i) {
            Expr whereExpr = whereExprs[i];
            if (whereExpr == null || whereExpr.isSelect(queryContext)) continue;
            return false;
        }
        return true;
    }

    private boolean nextBlock(int i, TableIterator[] rows, int rowLength, QueryContext queryContext) throws IOException, SQLException {
        TableIterator rowIter = rows[i];
        RowIterateExpr iterExpr = this._indexExprs[i];
        InitRow prevInitRow = rowLength > 0 ? this._initRowArray[rowLength - 1] : null;
        do {
            if (i > 0 && this.nextBlock(i - 1, rows, rowLength, queryContext)) {
                return true;
            }
            if (!iterExpr.nextBlock(queryContext, rowIter)) {
                return false;
            }
            if (!iterExpr.allowChildRowShift(queryContext, rows[i])) {
                return false;
            }
            for (int j = i - 1; j >= 0; --j) {
                if (iterExpr.init(queryContext, rows[j])) continue;
                return false;
            }
        } while (!prevInitRow.initBlockRow(rows, queryContext));
        return true;
    }

    protected void freeRows(TableIterator[] rows, int rowLength) {
        --rowLength;
        while (rowLength >= 0) {
            if (rows[rowLength] != null) {
                rows[rowLength].free();
            }
            --rowLength;
        }
    }

    static final class NonTailInitRow
    extends InitRow {
        private final InitRow _next;
        private final RowIterateExpr _iterExpr;
        private final int _rowIndex;

        NonTailInitRow(int rowIndex, RowIterateExpr iterExpr, InitRow next) {
            this._rowIndex = rowIndex;
            this._iterExpr = iterExpr;
            this._next = next;
        }

        @Override
        protected final boolean initBlockRow(TableIterator[] rows, QueryContext queryContext) throws IOException, SQLException {
            RowIterateExpr iterExpr = this._iterExpr;
            TableIterator rowIter = rows[this._rowIndex];
            if (!iterExpr.initRow(queryContext, rowIter)) {
                return false;
            }
            InitRow next = this._next;
            do {
                if (!next.initBlockRow(rows, queryContext)) continue;
                return true;
            } while (iterExpr.nextRow(queryContext, rowIter));
            return false;
        }
    }

    static final class TailInitRow
    extends InitRow {
        private final RowIterateExpr _iterExpr;

        TailInitRow(RowIterateExpr iterExpr) {
            if (iterExpr == null) {
                iterExpr = new RowIterateExpr();
            }
            this._iterExpr = iterExpr;
        }

        @Override
        protected final boolean initBlockRow(TableIterator[] rows, QueryContext queryContext) throws IOException, SQLException {
            RowIterateExpr iterExpr = this._iterExpr;
            TableIterator rowIter = rows[0];
            return iterExpr.initRow(queryContext, rowIter);
        }
    }

    static final class ExprNonTailInitRow
    extends InitRow {
        private final InitRow _next;
        private final RowIterateExpr _iterExpr;
        private final Expr _whereExpr;
        private final int _rowIndex;

        ExprNonTailInitRow(int rowIndex, RowIterateExpr iterExpr, Expr whereExpr, InitRow next) {
            this._rowIndex = rowIndex;
            this._iterExpr = iterExpr;
            this._whereExpr = whereExpr;
            this._next = next;
        }

        @Override
        protected final boolean initBlockRow(TableIterator[] rows, QueryContext queryContext) throws IOException, SQLException {
            RowIterateExpr iterExpr = this._iterExpr;
            TableIterator rowIter = rows[this._rowIndex];
            if (!iterExpr.initRow(queryContext, rowIter)) {
                return false;
            }
            Expr whereExpr = this._whereExpr;
            InitRow next = this._next;
            do {
                if (!whereExpr.isSelect(queryContext) || !next.initBlockRow(rows, queryContext)) continue;
                return true;
            } while (iterExpr.nextRow(queryContext, rowIter));
            return false;
        }
    }

    static final class ExprTailNonIndexInitRow
    extends InitRow {
        private final Expr _whereExpr;

        ExprTailNonIndexInitRow(Expr whereExpr) {
            this._whereExpr = whereExpr;
        }

        @Override
        protected final boolean initBlockRow(TableIterator[] rows, QueryContext queryContext) throws IOException, SQLException {
            TableIterator rowIter = rows[0];
            rowIter.initRow();
            if (!rowIter.nextRow()) {
                return false;
            }
            Expr whereExpr = this._whereExpr;
            do {
                if (!whereExpr.isSelect(queryContext)) continue;
                return true;
            } while (rowIter.nextRow());
            return false;
        }
    }

    static final class ExprTailInitRow
    extends InitRow {
        private final RowIterateExpr _iterExpr;
        private final Expr _whereExpr;

        ExprTailInitRow(RowIterateExpr iterExpr, Expr whereExpr) {
            this._iterExpr = iterExpr;
            this._whereExpr = whereExpr;
        }

        @Override
        protected final boolean initBlockRow(TableIterator[] rows, QueryContext queryContext) throws IOException, SQLException {
            RowIterateExpr iterExpr = this._iterExpr;
            TableIterator rowIter = rows[0];
            if (!iterExpr.initRow(queryContext, rowIter)) {
                return false;
            }
            Expr whereExpr = this._whereExpr;
            do {
                if (!whereExpr.isSelect(queryContext)) continue;
                return true;
            } while (iterExpr.nextRow(queryContext, rowIter));
            return false;
        }
    }

    static abstract class InitRow {
        InitRow() {
        }

        protected abstract boolean initBlockRow(TableIterator[] var1, QueryContext var2) throws IOException, SQLException;
    }
}

