/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SelectQuery;
import com.caucho.inject.Module;
import java.sql.SQLException;
import java.util.ArrayList;

@Module
public class SubSelectParamExpr
extends Expr {
    private SelectQuery _subselect;
    private Expr _expr;
    private int _index;

    SubSelectParamExpr(Query subselect, Expr expr, int index) {
        this._subselect = (SelectQuery)subselect;
        this._expr = expr;
        this._index = index;
        if (index < 0) {
            throw new IllegalStateException("index: " + index + " must be >= 0");
        }
    }

    public Class getType() {
        return this._expr.getType();
    }

    public Expr getExpr() {
        return this._expr;
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        return this._subselect.getSubSelect().cost(fromList) + 1L;
    }

    @Override
    public Expr bind(Query parent) throws SQLException {
        this._expr = this._expr.bind(parent);
        return this;
    }

    public void eval(QueryContext parent, QueryContext context) throws SQLException {
        Class type = this.getType();
        if (this._expr.isNull(parent)) {
            context.setNull(this._index + 1);
        } else if (Long.TYPE.equals(type)) {
            context.setLong(this._index + 1, this._expr.evalLong(parent));
        } else if (Integer.TYPE.equals(type)) {
            context.setLong(this._index + 1, this._expr.evalLong(parent));
        } else {
            context.setString(this._index + 1, this._expr.evalString(parent));
        }
    }

    @Override
    public boolean isNull(QueryContext context) throws SQLException {
        return context.isNull(this._index + 1);
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        return context.getString(this._index + 1);
    }

    @Override
    public int evalBoolean(QueryContext context) throws SQLException {
        return context.getBoolean(this._index + 1);
    }

    @Override
    public long evalLong(QueryContext context) throws SQLException {
        return context.getLong(this._index + 1);
    }

    @Override
    public double evalDouble(QueryContext context) throws SQLException {
        return context.getDouble(this._index + 1);
    }

    @Override
    public long evalDate(QueryContext context) throws SQLException {
        return context.getDate(this._index + 1);
    }

    @Override
    public int evalToBuffer(QueryContext context, byte[] buffer, int offset) throws SQLException {
        byte[] value = context.getBytes(this._index + 1);
        System.out.println("V: " + value);
        if (value != null) {
            System.arraycopy(value, 0, buffer, offset, value.length);
            return value.length;
        }
        return 0;
    }

    public String toString() {
        return "SubSelectParamExpr[" + this._expr + "]";
    }
}

