/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.message;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.Message;
import javax.jms.MessageListener;

public class MessageListenerAdapter
implements MessageListener,
MessageDrivenBean {
    private final Object _listener;
    private final MessageDrivenBean _messageDrivenBean;
    private final Method _onMessageMethod;
    private final Method _ejbCreateMethod;

    public MessageListenerAdapter(Object listener) throws NoSuchMethodException {
        Method ejbCreateMethod;
        Class<?> cl = listener.getClass();
        this._listener = listener;
        this._onMessageMethod = cl.getMethod("onMessage", Message.class);
        if (listener instanceof MessageDrivenBean) {
            this._messageDrivenBean = (MessageDrivenBean)listener;
            try {
                ejbCreateMethod = cl.getMethod("ejbCreate", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                ejbCreateMethod = null;
            }
        } else {
            this._messageDrivenBean = null;
            ejbCreateMethod = null;
        }
        this._ejbCreateMethod = ejbCreateMethod;
    }

    public Object getListener() {
        return this._listener;
    }

    public void onMessage(Message message) {
        try {
            this._onMessageMethod.invoke(this._listener, message);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void ejbCreate() throws IllegalAccessException, InvocationTargetException {
        if (this._ejbCreateMethod != null) {
            this._ejbCreateMethod.invoke(this._listener, new Object[0]);
        }
    }

    public void ejbRemove() throws EJBException {
        if (this._messageDrivenBean != null) {
            this._messageDrivenBean.ejbRemove();
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext ctx) throws EJBException {
        if (this._messageDrivenBean != null) {
            this._messageDrivenBean.setMessageDrivenContext(ctx);
        }
    }
}

