/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.service;

import com.caucho.VersionFactory;
import com.caucho.config.ConfigException;
import com.caucho.config.inject.BeanBuilder;
import com.caucho.config.inject.InjectManager;
import com.caucho.env.service.AbstractResinSubSystem;
import com.caucho.env.service.AfterResinStartListener;
import com.caucho.env.service.CdiSystem;
import com.caucho.env.service.ResinSubSystem;
import com.caucho.env.service.RootDirectorySystem;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.lifecycle.LifecycleListener;
import com.caucho.lifecycle.LifecycleState;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResinSystem {
    private static final L10N L = new L10N(ResinSystem.class);
    private static final Logger log = Logger.getLogger(ResinSystem.class.getName());
    private static final EnvironmentLocal<ResinSystem> _serverLocal = new EnvironmentLocal();
    private static WeakReference<ResinSystem> _globalSystemRef;
    private String _id;
    private EnvironmentClassLoader _classLoader;
    private final ConcurrentHashMap<Class<?>, ResinSubSystem> _serviceMap = new ConcurrentHashMap();
    private final TreeSet<ResinSubSystem> _pendingStart = new TreeSet<ResinSubSystem>(new StartComparator());
    private final ArrayList<AfterResinStartListener> _afterStartListeners = new ArrayList();
    private InjectManager _injectManager;
    private Throwable _configException;
    private final Lifecycle _lifecycle;
    private long _startTime;

    public ResinSystem(String id) {
        this(id, (ClassLoader)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResinSystem(String id, ClassLoader loader) {
        if (id == null) {
            id = "default";
        }
        this._id = id;
        this._classLoader = loader instanceof EnvironmentClassLoader ? (EnvironmentClassLoader)loader : EnvironmentClassLoader.create(loader, "resin-system:");
        _serverLocal.set(this, this._classLoader);
        _globalSystemRef = new WeakReference<ResinSystem>(this);
        this._lifecycle = new Lifecycle(log, this.toString(), Level.FINE);
        this.addService(new ClassLoaderService());
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            Environment.init();
            this._injectManager = InjectManager.create();
            CdiSystem.createAndAddService();
            BeanBuilder<ResinSystem> beanFactory = this._injectManager.createBeanFactory(ResinSystem.class);
            beanFactory.type(new Type[]{ResinSystem.class});
            this._injectManager.addBeanDiscover(beanFactory.singleton(this));
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    public ResinSystem(String id, Path rootDirectory) throws IOException {
        this(id, rootDirectory, rootDirectory.lookup("resin-data"));
    }

    public ResinSystem(String id, Path rootDirectory, Path dataDirectory) throws IOException {
        this(id);
        this.configureRoot(rootDirectory, dataDirectory);
    }

    private void configureRoot(Path rootDirectory, Path dataDirectory) throws IOException {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            RootDirectorySystem.createAndAddService(rootDirectory, dataDirectory);
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    public void setId(String id) {
        this._id = id;
    }

    public static ResinSystem getCurrent() {
        WeakReference<ResinSystem> globalRef;
        ResinSystem system = _serverLocal.get();
        if (system == null && (globalRef = _globalSystemRef) != null) {
            system = (ResinSystem)globalRef.get();
        }
        return system;
    }

    public static <T extends ResinSubSystem> T getCurrentService(Class<T> serviceClass) {
        ResinSystem manager = ResinSystem.getCurrent();
        if (manager != null) {
            return manager.getService(serviceClass);
        }
        return null;
    }

    public static String getCurrentId() {
        ResinSystem system = ResinSystem.getCurrent();
        if (system == null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            throw new IllegalStateException(L.l("ResinSystem is not available in this context.\n  {0}", (Object)loader));
        }
        return system.getId();
    }

    public String getId() {
        return this._id;
    }

    public EnvironmentClassLoader getClassLoader() {
        return this._classLoader;
    }

    public Throwable getConfigException() {
        return this._configException;
    }

    public void setConfigException(Throwable exn) {
        this._configException = exn;
    }

    public long getStartTime() {
        return this._startTime;
    }

    public String getState() {
        return this._lifecycle.getStateName();
    }

    public LifecycleState getLifecycleState() {
        return this._lifecycle.getState();
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this._lifecycle.addListener(listener);
    }

    public boolean isModified() {
        boolean isModified = this._classLoader.isModified();
        if (isModified) {
            this._classLoader.logModified(log);
        }
        return isModified;
    }

    public boolean isModifiedNow() {
        boolean isModified = this._classLoader.isModifiedNow();
        if (isModified) {
            log.fine("server is modified");
        }
        return isModified;
    }

    public boolean isAfterStarting() {
        return this._lifecycle.getState().isAfterStarting();
    }

    public boolean isBeforeActive() {
        return this._lifecycle.getState().isBeforeActive();
    }

    public boolean isStopping() {
        return this._lifecycle.isStopping();
    }

    public boolean isStopped() {
        return this._lifecycle.isStopped();
    }

    public boolean isDestroyed() {
        return this._lifecycle.isDestroyed();
    }

    public boolean isDestroying() {
        return this._lifecycle.isDestroying();
    }

    public boolean isActive() {
        return this._lifecycle.isActive();
    }

    public void addService(ResinSubSystem service) {
        this.addService(service.getClass(), service);
    }

    public void addService(Class<?> serviceApi, ResinSubSystem service) {
        ResinSubSystem oldService = this._serviceMap.putIfAbsent(serviceApi, service);
        if (oldService != null) {
            throw new IllegalStateException(L.l("duplicate service '{0}' is not allowed because another service with that class is already registered '{1}'", (Object)service, (Object)oldService));
        }
        this._pendingStart.add(service);
        if (this._lifecycle.isActive()) {
            this.startServices();
        }
    }

    public <T extends ResinSubSystem> T addServiceIfAbsent(T service) {
        return this.addServiceIfAbsent(service.getClass(), service);
    }

    public <T extends ResinSubSystem> T addServiceIfAbsent(Class<?> serviceApi, T service) {
        ResinSubSystem oldService = this._serviceMap.putIfAbsent(serviceApi, service);
        if (oldService != null) {
            return (T)oldService;
        }
        this._pendingStart.add(service);
        if (this._lifecycle.isActive()) {
            this.startServices();
        }
        return null;
    }

    public <T extends ResinSubSystem> T getService(Class<T> cl) {
        return (T)this._serviceMap.get(cl);
    }

    public void addListener(AfterResinStartListener listener) {
        this._afterStartListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            if (!this._lifecycle.toStarting()) {
                return;
            }
            this._startTime = CurrentTime.getCurrentTime();
            if (!CurrentTime.isTest()) {
                log.info("");
                log.info(VersionFactory.getFullVersion());
                log.info("");
                log.info(System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch"));
                log.info(System.getProperty("java.runtime.name") + " " + System.getProperty("java.runtime.version") + ", " + System.getProperty("file.encoding") + ", " + System.getProperty("user.language"));
                log.info(System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + ", " + System.getProperty("sun.arch.data.model") + ", " + System.getProperty("java.vm.info") + ", " + System.getProperty("java.vm.vendor"));
                log.info("");
                log.info("user.name  = " + System.getProperty("user.name"));
            }
            this.startServices();
            this._lifecycle.toActive();
            for (AfterResinStartListener listener : this._afterStartListeners) {
                listener.afterStart();
            }
        }
        finally {
            if (!this._lifecycle.isActive()) {
                this._lifecycle.toError();
            }
            thread.setContextClassLoader(oldLoader);
        }
    }

    private void startServices() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            while (this._pendingStart.size() > 0) {
                ResinSubSystem service = this._pendingStart.first();
                this._pendingStart.remove(service);
                thread.setContextClassLoader(this._classLoader);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(service + " starting");
                }
                service.start();
                if (!log.isLoggable(Level.FINEST)) continue;
                log.finest(service + " active");
            }
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, e.toString(), e);
            this._lifecycle.toError();
            throw e;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            this._lifecycle.toError();
            throw new RuntimeException(e);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            if (!this._lifecycle.toStopping()) {
                return;
            }
            TreeSet<ResinSubSystem> services = new TreeSet<ResinSubSystem>(new StopComparator());
            services.addAll(this._serviceMap.values());
            for (ResinSubSystem service : services) {
                try {
                    thread.setContextClassLoader(this._classLoader);
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest(service + " stopping");
                    }
                    service.stop();
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        }
        finally {
            this._lifecycle.toStop();
            thread.setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.stop();
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            TreeSet<ResinSubSystem> services = new TreeSet<ResinSubSystem>(new StopComparator());
            services.addAll(this._serviceMap.values());
            this._serviceMap.clear();
            for (ResinSubSystem service : services) {
                try {
                    service.destroy();
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            WeakReference<ResinSystem> globalRef = _globalSystemRef;
            if (globalRef != null && globalRef.get() == this) {
                _globalSystemRef = null;
            }
            _serverLocal.set(null, this._classLoader.getParent());
            log.fine(this + " destroyed");
            this._classLoader.destroy();
        }
        finally {
            DynamicClassLoader.setOldLoader(thread, oldLoader);
            this._classLoader = null;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.getId() + "]";
    }

    static class StopComparator
    implements Comparator<ResinSubSystem> {
        StopComparator() {
        }

        @Override
        public int compare(ResinSubSystem a, ResinSubSystem b) {
            int cmp = b.getStopPriority() - a.getStopPriority();
            if (cmp != 0) {
                return cmp;
            }
            return b.getClass().getName().compareTo(a.getClass().getName());
        }
    }

    static class StartComparator
    implements Comparator<ResinSubSystem> {
        StartComparator() {
        }

        @Override
        public int compare(ResinSubSystem a, ResinSubSystem b) {
            int cmp = a.getStartPriority() - b.getStartPriority();
            if (cmp != 0) {
                return cmp;
            }
            return a.getClass().getName().compareTo(b.getClass().getName());
        }
    }

    class ClassLoaderService
    extends AbstractResinSubSystem {
        ClassLoaderService() {
        }

        @Override
        public int getStartPriority() {
            return 70;
        }

        @Override
        public int getStopPriority() {
            return 10;
        }

        @Override
        public void start() {
            ResinSystem.this._classLoader.start();
        }

        @Override
        public void stop() {
            ResinSystem.this._classLoader.stop();
        }

        @Override
        public void destroy() {
            ResinSystem.this._classLoader.destroy();
        }
    }
}

