/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.thread2;

import com.caucho.config.ConfigException;
import com.caucho.env.thread2.AbstractTaskWorker2;
import com.caucho.inject.Module;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.util.ThreadDump;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

@Module
public abstract class AbstractThreadLauncher2
extends AbstractTaskWorker2 {
    private static final L10N L = new L10N(AbstractThreadLauncher2.class);
    private static final Logger log = Logger.getLogger(AbstractThreadLauncher2.class.getName());
    private static final long LAUNCHER_TIMEOUT = 60000L;
    private static final int DEFAULT_THREAD_MAX = 8192;
    private static final int DEFAULT_IDLE_MIN = 2;
    private static final int DEFAULT_IDLE_MAX = 0x3FFFFFFF;
    private static final long DEFAULT_IDLE_TIMEOUT = 60000L;
    private int _threadMax = 8192;
    private int _idleMin = 2;
    private int _idleMax = 0x3FFFFFFF;
    private long _idleTimeout = 60000L;
    private long _throttlePeriod = 1000L;
    private int _throttleLimit = 100;
    private long _throttleSleep = 0L;
    private final AtomicInteger _threadCount = new AtomicInteger();
    private final AtomicInteger _idleCount = new AtomicInteger();
    private final AtomicInteger _startingCount = new AtomicInteger();
    private final AtomicLong _createCountTotal = new AtomicLong();
    private final AtomicLong _threadIdleExpireTime = new AtomicLong();
    private long _throttleTimestamp;
    private long _throttleCount;
    private boolean _isThrottle;
    private final AtomicInteger _gId = new AtomicInteger();
    private final Lifecycle _lifecycle;

    protected AbstractThreadLauncher2() {
        this(Thread.currentThread().getContextClassLoader());
    }

    protected AbstractThreadLauncher2(ClassLoader loader) {
        super(loader);
        this.setWorkerIdleTimeout(60000L);
        this._lifecycle = new Lifecycle();
    }

    protected abstract void launchChildThread(int var1);

    public void setThreadMax(int max) {
        if (max <= 0) {
            max = 8192;
        }
        if (max < this._idleMin) {
            throw new ConfigException(L.l("IdleMin ({0}) must be less than ThreadMax ({1})", this._idleMin, max));
        }
        if (max < 1) {
            throw new ConfigException(L.l("ThreadMax ({0}) must be greater than zero", max));
        }
        this._threadMax = max;
        this.update();
    }

    public int getThreadMax() {
        return this._threadMax;
    }

    public void setIdleMin(int min) {
        if (min <= 0) {
            min = 2;
        }
        if (this._threadMax < min) {
            throw new ConfigException(L.l("IdleMin ({0}) must be less than ThreadMax ({1})", min, this._threadMax));
        }
        if (min <= 0) {
            throw new ConfigException(L.l("IdleMin ({0}) must be greater than 0.", min));
        }
        this._idleMin = min;
        this.update();
    }

    public int getIdleMin() {
        return this._idleMin;
    }

    public void setIdleMax(int max) {
        if (max <= 0) {
            max = 0x3FFFFFFF;
        }
        if (this._threadMax < max) {
            throw new ConfigException(L.l("IdleMax ({0}) must be less than ThreadMax ({1})", max, this._threadMax));
        }
        if (max <= 0) {
            throw new ConfigException(L.l("IdleMax ({0}) must be greater than 0.", max));
        }
        this._idleMax = max;
        this.update();
    }

    public int getIdleMax() {
        return this._idleMax;
    }

    public void setIdleTimeout(long timeout) {
        this._idleTimeout = timeout;
    }

    public long getIdleTimeout() {
        return this._idleTimeout;
    }

    protected boolean isEnable() {
        return this._lifecycle.isActive();
    }

    public void setThrottlePeriod(long period) {
        this._throttlePeriod = period;
    }

    public void setThrottleLimit(int limit) {
        this._throttleLimit = limit;
    }

    public void setThrottleSleepTime(long period) {
        this._throttleSleep = period;
    }

    public void start() {
        this._lifecycle.toActive();
        this.wake();
    }

    @Override
    public void close() {
        super.close();
        this._lifecycle.toDestroy();
    }

    public boolean isThreadMax() {
        return this._threadMax <= this._threadCount.get() + this._startingCount.get();
    }

    public boolean isThreadHigh() {
        int startCount;
        int threadCount = this._threadCount.get();
        return this._threadMax < 2 * (threadCount + (startCount = this._startingCount.get()));
    }

    public void onChildThreadLaunchBegin() {
        this._threadCount.incrementAndGet();
        int startCount = this._startingCount.decrementAndGet();
        if (startCount < 0) {
            this._startingCount.set(0);
            new IllegalStateException().printStackTrace();
        }
        this._createCountTotal.incrementAndGet();
        this.wakeIfLowIdle();
    }

    public void onChildThreadLaunchEnd() {
        try {
            if (this._threadMax <= this._threadCount.getAndDecrement()) {
                this.wake();
            }
            this.wakeIfLowIdle();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onChildThreadResumeBegin() {
        this._threadCount.incrementAndGet();
    }

    public void onChildThreadResumeEnd() {
        int threadMax = this._threadCount.getAndDecrement();
        if (this._threadMax <= threadMax) {
            this.wake();
        }
        this.wakeIfLowIdle();
    }

    public boolean isIdleExpire() {
        if (!this._lifecycle.isActive()) {
            return true;
        }
        long now = this.getCurrentTimeActual();
        long idleExpire = this._threadIdleExpireTime.get();
        int idleCount = this._idleCount.get();
        if (this._idleMin < idleCount) {
            long nextIdleExpire = now + this._idleTimeout;
            if (this._idleMax < idleCount && this._idleMin < this._idleMax) {
                this._threadIdleExpireTime.compareAndSet(idleExpire, nextIdleExpire);
                return true;
            }
            if (idleExpire < now && this._threadIdleExpireTime.compareAndSet(idleExpire, nextIdleExpire)) {
                return true;
            }
        }
        return false;
    }

    public final boolean isIdleLow() {
        return this._idleCount.get() < this._idleMin;
    }

    public boolean isIdleOverflow() {
        return this._idleMax < this._idleCount.get();
    }

    public void onChildIdleBegin() {
        this._idleCount.incrementAndGet();
    }

    public void onChildIdleEnd() {
        this._idleCount.decrementAndGet();
        this.wakeIfLowIdle();
    }

    private void wakeIfLowIdle() {
        int startingCount;
        int idleCount = this._idleCount.get();
        if (idleCount + (startingCount = this._startingCount.get()) < this._idleMin) {
            this.updateIdleExpireTime(this.getCurrentTimeActual());
            this.wake();
        }
    }

    protected void updateIdleExpireTime(long now) {
        this._threadIdleExpireTime.set(now + this._idleTimeout);
    }

    protected boolean doStart() {
        if (!this._lifecycle.isActive()) {
            return false;
        }
        if (!this.isEnable()) {
            return false;
        }
        int startingCount = this._startingCount.getAndIncrement();
        int threadCount = this._threadCount.get() + startingCount;
        if (this._threadMax < threadCount) {
            this._startingCount.decrementAndGet();
            this.onThreadMax();
            return false;
        }
        if (this.isIdleTooLow(startingCount)) {
            return true;
        }
        this._startingCount.decrementAndGet();
        return false;
    }

    protected boolean isIdleTooLow(int startingCount) {
        return this._idleCount.get() + startingCount < this._idleMin;
    }

    protected void update() {
        long now = this.getCurrentTimeActual();
        this._threadIdleExpireTime.set(now + this._idleTimeout);
        this.wake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startConnection() {
        while (this.doStart()) {
            boolean isValid = false;
            try {
                long now = this.getCurrentTimeActual();
                this.updateIdleExpireTime(now);
                int id = this._gId.incrementAndGet();
                this.updateThrottle();
                if (log.isLoggable(Level.FINER) && id == 1000) {
                    ThreadDump.create().dumpThreads();
                }
                this.launchChildThread(id);
                isValid = true;
            }
            finally {
                if (isValid) continue;
                this.onStartFail();
            }
        }
    }

    private void onStartFail() {
        this._startingCount.getAndDecrement();
    }

    protected void updateThrottle() {
        long now = CurrentTime.getCurrentTimeActual();
        if (this._throttleTimestamp + this._throttlePeriod < now) {
            this._throttleTimestamp = now;
            this._throttleCount = 1L;
            this._isThrottle = false;
            return;
        }
        ++this._throttleCount;
        if (this._throttleCount < (long)this._throttleLimit) {
            return;
        }
        if (!this._isThrottle) {
            this._isThrottle = true;
            if (this._throttleSleep > 0L || log.isLoggable(Level.FINE)) {
                String msg = this + " " + this._throttleCount + " threads created in " + this._throttlePeriod + "ms sleep=" + this._throttleSleep + "ms";
                this.onThrottle(msg);
            }
        }
        if (this._throttleSleep > 0L) {
            try {
                Thread.sleep(this._throttleSleep);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void onThreadMax() {
    }

    protected void onThrottle(String msg) {
        log.warning(msg);
    }

    public int getThreadCount() {
        return this._threadCount.get();
    }

    public int getIdleCount() {
        return this._idleCount.get();
    }

    public int getStartingCount() {
        return this._startingCount.get();
    }

    public long getCreateCountTotal() {
        return this._createCountTotal.get();
    }

    @Override
    public long runTask() {
        try {
            this.startConnection();
            return 120000L;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return 1000L;
        }
    }
}

