/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hemp.servlet;

import com.caucho.bam.BamError;
import com.caucho.bam.BamException;
import com.caucho.bam.Query;
import com.caucho.bam.actor.SimpleActor;
import com.caucho.bam.broker.Broker;
import com.caucho.hemp.servlet.ClientStubManager;
import com.caucho.hemp.servlet.LoginQuery;
import com.caucho.hemp.servlet.ServerAuthManager;
import com.caucho.hmtp.AuthQuery;
import com.caucho.hmtp.AuthResult;
import com.caucho.hmtp.NonceQuery;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerLinkActor
extends SimpleActor {
    private static final Logger log = Logger.getLogger(ServerLinkActor.class.getName());
    private final ClientStubManager _clientManager;
    private final ServerAuthManager _authManager;
    private final String _ipAddress;
    private String _clientAddress;

    public ServerLinkActor(Broker toLinkBroker, ClientStubManager clientManager, ServerAuthManager authManager, String ipAddress) {
        super(null, toLinkBroker);
        this._clientManager = clientManager;
        this._authManager = authManager;
        this._ipAddress = ipAddress;
    }

    @Query
    public void getNonce(long id, String to, String from, NonceQuery query) {
        NonceQuery result = this._authManager.generateNonce(query);
        this.getBroker().queryResult(id, from, to, result);
    }

    @Query
    public void authLogin(long id, String to, String from, LoginQuery query) {
        this.login(id, to, from, query.getAuth(), query.getAddress());
    }

    @Query
    public void authLogin(long id, String to, String from, AuthQuery query) {
        this.login(id, to, from, query, this._ipAddress);
    }

    private void login(long id, String to, String from, AuthQuery query, String ipAddress) {
        String uid = query.getUid();
        Serializable credentials = query.getCredentials();
        try {
            this._authManager.authenticate(query.getUid(), credentials, ipAddress);
        }
        catch (BamException e) {
            log.log(Level.FINE, e.toString(), e);
            this.getBroker().queryError(id, from, to, query, e.createActorError());
            return;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            this.getBroker().queryError(id, from, to, query, new BamError("auth", "not-authorized", e.getMessage()));
            return;
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        this._clientManager.login(uid, query.getResource());
        this.notifyValidLogin(from);
        AuthResult result = new AuthResult(this._clientManager.getAddress());
        this.getBroker().queryResult(id, from, to, result);
    }

    protected void onClose() {
        this._clientManager.logout();
    }

    protected void notifyValidLogin(String address) {
    }
}

