/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hemp.servlet;

import com.caucho.bam.BamError;
import com.caucho.bam.broker.AbstractBroker;
import com.caucho.bam.broker.Broker;
import com.caucho.bam.mailbox.Mailbox;
import com.caucho.bam.stream.MessageStream;
import com.caucho.hemp.servlet.ClientStubManager;
import java.io.Serializable;

public class ServerProxyBroker
extends AbstractBroker {
    private final Broker _broker;
    private final ClientStubManager _clientManager;
    private final Mailbox _toLinkMailbox;
    private final MessageStream _linkActor;

    public ServerProxyBroker(Broker broker, ClientStubManager clientManager, MessageStream linkActor) {
        this._broker = broker;
        this._clientManager = clientManager;
        this._linkActor = linkActor;
        this._toLinkMailbox = this._clientManager.getToLinkMailbox();
    }

    private Mailbox getLinkMailbox() {
        return this._toLinkMailbox;
    }

    @Override
    public String getAddress() {
        return null;
    }

    private boolean isActive() {
        return this._clientManager.isActive();
    }

    public String getClientAddress() {
        return this._clientManager.getAddress();
    }

    @Override
    public Mailbox getMailbox(String address) {
        return null;
    }

    @Override
    public void message(String to, String from, Serializable payload) {
        try {
            if (to == null) {
                this._linkActor.message(to, from, payload);
            } else if (this.isActive()) {
                this._broker.message(to, this.getClientAddress(), payload);
            } else {
                super.message(to, from, payload);
            }
        }
        catch (Throwable e) {
            this.getLinkMailbox().messageError(from, to, payload, BamError.create(e));
        }
    }

    @Override
    public void messageError(String to, String from, Serializable payload, BamError error) {
        if (to == null) {
            this._linkActor.messageError(to, from, payload, error);
        } else if (this.isActive()) {
            this._broker.messageError(to, this.getClientAddress(), payload, error);
        } else {
            super.messageError(to, from, payload, error);
        }
    }

    @Override
    public void query(long id, String to, String from, Serializable payload) {
        try {
            if (to == null) {
                this._linkActor.query(id, to, from, payload);
            } else if (this.isActive()) {
                this._broker.query(id, to, this.getClientAddress(), payload);
            } else {
                super.query(id, to, from, payload);
            }
        }
        catch (Throwable e) {
            this.getLinkMailbox().queryError(id, from, to, payload, BamError.create(e));
        }
    }

    @Override
    protected MessageStream getQueryErrorStream(String from) {
        return this.getLinkMailbox();
    }

    @Override
    public void queryResult(long id, String to, String from, Serializable payload) {
        if (to == null) {
            this._linkActor.queryResult(id, to, from, payload);
        } else if (this.isActive()) {
            this._broker.queryResult(id, to, this.getClientAddress(), payload);
        } else {
            super.queryResult(id, to, from, payload);
        }
    }

    @Override
    public void queryError(long id, String to, String from, Serializable payload, BamError error) {
        if (to == null) {
            this._linkActor.queryError(id, to, from, payload, error);
        } else if (this.isActive()) {
            this._broker.queryError(id, to, this.getClientAddress(), payload, error);
        } else {
            super.queryError(id, to, from, payload, error);
        }
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getAddress() + "," + this._linkActor + "]";
    }
}

