/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hmtp;

import com.caucho.bam.BamError;
import com.caucho.bam.ProtocolException;
import com.caucho.bam.broker.AbstractBroker;
import com.caucho.hmtp.HmtpWriter;
import com.caucho.util.IoUtil;
import com.caucho.websocket.WebSocketContext;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public class HmtpWebSocketContextWriter
extends AbstractBroker {
    private String _address;
    private WebSocketContext _ws;
    private HmtpWriter _hOut;

    public HmtpWebSocketContextWriter(WebSocketContext ws) {
        this._ws = ws;
        this._hOut = new HmtpWriter();
    }

    @Override
    public String getAddress() {
        return this._address;
    }

    public void setAddress(String address) {
        this._address = address;
    }

    @Override
    public void message(String to, String from, Serializable payload) {
        OutputStream os = null;
        try {
            os = this._ws.startBinaryMessage();
            this._hOut.message(os, to, from, payload);
        }
        catch (IOException e) {
            throw new ProtocolException(e);
        }
        finally {
            IoUtil.close(os);
        }
    }

    @Override
    public void messageError(String to, String from, Serializable payload, BamError error) {
        OutputStream os = null;
        try {
            os = this._ws.startBinaryMessage();
            this._hOut.messageError(os, to, from, payload, error);
        }
        catch (IOException e) {
            throw new ProtocolException(e);
        }
        finally {
            IoUtil.close(os);
        }
    }

    @Override
    public void query(long id, String to, String from, Serializable payload) {
        OutputStream os = null;
        try {
            os = this._ws.startBinaryMessage();
            this._hOut.query(os, id, to, from, payload);
        }
        catch (IOException e) {
            throw new ProtocolException(e);
        }
        finally {
            IoUtil.close(os);
        }
    }

    @Override
    public void queryResult(long id, String to, String from, Serializable payload) {
        OutputStream os = null;
        try {
            os = this._ws.startBinaryMessage();
            this._hOut.queryResult(os, id, to, from, payload);
        }
        catch (IOException e) {
            throw new ProtocolException(e);
        }
        finally {
            IoUtil.close(os);
        }
    }

    @Override
    public void queryError(long id, String to, String from, Serializable payload, BamError error) {
        OutputStream os = null;
        try {
            os = this._ws.startBinaryMessage();
            this._hOut.queryError(os, id, to, from, payload, error);
        }
        catch (IOException e) {
            throw new ProtocolException(e);
        }
        finally {
            IoUtil.close(os);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isClosed() {
        return false;
    }
}

