/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms;

import com.caucho.jms.JmsRuntimeException;
import com.caucho.jms.connection.ConnectionFactoryImpl;
import com.caucho.jms.message.MessageFactory;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;

public class Jms {
    private static final Logger log = Logger.getLogger(Jms.class.getName());
    private static final L10N L = new L10N(Jms.class);
    private ConnectionFactoryImpl _connectionFactory;
    private Connection _conn;
    private MessageFactory _messageFactory = new MessageFactory();

    public Jms() {
        try {
            this._connectionFactory = new ConnectionFactoryImpl();
            this._conn = this._connectionFactory.createConnection();
            this._conn.start();
        }
        catch (JMSException e) {
            throw new JmsRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Destination dest, Message msg) {
        Session session = null;
        try {
            session = this.getSession();
            MessageProducer producer = session.createProducer(null);
            producer.send(dest, msg);
        }
        catch (JMSException jMSException) {
        }
        finally {
            this.freeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Destination dest, Message msg, int deliveryMode, int priority, long ttl) {
        Session session = null;
        try {
            session = this.getSession();
            MessageProducer producer = session.createProducer(null);
            producer.send(dest, msg, deliveryMode, priority, ttl);
        }
        catch (JMSException jMSException) {
        }
        finally {
            this.freeSession(session);
        }
    }

    public Message receive(Destination dest) {
        Session session = null;
        MessageConsumer consumer = null;
        try {
            session = this.getSession();
            consumer = session.createConsumer(dest);
            Message message = consumer.receive();
            return message;
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (consumer != null) {
                    consumer.close();
                }
            }
            catch (JMSException e) {
                log.log(Level.FINE, e.toString(), e);
            }
            this.freeSession(session);
        }
    }

    public Message receive(Destination dest, long timeout) {
        Session session = null;
        MessageConsumer consumer = null;
        try {
            session = this.getSession();
            consumer = session.createConsumer(dest);
            Message message = consumer.receive(timeout);
            return message;
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (consumer != null) {
                    consumer.close();
                }
            }
            catch (JMSException e) {
                log.log(Level.FINE, e.toString(), e);
            }
            this.freeSession(session);
        }
    }

    public Message receiveNoWait(Destination dest) {
        Session session = null;
        MessageConsumer consumer = null;
        try {
            session = this.getSession();
            consumer = session.createConsumer(dest);
            Message message = consumer.receiveNoWait();
            return message;
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (consumer != null) {
                    consumer.close();
                }
            }
            catch (JMSException e) {
                log.log(Level.FINE, e.toString(), e);
            }
            this.freeSession(session);
        }
    }

    public Session createSession() throws JmsRuntimeException {
        try {
            return this._conn.createSession(false, 1);
        }
        catch (JMSException e) {
            throw new JmsRuntimeException(e);
        }
    }

    public Connection createConnection() {
        try {
            return this._connectionFactory.createConnection();
        }
        catch (JMSException e) {
            throw new JmsRuntimeException(e);
        }
    }

    public Session createListener(Connection conn, Destination queue, MessageListener listener) throws JmsRuntimeException {
        try {
            Session session = conn.createSession(false, 1);
            MessageConsumer consumer = session.createConsumer(queue);
            consumer.setMessageListener(listener);
            return session;
        }
        catch (JMSException e) {
            throw new JmsRuntimeException(e);
        }
    }

    private Session getSession() throws JMSException {
        Session session = this._conn.createSession(false, 1);
        return session;
    }

    private void freeSession(Session session) {
        try {
            if (session != null) {
                session.close();
            }
        }
        catch (JMSException e) {
            throw new JmsRuntimeException(e);
        }
    }

    public TextMessage createTextMessage(String msg) {
        try {
            return this._messageFactory.createTextMessage(msg);
        }
        catch (JMSException e) {
            throw new JmsRuntimeException(e);
        }
    }
}

