/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.connection;

import com.caucho.jms.connection.JmsSession;
import com.caucho.jms.connection.MessageConsumerImpl;
import com.caucho.jms.connection.TemporaryTopicImpl;
import com.caucho.jms.queue.AbstractQueue;
import com.caucho.jms.queue.AbstractTopic;
import com.caucho.util.L10N;
import java.util.logging.Logger;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

public class TopicSubscriberImpl
extends MessageConsumerImpl
implements TopicSubscriber {
    private static final Logger log = Logger.getLogger(TopicSubscriberImpl.class.getName());
    private static final L10N L = new L10N(TopicSubscriberImpl.class);
    private AbstractTopic _topic;
    private AbstractQueue _subscription;
    private boolean _isSubscriptionClosed;

    TopicSubscriberImpl(JmsSession session, AbstractTopic topic, String messageSelector, boolean noLocal) throws JMSException {
        super(session, topic.createSubscriber(session.getPublisherId(), messageSelector, noLocal), messageSelector, noLocal);
        this._topic = topic;
        this._subscription = (AbstractQueue)this.getDestination();
    }

    TopicSubscriberImpl(JmsSession session, AbstractTopic topic, AbstractQueue subscription, String messageSelector, boolean noLocal) throws JMSException {
        super(session, subscription, messageSelector, noLocal);
        this._topic = topic;
        this._subscription = subscription;
    }

    @Override
    public String getMessageSelector() throws JMSException {
        if (this.isClosed() || this._isSubscriptionClosed) {
            throw new IllegalStateException(L.l("getMessageSelector(): MessageConsumer is closed."));
        }
        return super.getMessageSelector();
    }

    @Override
    public boolean getNoLocal() throws JMSException {
        if (this.isClosed() || this._isSubscriptionClosed) {
            throw new IllegalStateException(L.l("getNoLocal(): MessageConsumer is closed."));
        }
        return super.getNoLocal();
    }

    public Topic getTopic() throws JMSException {
        if (this.isClosed() || this._isSubscriptionClosed) {
            throw new IllegalStateException(L.l("getTopic(): TopicSubscriber is closed."));
        }
        return this._topic;
    }

    @Override
    protected Message receiveImpl(long timeout) throws JMSException {
        if (this.isClosed() || this._isSubscriptionClosed) {
            throw new IllegalStateException(L.l("receiveNoWait(): TopicSubscriber is closed."));
        }
        return super.receiveImpl(timeout);
    }

    @Override
    public void close() {
        AbstractQueue subscription = this._subscription;
        this._subscription = null;
        if (subscription != null) {
            this._topic.closeSubscriber(subscription);
            subscription.close();
            this._isSubscriptionClosed = Boolean.TRUE;
        }
        if (this._topic instanceof TemporaryTopicImpl) {
            ((TemporaryTopicImpl)this._topic).removeMessageConsumer();
        }
    }
}

