/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.jdbc;

import com.caucho.config.ConfigException;
import com.caucho.config.types.Period;
import com.caucho.jdbc.JdbcMetaData;
import com.caucho.jms.jdbc.JdbcMessage;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;

public class JdbcManager {
    static final Logger log = Log.open(JdbcManager.class);
    static final L10N L = new L10N(JdbcManager.class);
    private DataSource _dataSource;
    private String _messageTable = "resin_jms_message";
    private String _destinationTable = "resin_jms_destination";
    private String _destinationSequence;
    private String _consumerTable = "resin_jms_consumer";
    private String _consumerSequence;
    private String _blob;
    private String _longType;
    private String _tablespace;
    private boolean _isTruncateBlob;
    private long _purgeInterval = 60000L;
    private long _pollInterval = -1L;
    private JdbcMessage _jdbcMessage;
    private volatile boolean _isInit;

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this._dataSource;
    }

    public String getMessageTable() {
        return this._messageTable;
    }

    public void setMessageTable(String tableName) {
        this._messageTable = tableName;
    }

    public String getDestinationTable() {
        return this._destinationTable;
    }

    public void setDestinationTable(String tableName) {
        this._destinationTable = tableName;
    }

    public String getDestinationSequence() {
        return this._destinationSequence;
    }

    public String getConsumerTable() {
        return this._consumerTable;
    }

    public void setConsumerTable(String tableName) {
        this._consumerTable = tableName;
    }

    public String getConsumerSequence() {
        return this._consumerSequence;
    }

    public JdbcMetaData getMetaData() {
        return JdbcMetaData.create(this._dataSource);
    }

    public String getBlob() {
        if (this._blob == null) {
            this._blob = this.getMetaData().getBlobType();
        }
        return this._blob;
    }

    public void setTablespace(String tablespace) {
        this._tablespace = tablespace;
    }

    public String getTablespace() {
        return this._tablespace;
    }

    public String getLongType() {
        if (this._longType == null) {
            this._longType = this.getMetaData().getLongType();
        }
        return this._longType;
    }

    public void setPurgeInterval(Period period) {
        this._purgeInterval = period.getPeriod();
    }

    public long getPurgeInterval() {
        return this._purgeInterval;
    }

    public void setPollInterval(Period pollInterval) {
        this._pollInterval = pollInterval.getPeriod();
    }

    public long getPollInterval() {
        return this._pollInterval;
    }

    public JdbcMessage getJdbcMessage() {
        return this._jdbcMessage;
    }

    public boolean isTruncateBlob() {
        return this._isTruncateBlob;
    }

    @PostConstruct
    public void init() throws ConfigException, SQLException {
        if (this._isInit) {
            return;
        }
        this._isInit = true;
        if (this._dataSource == null) {
            throw new ConfigException(L.l("JdbcManager requires a <data-source> element."));
        }
        this._jdbcMessage = new JdbcMessage(this);
        this._jdbcMessage.init();
        this.initDestinationTable();
        this.initConsumerTable();
        this._isTruncateBlob = this.getMetaData().isTruncateBlobBeforeDelete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDestinationTable() throws SQLException {
        Connection conn = this._dataSource.getConnection();
        if (!this.getMetaData().supportsIdentity()) {
            if (!this.getMetaData().supportsSequences()) {
                throw new ConfigException(L.l("JdbcManager requires a datasource that supports either identity or sequences"));
            }
            this._destinationSequence = this._destinationTable + "_cseq";
        }
        try {
            Statement stmt = conn.createStatement();
            String sql = "SELECT 1 FROM " + this._destinationTable + " WHERE 1=0";
            try {
                ResultSet rs = stmt.executeQuery(sql);
                rs.next();
                rs.close();
                stmt.close();
                return;
            }
            catch (SQLException e) {
                block9: {
                    log.finest(e.toString());
                    log.info(L.l("creating JMS destination table {0}", (Object)this._destinationTable));
                    String longType = this.getLongType();
                    String identity = longType + " PRIMARY KEY";
                    if (this.getMetaData().supportsIdentity()) {
                        identity = this.getMetaData().createIdentitySQL(identity);
                    }
                    sql = "CREATE TABLE " + this._destinationTable + " (  id " + identity + ",  name VARCHAR(255),  is_topic INTEGER)";
                    stmt.executeUpdate(sql);
                    if (this.getMetaData().supportsIdentity()) break block9;
                    this._destinationSequence = this._destinationTable + "_cseq";
                    stmt.executeUpdate(this.getMetaData().createSequenceSQL(this._destinationSequence, 1));
                }
                conn.close();
            }
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initConsumerTable() throws SQLException {
        if (!this.getMetaData().supportsIdentity()) {
            this._consumerSequence = this._consumerTable + "_cseq";
        }
        Connection conn = this._dataSource.getConnection();
        try {
            Statement stmt = conn.createStatement();
            String sql = "SELECT 1 FROM " + this._consumerTable + " WHERE 1=0";
            try {
                ResultSet rs = stmt.executeQuery(sql);
                rs.next();
                rs.close();
                stmt.close();
                return;
            }
            catch (SQLException e) {
                block8: {
                    log.finest(e.toString());
                    log.info(L.l("creating JMS consumer table {0}", (Object)this._consumerTable));
                    String longType = this.getLongType();
                    String identity = longType + " PRIMARY KEY";
                    if (this.getMetaData().supportsIdentity()) {
                        identity = this.getMetaData().createIdentitySQL(identity);
                    }
                    sql = "CREATE TABLE " + this._consumerTable + " (  s_id " + identity + ",  queue " + longType + ",  client VARCHAR(255),  name VARCHAR(255),  expire " + longType + ",  read_id " + longType + ",  ack_id " + longType + ")";
                    stmt.executeUpdate(sql);
                    if (this._consumerSequence == null) break block8;
                    stmt.executeUpdate(this.getMetaData().createSequenceSQL(this._consumerSequence, 1));
                }
                conn.close();
            }
        }
        finally {
            conn.close();
        }
    }

    public int hashCode() {
        if (this._dataSource == null) {
            return 0;
        }
        return this._dataSource.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JdbcManager)) {
            return false;
        }
        JdbcManager manager = (JdbcManager)o;
        return this._dataSource != null && this._dataSource.equals(manager._dataSource);
    }
}

