/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.selector;

import com.caucho.jms.selector.Selector;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;

public class BetweenSelector
extends Selector {
    private Selector _left;
    private Selector _low;
    private Selector _high;

    BetweenSelector(Selector left, Selector low, Selector high) throws JMSException {
        this._left = left;
        this._low = low;
        this._high = high;
        if (!this._left.isUnknown() && !this._left.isNumber()) {
            throw new InvalidSelectorException(L.l("'{0}' must have a numeric value for comparison.", (Object)this));
        }
        if (!this._low.isUnknown() && !this._low.isNumber()) {
            throw new InvalidSelectorException(L.l("'{0}' must have a numeric value for comparison.", (Object)this));
        }
        if (!this._high.isUnknown() && !this._high.isNumber()) {
            throw new InvalidSelectorException(L.l("'{0}' must have a numeric value for comparison.", (Object)this));
        }
    }

    @Override
    Object evaluate(Message message) throws JMSException {
        Object lobj = this._left.evaluate(message);
        if (!(lobj instanceof Number)) {
            return NULL;
        }
        Object lowObj = this._low.evaluate(message);
        Object highObj = this._high.evaluate(message);
        if (!(lowObj instanceof Number) || !(highObj instanceof Number)) {
            return NULL;
        }
        if (BetweenSelector.isInteger(lobj) && BetweenSelector.isInteger(lowObj) && BetweenSelector.isInteger(highObj)) {
            long lvalue = this.toLong(lobj);
            long low = this.toLong(lowObj);
            long high = this.toLong(highObj);
            return BetweenSelector.toBoolean(low <= lvalue && lvalue <= high);
        }
        double lvalue = this.toDouble(lobj);
        double low = this.toDouble(lowObj);
        double high = this.toDouble(highObj);
        return BetweenSelector.toBoolean(low <= lvalue && lvalue <= high);
    }
}

