/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.services;

import com.caucho.jms.util.BytesMessageOutputStream;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JMSServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(JMSServlet.class.getName());
    private Connection _jmsConnection;
    private ConnectionFactory _connectionFactory;
    private Destination _destination;
    private MessageProducer _producer;
    private Session _jmsSession;

    public void setDestination(Destination destination) {
        this._destination = destination;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this._connectionFactory = connectionFactory;
    }

    public void init() {
        try {
            this._jmsConnection = this._connectionFactory.createConnection();
            this._jmsSession = this._jmsConnection.createSession(false, 1);
            this._producer = this._jmsSession.createProducer(this._destination);
        }
        catch (Exception e) {
            log.fine(e.toString());
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletInputStream is = request.getInputStream();
        try {
            BytesMessage message = this._jmsSession.createBytesMessage();
            BytesMessageOutputStream out = new BytesMessageOutputStream(message);
            WriteStream ws = VfsStream.openWrite(out);
            ws.writeStream((InputStream)is);
            ws.flush();
            out.flush();
            this._producer.send((Message)message);
        }
        catch (JMSException e) {
            throw new ServletException((Throwable)e);
        }
    }
}

