/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp.java;

import com.caucho.java.JavaWriter;
import com.caucho.jsp.java.JavaJspGenerator;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;

public class JspJavaWriter
extends JavaWriter {
    private JavaJspGenerator _gen;
    private String _filename;
    private int _line = -1;
    private CharBuffer _cb = CharBuffer.allocate();

    public JspJavaWriter(WriteStream os, JavaJspGenerator gen) {
        super(os);
        this._gen = gen;
    }

    public void addText(String text) throws IOException {
        if (this._filename != null && this._cb.length() == 0) {
            super.setLocation(this._filename, this._line);
        }
        this._cb.append(text);
    }

    @Override
    public void setLocation(String filename, int line) throws IOException {
        this._filename = filename;
        this._line = line;
    }

    protected void flushText() throws IOException {
        String filename = this._filename;
        int line = this._line;
        this._filename = null;
        if (this._cb.length() > 0) {
            int length = this._cb.length();
            this._cb.clear();
            this.generateText(this._cb.getBuffer(), 0, length);
        }
        if (filename != null) {
            super.setLocation(filename, line);
        }
    }

    private void generateText(char[] text, int offset, int length) throws IOException {
        if (length > 8192) {
            this.generateText(text, offset, 8192);
            this.generateText(text, offset + 8192, length - 8192);
            return;
        }
        if (length == 1) {
            char ch = text[offset];
            this.print("out.write('");
            switch (ch) {
                case '\\': {
                    this.print("\\\\");
                    break;
                }
                case '\'': {
                    this.print("\\'");
                    break;
                }
                case '\n': {
                    this.print("\\n");
                    break;
                }
                case '\r': {
                    this.print("\\r");
                    break;
                }
                default: {
                    this.print(ch);
                }
            }
            this.println("');");
        } else {
            int index = this._gen.addString(new String(text, offset, length));
            this.print("out.write(_jsp_string" + index + ", 0, ");
            this.println("_jsp_string" + index + ".length);");
        }
    }

    @Override
    public void printJavaString(String s) throws IOException {
        this.flushText();
        super.printJavaString(s);
    }

    @Override
    public void pushDepth() throws IOException {
        this.flushText();
        super.pushDepth();
    }

    @Override
    public void popDepth() throws IOException {
        this.flushText();
        super.popDepth();
    }

    @Override
    public void print(String s) throws IOException {
        this.flushText();
        super.print(s);
    }

    @Override
    public void print(char ch) throws IOException {
        this.flushText();
        super.print(ch);
    }

    @Override
    public void print(boolean b) throws IOException {
        this.flushText();
        super.print(b);
    }

    @Override
    public void print(int i) throws IOException {
        this.flushText();
        super.print(i);
    }

    @Override
    public void print(long l) throws IOException {
        this.flushText();
        super.print(l);
    }

    @Override
    public void print(Object o) throws IOException {
        this.flushText();
        super.print(o);
    }

    @Override
    public void println(String s) throws IOException {
        this.flushText();
        super.println(s);
    }

    @Override
    public void println(boolean v) throws IOException {
        this.flushText();
        super.println(v);
    }

    @Override
    public void println(char ch) throws IOException {
        this.flushText();
        super.println(ch);
    }

    @Override
    public void println(int v) throws IOException {
        this.flushText();
        super.println(v);
    }

    @Override
    public void println(long v) throws IOException {
        this.flushText();
        super.println(v);
    }

    @Override
    public void println(Object v) throws IOException {
        this.flushText();
        super.println(v);
    }

    @Override
    public void println() throws IOException {
        this.flushText();
        super.println();
    }
}

