/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.util.L10N;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WeakDestroyListener
implements EnvironmentListener {
    private static final L10N L = new L10N(WeakDestroyListener.class);
    private static final Logger log = Logger.getLogger(WeakDestroyListener.class.getName());
    private Method _preDestroy;
    private WeakReference<Object> _objRef;

    public WeakDestroyListener(Method preDestroy, Object obj) {
        this._preDestroy = preDestroy;
        this._objRef = new WeakReference<Object>(obj);
    }

    @Override
    public void environmentConfigure(EnvironmentClassLoader loader) {
    }

    @Override
    public void environmentBind(EnvironmentClassLoader loader) {
    }

    @Override
    public void environmentStart(EnvironmentClassLoader loader) {
    }

    @Override
    public void environmentStop(EnvironmentClassLoader loader) {
        Object obj = this._objRef.get();
        if (obj == null) {
            return;
        }
        try {
            this._preDestroy.invoke(obj, (Object[])null);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }
}

