/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.network.listen;

import com.caucho.inject.Module;
import java.util.concurrent.atomic.AtomicReference;

@Module
enum SocketLinkRequestState {
    INIT{

        @Override
        public boolean isAllowIdle() {
            return true;
        }

        @Override
        boolean toAccept(AtomicReference<SocketLinkRequestState> stateRef) {
            if (stateRef.compareAndSet(INIT, REQUEST)) {
                return true;
            }
            return stateRef.get().toAccept(stateRef);
        }
    }
    ,
    REQUEST{

        @Override
        public boolean isAllowIdle() {
            return true;
        }

        @Override
        boolean toIdle(AtomicReference<SocketLinkRequestState> stateRef) {
            if (stateRef.compareAndSet(REQUEST, INIT)) {
                return true;
            }
            return stateRef.get().toIdle(stateRef);
        }

        @Override
        boolean toStartKeepalive(AtomicReference<SocketLinkRequestState> stateRef) {
            if (stateRef.compareAndSet(REQUEST, KEEPALIVE_START)) {
                return true;
            }
            return stateRef.get().toStartKeepalive(stateRef);
        }

        @Override
        boolean toAsyncStart(AtomicReference<SocketLinkRequestState> stateRef) {
            if (stateRef.compareAndSet(REQUEST, ASYNC_START)) {
                return true;
            }
            return stateRef.get().toAsyncStart(stateRef);
        }
    }
    ,
    KEEPALIVE_START{

        @Override
        boolean toWakeKeepalive(AtomicReference<SocketLinkRequestState> stateRef) {
            if (stateRef.compareAndSet(KEEPALIVE_START, KEEPALIVE_WAKE)) {
                return false;
            }
            return stateRef.get().toWakeKeepalive(stateRef);
        }

        @Override
        boolean toSuspendKeepalive(AtomicReference<SocketLinkRequestState> stateRef) {
            if (stateRef.compareAndSet(KEEPALIVE_START, KEEPALIVE_SUSPEND)) {
                return true;
            }
            return stateRef.get().toSuspendKeepalive(stateRef);
        }

        @Override
        boolean toDestroy(AtomicReference<SocketLinkRequestState> stateRef) {
            if (stateRef.compareAndSet(this, DESTROY)) {
                return true;
            }
            return stateRef.get().toDestroy(stateRef);
        }
    }
    ,
    KEEPALIVE_WAKE{

        @Override
        boolean toSuspendKeepalive(AtomicReference<SocketLinkRequestState> stateRef) {
            if (stateRef.compareAndSet(KEEPALIVE_WAKE, REQUEST)) {
                return false;
            }
            return stateRef.get().toSuspendKeepalive(stateRef);
        }

        @Override
        boolean toDestroy(AtomicReference<SocketLinkRequestState> stateRef) {
            if (stateRef.compareAndSet(this, DESTROY)) {
                return true;
            }
            return stateRef.get().toDestroy(stateRef);
        }
    }
    ,
    KEEPALIVE_SUSPEND{

        @Override
        boolean toWakeKeepalive(AtomicReference<SocketLinkRequestState> stateRef) {
            if (stateRef.compareAndSet(KEEPALIVE_SUSPEND, REQUEST)) {
                return true;
            }
            return stateRef.get().toWakeKeepalive(stateRef);
        }

        @Override
        boolean toDestroy(AtomicReference<SocketLinkRequestState> stateRef) {
            if (stateRef.compareAndSet(this, DESTROY)) {
                return true;
            }
            return stateRef.get().toDestroy(stateRef);
        }
    }
    ,
    ASYNC_START{

        @Override
        public boolean isAsyncStarted() {
            return true;
        }

        @Override
        boolean toAsyncSuspendThread(AtomicReference<SocketLinkRequestState> stateRef) {
            if (stateRef.compareAndSet(ASYNC_START, SUSPEND)) {
                return true;
            }
            return stateRef.get().toAsyncSuspendThread(stateRef);
        }

        @Override
        boolean toAsyncSuspendRequest(AtomicReference<SocketLinkRequestState> stateRef) {
            return true;
        }

        @Override
        boolean toAsyncWake(AtomicReference<SocketLinkRequestState> stateRef) {
            if (stateRef.compareAndSet(ASYNC_START, ASYNC_WAKE)) {
                return false;
            }
            return stateRef.get().toAsyncWake(stateRef);
        }
    }
    ,
    ASYNC_WAKE{

        @Override
        public boolean isAsyncWake() {
            return true;
        }

        @Override
        boolean toAsyncSuspendThread(AtomicReference<SocketLinkRequestState> stateRef) {
            if (stateRef.compareAndSet(ASYNC_WAKE, REQUEST)) {
                return false;
            }
            return stateRef.get().toAsyncSuspendThread(stateRef);
        }

        @Override
        boolean toAsyncSuspendRequest(AtomicReference<SocketLinkRequestState> stateRef) {
            if (stateRef.compareAndSet(ASYNC_WAKE, REQUEST)) {
                return false;
            }
            return stateRef.get().toAsyncSuspendRequest(stateRef);
        }
    }
    ,
    SUSPEND{

        @Override
        public boolean isAsyncStarted() {
            return true;
        }

        @Override
        boolean toAsyncWake(AtomicReference<SocketLinkRequestState> stateRef) {
            if (stateRef.compareAndSet(SUSPEND, REQUEST)) {
                return true;
            }
            return stateRef.get().toAsyncWake(stateRef);
        }

        @Override
        boolean toDestroy(AtomicReference<SocketLinkRequestState> stateRef) {
            if (stateRef.compareAndSet(this, DESTROY)) {
                return true;
            }
            return stateRef.get().toDestroy(stateRef);
        }
    }
    ,
    DESTROY{

        @Override
        public boolean isDestroyed() {
            return true;
        }

        @Override
        boolean toDestroy(AtomicReference<SocketLinkRequestState> stateRef) {
            return false;
        }
    };


    public boolean isAllowIdle() {
        return false;
    }

    public boolean isAsyncWake() {
        return false;
    }

    boolean toAccept(AtomicReference<SocketLinkRequestState> stateRef) {
        throw new IllegalStateException(this.toString());
    }

    boolean toStartKeepalive(AtomicReference<SocketLinkRequestState> stateRef) {
        throw new IllegalStateException(this.toString());
    }

    boolean toSuspendKeepalive(AtomicReference<SocketLinkRequestState> stateRef) {
        throw new IllegalStateException(this.toString());
    }

    boolean toWakeKeepalive(AtomicReference<SocketLinkRequestState> stateRef) {
        throw new IllegalStateException(this.toString());
    }

    boolean toAsyncStart(AtomicReference<SocketLinkRequestState> stateRef) {
        throw new IllegalStateException(this.toString());
    }

    boolean toAsyncSuspendThread(AtomicReference<SocketLinkRequestState> stateRef) {
        throw new IllegalStateException(this.toString());
    }

    boolean toAsyncSuspendRequest(AtomicReference<SocketLinkRequestState> stateRef) {
        throw new IllegalStateException(this.toString());
    }

    boolean toAsyncWake(AtomicReference<SocketLinkRequestState> stateRef) {
        throw new IllegalStateException("async dispatch is not valid outside of an async cycle.  Current state: " + this.toString());
    }

    boolean toIdle(AtomicReference<SocketLinkRequestState> stateRef) {
        throw new IllegalStateException(this.toString());
    }

    boolean toDestroy(AtomicReference<SocketLinkRequestState> stateRef) {
        if (stateRef.compareAndSet(this, DESTROY)) {
            return false;
        }
        return stateRef.get().toDestroy(stateRef);
    }

    public boolean isDestroyed() {
        return false;
    }

    public boolean isAsyncStarted() {
        return false;
    }
}

