/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.network.listen;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.types.Period;
import com.caucho.env.meter.ActiveMeter;
import com.caucho.env.meter.CountMeter;
import com.caucho.env.meter.MeterService;
import com.caucho.env.thread.ThreadPool;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.management.server.PortMXBean;
import com.caucho.management.server.TcpConnectionInfo;
import com.caucho.network.listen.AbstractSelectManager;
import com.caucho.network.listen.Protocol;
import com.caucho.network.listen.SocketLinkState;
import com.caucho.network.listen.SocketLinkThreadLauncher;
import com.caucho.network.listen.SocketPollService;
import com.caucho.network.listen.TcpPortAdmin;
import com.caucho.network.listen.TcpSocketLink;
import com.caucho.network.listen.Throttle;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.CurrentTime;
import com.caucho.util.FreeRingDual;
import com.caucho.util.Friend;
import com.caucho.util.L10N;
import com.caucho.vfs.JsseSSLFactory;
import com.caucho.vfs.QJniServerSocket;
import com.caucho.vfs.QServerSocket;
import com.caucho.vfs.QSocket;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.SSLFactory;
import com.caucho.vfs.net.NetworkSystem;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

@Configurable
public class TcpPort {
    private static final L10N L = new L10N(TcpPort.class);
    private static final Logger log = Logger.getLogger(TcpPort.class.getName());
    private static final int ACCEPT_IDLE_MIN = 4;
    private static final int ACCEPT_IDLE_MAX = 64;
    private static final int ACCEPT_THROTTLE_LIMIT = 1024;
    private static final long ACCEPT_THROTTLE_SLEEP_TIME = 0L;
    private static final int KEEPALIVE_MAX = 65536;
    private static final CountMeter _throttleDisconnectMeter = MeterService.createCountMeter("Resin|Port|Throttle Disconnect Count");
    private static final CountMeter _keepaliveMeter = MeterService.createCountMeter("Resin|Port|Keepalive Count");
    private static final ActiveMeter _keepaliveThreadMeter = MeterService.createActiveMeter("Resin|Port|Keepalive Thread");
    private static final ActiveMeter _suspendMeter = MeterService.createActiveMeter("Resin|Port|Request Suspend");
    private final AtomicInteger _connectionCount = new AtomicInteger();
    private FreeRingDual<TcpSocketLink> _idleConn = new FreeRingDual(256, 2048);
    private ThreadPool _threadPool = ThreadPool.getThreadPool();
    private SocketLinkThreadLauncher _launcher;
    private ClassLoader _classLoader = Thread.currentThread().getContextClassLoader();
    private String _serverId = "";
    private String _address;
    private int _port = -1;
    private String _url;
    private Protocol _protocol;
    private SSLFactory _sslFactory;
    private boolean _isSecure;
    private InetAddress _socketAddress;
    private int _acceptListenBacklog = 4000;
    private int _connectionMax = 0x100000;
    private int _keepaliveMax = -1;
    private long _keepaliveTimeMax = 600000L;
    private long _keepaliveTimeout = 120000L;
    private boolean _isKeepaliveAsyncEnable = true;
    private long _keepaliveSelectThreadTimeout = 1000L;
    private long _socketTimeout = 120000L;
    private long _suspendReaperTimeout = 60000L;
    private long _suspendTimeMax = 600000L;
    private long _suspendCloseTimeMax = 120000L;
    private long _requestTimeout = -1L;
    private boolean _isTcpNoDelay = true;
    private boolean _isTcpKeepalive;
    private boolean _isTcpCork;
    private boolean _isEnableJni = true;
    private String _virtualHost;
    private final TcpPortAdmin _admin = new TcpPortAdmin(this);
    private QServerSocket _serverSocket;
    private Throttle _throttle;
    private AbstractSelectManager _selectManager;
    private ConcurrentHashMap<TcpSocketLink, TcpSocketLink> _activeConnectionSet = new ConcurrentHashMap();
    private final AtomicInteger _activeConnectionCount = new AtomicInteger();
    private Set<TcpSocketLink> _suspendConnectionSet = Collections.synchronizedSet(new HashSet());
    private final AtomicInteger _shutdownRequestCount = new AtomicInteger();
    private Alarm _suspendAlarm;
    private final AtomicLong _lifetimeRequestCount = new AtomicLong();
    private final AtomicLong _lifetimeKeepaliveCount = new AtomicLong();
    private final AtomicLong _lifetimeKeepaliveSelectCount = new AtomicLong();
    private final AtomicLong _lifetimeClientDisconnectCount = new AtomicLong();
    private final AtomicLong _lifetimeRequestTime = new AtomicLong();
    private final AtomicLong _lifetimeReadBytes = new AtomicLong();
    private final AtomicLong _lifetimeWriteBytes = new AtomicLong();
    private final AtomicLong _lifetimeThrottleDisconnectCount = new AtomicLong();
    private AtomicInteger _keepaliveAllocateCount = new AtomicInteger();
    private AtomicInteger _keepaliveThreadCount = new AtomicInteger();
    private final AtomicBoolean _isBind = new AtomicBoolean();
    private final AtomicBoolean _isPostBind = new AtomicBoolean();
    private final Lifecycle _lifecycle = new Lifecycle();

    public TcpPort() {
        if (CauchoSystem.is64Bit()) {
            this._keepaliveSelectThreadTimeout = 60000L;
        }
        this._launcher = new SocketLinkThreadLauncher(this);
        if (CurrentTime.isTest()) {
            this._launcher.setIdleMin(2);
            this._launcher.setIdleMax(64);
        } else {
            this._launcher.setIdleMin(4);
            this._launcher.setIdleMax(64);
        }
        this._launcher.setThrottleLimit(1024);
        this._launcher.setThrottleSleepTime(0L);
    }

    @Deprecated
    public void setId(String id) {
    }

    public String getDebugId() {
        return this.getUrl();
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public PortMXBean getAdmin() {
        return this._admin;
    }

    public void setProtocol(Protocol protocol) throws ConfigException {
        this._protocol = protocol;
    }

    public Protocol getProtocol() {
        return this._protocol;
    }

    public String getProtocolName() {
        if (this._protocol != null) {
            return this._protocol.getProtocolName();
        }
        return null;
    }

    @Configurable
    public void setAddress(String address) throws UnknownHostException {
        if ("*".equals(address)) {
            address = null;
        }
        this._address = address;
        if (address != null) {
            this._socketAddress = InetAddress.getByName(address);
        }
    }

    public String getAddress() {
        return this._address;
    }

    public void setHost(String address) throws UnknownHostException {
        this.setAddress(address);
    }

    @Configurable
    public void setPort(int port) {
        this._port = port;
    }

    public int getPort() {
        return this._port;
    }

    public int getLocalPort() {
        if (this._serverSocket != null) {
            return this._serverSocket.getLocalPort();
        }
        return this._port;
    }

    @Configurable
    public void setVirtualHost(String host) {
        this._virtualHost = host;
    }

    public String getVirtualHost() {
        return this._virtualHost;
    }

    public void setSSL(SSLFactory factory) {
        this._sslFactory = factory;
    }

    @Configurable
    public SSLFactory createOpenssl() throws ConfigException {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cl = Class.forName("com.caucho.vfs.OpenSSLFactory", false, loader);
            this._sslFactory = (SSLFactory)cl.newInstance();
            return this._sslFactory;
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.log(Level.FINER, e.toString(), e);
            throw new ConfigException(L.l("<openssl> requires Resin Professional. See http://www.caucho.com for more information."), e);
        }
    }

    public JsseSSLFactory createJsse() {
        return new JsseSSLFactory();
    }

    public void setJsseSsl(JsseSSLFactory factory) {
        this._sslFactory = factory;
    }

    public SSLFactory getSSL() {
        return this._sslFactory;
    }

    public boolean isSSL() {
        return this._sslFactory != null;
    }

    @Configurable
    public void setSecure(boolean isSecure) {
        this._isSecure = isSecure;
    }

    public boolean isSecure() {
        return this._isSecure || this._sslFactory != null;
    }

    public void setServerSocket(QServerSocket socket) {
        this._serverSocket = socket;
    }

    @Configurable
    public void setAcceptThreadMin(int minSpare) throws ConfigException {
        if (minSpare < 1) {
            return;
        }
        this._launcher.setIdleMin(minSpare);
    }

    public int getAcceptThreadMin() {
        return this._launcher.getIdleMin();
    }

    @Configurable
    public void setAcceptThreadMax(int maxSpare) throws ConfigException {
        if (maxSpare < 1) {
            return;
        }
        this._launcher.setIdleMax(maxSpare);
    }

    public int getAcceptThreadMax() {
        return this._launcher.getIdleMax();
    }

    @Configurable
    public void setPortThreadMax(int max) {
        int threadMax = ThreadPool.getThreadPool().getThreadMax();
        if (threadMax < max) {
            log.warning(L.l("<port-thread-max> value '{0}' should be less than <thread-max> value '{1}'", max, threadMax));
        }
        this._launcher.setThreadMax(max);
    }

    public int getPortThreadMax() {
        return this._launcher.getThreadMax();
    }

    @Configurable
    public void setAcceptThreadIdleTimeout(Period timeout) throws ConfigException {
        this._launcher.setIdleTimeout(timeout.getPeriod());
    }

    public long getAcceptThreadIdleTimeout() throws ConfigException {
        return this._launcher.getIdleTimeout();
    }

    public void setThrottlePeriod(long period) {
        this._launcher.setThrottlePeriod(period);
    }

    public void setThrottleLimit(int limit) {
        this._launcher.setThrottleLimit(limit);
    }

    public void setThrottleSleepTime(long period) {
        this._launcher.setThrottleSleepTime(period);
    }

    @Configurable
    public void setAcceptListenBacklog(int listen) throws ConfigException {
        if (listen < 1) {
            throw new ConfigException(L.l("accept-listen-backlog must be at least 1."));
        }
        this._acceptListenBacklog = listen;
    }

    public int getAcceptListenBacklog() {
        return this._acceptListenBacklog;
    }

    @Configurable
    public void setConnectionMax(int max) {
        this._connectionMax = max;
    }

    public int getConnectionMax() {
        return this._connectionMax;
    }

    @Configurable
    public void setSocketTimeout(Period period) {
        this._socketTimeout = period.getPeriod();
    }

    public void setSocketTimeoutMillis(long timeout) {
        this._socketTimeout = timeout;
    }

    public long getSocketTimeout() {
        return this._socketTimeout;
    }

    public void setRequestTimeout(Period period) {
        this._requestTimeout = period.getPeriod();
    }

    public long getRequestTimeout() {
        return this._requestTimeout;
    }

    public boolean isTcpNoDelay() {
        return this._isTcpNoDelay;
    }

    @Configurable
    public void setTcpNoDelay(boolean tcpNoDelay) {
        this._isTcpNoDelay = tcpNoDelay;
    }

    @Configurable
    public void setTcpKeepalive(boolean tcpKeepalive) {
        this._isTcpKeepalive = tcpKeepalive;
    }

    public boolean isTcpKeepalive() {
        return this._isTcpKeepalive;
    }

    public boolean isTcpCork() {
        return this._isTcpNoDelay;
    }

    @Configurable
    public void setTcpCork(boolean tcpCork) {
        this._isTcpCork = tcpCork;
    }

    @Configurable
    public void setThrottleConcurrentMax(int max) {
        Throttle throttle = this.createThrottle();
        if (throttle != null) {
            throttle.setMaxConcurrentRequests(max);
        }
    }

    public long getThrottleConcurrentMax() {
        if (this._throttle != null) {
            return this._throttle.getMaxConcurrentRequests();
        }
        return -1L;
    }

    public void setEnableJni(boolean isEnableJni) {
        this._isEnableJni = isEnableJni;
    }

    public boolean isJniEnabled() {
        if (this._serverSocket != null) {
            return this._serverSocket.isJni();
        }
        return false;
    }

    private Throttle createThrottle() {
        if (this._throttle == null) {
            this._throttle = Throttle.createPro();
            if (this._throttle == null && ServletService.getCurrent() != null && !ServletService.getCurrent().isWatchdog()) {
                throw new ConfigException(L.l("throttle configuration requires Resin Professional"));
            }
        }
        return this._throttle;
    }

    public void setKeepaliveMax(int max) {
        this._keepaliveMax = max;
    }

    public int getKeepaliveMax() {
        return this._keepaliveMax;
    }

    public void setKeepaliveConnectionTimeMax(Period period) {
        this._keepaliveTimeMax = period.getPeriod();
    }

    public long getKeepaliveConnectionTimeMax() {
        return this._keepaliveTimeMax;
    }

    public void setKeepaliveConnectionTimeMaxMillis(long timeout) {
        this._keepaliveTimeMax = timeout;
    }

    public long getSuspendTimeMax() {
        return this._suspendTimeMax;
    }

    public void setSuspendTimeMax(Period period) {
        this._suspendTimeMax = period.getPeriod();
    }

    public void setSuspendReaperTimeout(Period period) {
        this._suspendReaperTimeout = period.getPeriod();
    }

    public void setKeepaliveTimeout(Period period) {
        this.setKeepaliveTimeoutMillis(period.getPeriod());
    }

    public long getKeepaliveTimeout() {
        return this._keepaliveTimeout;
    }

    public void setKeepaliveTimeoutMillis(long timeout) {
        this._keepaliveTimeout = timeout;
    }

    public boolean isKeepaliveAsyncEnabled() {
        return this._isKeepaliveAsyncEnable;
    }

    public void setKeepaliveSelectEnabled(boolean isKeepaliveSelect) {
        this._isKeepaliveAsyncEnable = isKeepaliveSelect;
    }

    public void setKeepaliveSelectEnable(boolean isKeepaliveSelect) {
        this.setKeepaliveSelectEnabled(isKeepaliveSelect);
    }

    public void setKeepaliveSelectMax(int max) {
    }

    public long getKeepaliveSelectThreadTimeout() {
        return this._keepaliveSelectThreadTimeout;
    }

    public long getKeepaliveThreadTimeout() {
        return this._keepaliveSelectThreadTimeout;
    }

    public void setKeepaliveSelectThreadTimeout(Period period) {
        this.setKeepaliveSelectThreadTimeoutMillis(period.getPeriod());
    }

    public void setKeepaliveThreadTimeout(Period period) {
        this.setKeepaliveSelectThreadTimeoutMillis(period.getPeriod());
    }

    public void setKeepaliveSelectThreadTimeoutMillis(long timeout) {
        this._keepaliveSelectThreadTimeout = timeout;
    }

    public long getBlockingTimeoutForSelect() {
        long timeout = this._keepaliveSelectThreadTimeout;
        if (timeout <= 10L) {
            return timeout;
        }
        if (this._threadPool.getFreeThreadCount() < 64) {
            return 10L;
        }
        return timeout;
    }

    public int getKeepaliveSelectMax() {
        if (this.getSelectManager() != null) {
            return this.getSelectManager().getSelectMax();
        }
        return -1;
    }

    @Configurable
    public void addContentProgram(ConfigProgram program) {
    }

    SocketLinkThreadLauncher getLauncher() {
        return this._launcher;
    }

    ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public int getThreadCount() {
        return this._launcher.getThreadCount();
    }

    public int getActiveThreadCount() {
        return this._launcher.getThreadCount() - this._launcher.getIdleCount();
    }

    public int getIdleThreadCount() {
        return this._launcher.getIdleCount();
    }

    public int getStartThreadCount() {
        return this._launcher.getStartingCount();
    }

    public int getKeepaliveCount() {
        return this._keepaliveAllocateCount.get();
    }

    public Lifecycle getLifecycleState() {
        return this._lifecycle;
    }

    public boolean isAfterBind() {
        return this._isBind.get();
    }

    public boolean isActive() {
        return this._lifecycle.isActive();
    }

    public int getActiveConnectionCount() {
        return this.getActiveThreadCount();
    }

    public int getKeepaliveConnectionCount() {
        return this.getKeepaliveCount();
    }

    public int getKeepaliveThreadCount() {
        return this._keepaliveThreadCount.get();
    }

    public int getSelectConnectionCount() {
        if (this._selectManager != null) {
            return this._selectManager.getSelectCount();
        }
        return -1;
    }

    public String getServerSocketClassName() {
        QServerSocket ss = this._serverSocket;
        if (ss != null) {
            return ss.getClass().getName();
        }
        return null;
    }

    @PostConstruct
    public void init() throws ConfigException {
        if (!this._lifecycle.toInit()) {
            return;
        }
        this._launcher.init();
    }

    public String getUrl() {
        if (this._url == null) {
            StringBuilder url = new StringBuilder();
            if (this._protocol != null) {
                url.append(this._protocol.getProtocolName());
            } else {
                url.append("unknown");
            }
            url.append("://");
            if (this.getAddress() != null) {
                url.append(this.getAddress());
            } else {
                url.append("*");
            }
            url.append(":");
            url.append(this.getPort());
            if (this._serverId != null && !"".equals(this._serverId)) {
                url.append("(");
                url.append(this._serverId);
                url.append(")");
            }
            this._url = url.toString();
        }
        return this._url;
    }

    public void bind() throws Exception {
        boolean isEnableJni;
        if (this._isBind.getAndSet(true)) {
            return;
        }
        if (this._protocol == null) {
            throw new IllegalStateException(L.l("'{0}' must have a configured protocol before starting.", (Object)this));
        }
        if (this._port < 0) {
            return;
        }
        NetworkSystem system = NetworkSystem.getCurrent();
        if (this._throttle == null) {
            this._throttle = new Throttle();
        }
        boolean bl = isEnableJni = this._isEnableJni && !CauchoSystem.isWindows();
        if (this._serverSocket != null) {
            if (this._address != null) {
                log.info("listening to " + this._address + ":" + this._serverSocket.getLocalPort());
            } else {
                log.info("listening to " + this._serverSocket.getLocalPort());
            }
        } else if (this._sslFactory != null && this._socketAddress != null) {
            this._serverSocket = this._sslFactory.create(this._socketAddress, this._port);
            log.info(this._protocol.getProtocolName() + "s listening to " + this._socketAddress.getHostName() + ":" + this._port);
        } else if (this._sslFactory != null) {
            if (this._address == null) {
                this._serverSocket = this._sslFactory.create(null, this._port);
                log.info(this._protocol.getProtocolName() + "s listening to *:" + this._port);
            } else {
                InetAddress addr = InetAddress.getByName(this._address);
                this._serverSocket = this._sslFactory.create(addr, this._port);
                log.info(this._protocol.getProtocolName() + "s listening to " + this._address + ":" + this._port);
            }
        } else if (this._socketAddress != null) {
            this._serverSocket = system.openServerSocket(this._socketAddress, this._port, this._acceptListenBacklog, isEnableJni);
            log.info(this._protocol.getProtocolName() + " listening to " + this._socketAddress.getHostName() + ":" + this._serverSocket.getLocalPort());
        } else {
            this._serverSocket = system.openServerSocket(null, this._port, this._acceptListenBacklog, isEnableJni);
            log.info(this._protocol.getProtocolName() + " listening to *:" + this._serverSocket.getLocalPort());
        }
        assert (this._serverSocket != null);
        this.postBind();
    }

    public void bind(QServerSocket ss) throws Exception {
        if (ss == null) {
            throw new NullPointerException();
        }
        this._isBind.set(true);
        if (this._protocol == null) {
            throw new IllegalStateException(L.l("'{0}' must have a configured protocol before starting.", (Object)this));
        }
        if (this._throttle == null) {
            this._throttle = new Throttle();
        }
        this._serverSocket = ss;
        String scheme = this._protocol.getProtocolName();
        if (this._address != null) {
            log.info(scheme + " listening to " + this._address + ":" + this._port);
        } else {
            log.info(scheme + " listening to *:" + this._port);
        }
        if (this._sslFactory != null) {
            this._serverSocket = this._sslFactory.bind(this._serverSocket);
        }
    }

    public void postBind() {
        SocketPollService pollService;
        if (this._isPostBind.getAndSet(true)) {
            return;
        }
        if (this._serverSocket == null) {
            return;
        }
        this._serverSocket.setTcpNoDelay(this._isTcpNoDelay);
        this._serverSocket.setTcpKeepalive(this._isTcpKeepalive);
        this._serverSocket.setTcpCork(this._isTcpCork);
        this._serverSocket.setConnectionSocketTimeout((int)this.getSocketTimeout());
        if (this._serverSocket.isJni() && (pollService = SocketPollService.getCurrent()) != null && this.isKeepaliveAsyncEnabled()) {
            this._selectManager = pollService.getSelectManager();
        }
        if (this._keepaliveMax < 0 && this._selectManager != null) {
            this._keepaliveMax = this._selectManager.getSelectMax();
        }
        if (this._keepaliveMax < 0) {
            this._keepaliveMax = 65536;
        }
        this._admin.register();
    }

    public QServerSocket bindForWatchdog() throws IOException {
        QServerSocket ss;
        if (this._sslFactory instanceof JsseSSLFactory) {
            if (this._port < 1024) {
                log.warning(this + " cannot bind jsse in watchdog");
            }
            return null;
        }
        if (this._socketAddress != null) {
            ss = QJniServerSocket.createJNI(this._socketAddress, this._port);
            if (ss == null) {
                return null;
            }
            log.fine(this + " watchdog binding to " + this._socketAddress.getHostName() + ":" + this._port);
        } else {
            ss = QJniServerSocket.createJNI(null, this._port);
            if (ss == null) {
                return null;
            }
            log.fine(this + " watchdog binding to *:" + this._port);
        }
        if (!ss.isJni()) {
            ss.close();
            return ss;
        }
        ss.setTcpNoDelay(this._isTcpNoDelay);
        ss.setTcpKeepalive(this._isTcpKeepalive);
        ss.setTcpCork(this._isTcpCork);
        ss.setConnectionSocketTimeout((int)this.getSocketTimeout());
        return ss;
    }

    public void start() throws Exception {
        if (this._port < 0) {
            return;
        }
        if (!this._lifecycle.toStarting()) {
            return;
        }
        boolean isValid = false;
        try {
            this.bind();
            this.postBind();
            this.enable();
            this._launcher.start();
            this._suspendAlarm = new Alarm(new SuspendReaper());
            this._suspendAlarm.queue(this._suspendReaperTimeout);
            isValid = true;
        }
        finally {
            if (!isValid) {
                this.close();
            }
        }
    }

    public boolean isEnabled() {
        return this._lifecycle.isActive();
    }

    public void enable() {
        if (this._lifecycle.toActive() && this._serverSocket != null) {
            this._serverSocket.listen(this._acceptListenBacklog);
        }
    }

    public void disable() {
        if (this._lifecycle.toStop()) {
            if (this._serverSocket != null) {
                this._serverSocket.listen(0);
            }
            this._launcher.close();
            if (this._port >= 0) {
                if (this._address != null) {
                    log.info(this._protocol.getProtocolName() + " disabled " + this._address + ":" + this.getLocalPort());
                } else {
                    log.info(this._protocol.getProtocolName() + " disabled *:" + this.getLocalPort());
                }
            }
        }
    }

    TcpConnectionInfo[] getActiveConnections() {
        ArrayList<TcpConnectionInfo> infoList = new ArrayList<TcpConnectionInfo>();
        TcpSocketLink[] connections = new TcpSocketLink[this._activeConnectionSet.size()];
        ((ConcurrentHashMap.CollectionView)((Object)this._activeConnectionSet.keySet())).toArray(connections);
        for (int i = 0; i < connections.length; ++i) {
            TcpConnectionInfo connInfo = connections[i].getConnectionInfo();
            if (connInfo == null) continue;
            infoList.add(connInfo);
        }
        TcpConnectionInfo[] infoArray = new TcpConnectionInfo[infoList.size()];
        infoList.toArray(infoArray);
        return infoArray;
    }

    public AbstractSelectManager getSelectManager() {
        return this._selectManager;
    }

    @Friend(value=TcpSocketLink.class)
    boolean accept(QSocket socket) {
        block5: {
            try {
                SocketLinkThreadLauncher launcher = this.getLauncher();
                while (this.isActive()) {
                    Thread.interrupted();
                    if (!this._serverSocket.accept(socket)) continue;
                    if (launcher.isThreadMax() && !this.isKeepaliveAsyncEnabled() && launcher.getIdleCount() <= 1) {
                        _throttleDisconnectMeter.start();
                        this._lifetimeThrottleDisconnectCount.incrementAndGet();
                        socket.close();
                        continue;
                    }
                    if (this._throttle.accept(socket)) {
                        return true;
                    }
                    _throttleDisconnectMeter.start();
                    this._lifetimeThrottleDisconnectCount.incrementAndGet();
                    socket.close();
                }
            }
            catch (Throwable e) {
                if (!this._lifecycle.isActive() || !log.isLoggable(Level.FINER)) break block5;
                log.log(Level.FINER, e.toString(), e);
            }
        }
        return false;
    }

    void closeSocket(QSocket socket) {
        if (this._throttle != null) {
            this._throttle.close(socket);
        }
    }

    void requestShutdownBegin() {
        this._shutdownRequestCount.incrementAndGet();
    }

    void requestShutdownEnd() {
        this._shutdownRequestCount.decrementAndGet();
    }

    boolean isKeepaliveAllowed(long connectionStartTime) {
        if (!this._lifecycle.isActive()) {
            return false;
        }
        if (connectionStartTime + this._keepaliveTimeMax < CurrentTime.getCurrentTime()) {
            return false;
        }
        if (this._keepaliveMax <= this._keepaliveAllocateCount.get()) {
            return false;
        }
        return !this._launcher.isThreadMax() || !this._launcher.isIdleLow() || this.isKeepaliveAsyncEnabled();
    }

    public boolean isAsyncThrottle() {
        return this.isKeepaliveAsyncEnabled() && this._launcher.isThreadHigh();
    }

    void keepaliveAllocate() {
        this._keepaliveAllocateCount.incrementAndGet();
    }

    void keepaliveFree() {
        int value = this._keepaliveAllocateCount.decrementAndGet();
        if (value < 0 && this.isActive()) {
            System.out.println("FAILED keep-alive; " + value);
            Thread.dumpStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int keepaliveThreadRead(ReadStream is) throws IOException {
        if (this.isClosed()) {
            return -1;
        }
        int available = is.getBufferAvailable();
        if (available > 0) {
            return available;
        }
        long timeout = Math.min(this.getKeepaliveTimeout(), this.getSocketTimeout());
        int keepaliveThreadCount = this._keepaliveThreadCount.incrementAndGet();
        try {
            int result;
            if (this.isKeepaliveAsyncEnabled() && this._selectManager != null) {
                timeout = Math.min(timeout, this.getBlockingTimeoutForSelect());
                if (keepaliveThreadCount > 32) {
                    if (this.isAsyncThrottle()) {
                        int n = 0;
                        return n;
                    }
                    timeout = Math.min(timeout, 100L);
                }
            }
            if (timeout <= 0L) {
                int n = 0;
                return n;
            }
            _keepaliveThreadMeter.start();
            try {
                result = is.fillWithTimeout(timeout);
            }
            finally {
                _keepaliveThreadMeter.end();
            }
            if (this.isClosed()) {
                int n = -1;
                return n;
            }
            int n = result;
            return n;
        }
        catch (IOException e) {
            if (this.isClosed()) {
                log.log(Level.FINEST, e.toString(), e);
                int n = -1;
                return n;
            }
            throw e;
        }
        finally {
            this._keepaliveThreadCount.decrementAndGet();
        }
    }

    @Friend(value=SocketLinkState.class)
    void cometSuspend(TcpSocketLink conn) {
        _suspendMeter.start();
        this._suspendConnectionSet.add(conn);
    }

    @Friend(value=SocketLinkState.class)
    boolean cometDetach(TcpSocketLink conn) {
        _suspendMeter.end();
        return this._suspendConnectionSet.remove(conn);
    }

    void duplexKeepaliveBegin() {
    }

    void duplexKeepaliveEnd() {
    }

    public boolean isClosed() {
        return this._lifecycle.getState().isDestroyed();
    }

    public int getConnectionCount() {
        return this._activeConnectionCount.get();
    }

    public int getCometIdleCount() {
        return this._suspendConnectionSet.size();
    }

    public int getDuplexCount() {
        return 0;
    }

    void addLifetimeRequestCount() {
        this._lifetimeRequestCount.incrementAndGet();
    }

    public long getLifetimeRequestCount() {
        return this._lifetimeRequestCount.get();
    }

    void addLifetimeKeepaliveCount() {
        _keepaliveMeter.start();
        this._lifetimeKeepaliveCount.incrementAndGet();
    }

    public long getLifetimeKeepaliveCount() {
        return this._lifetimeKeepaliveCount.get();
    }

    void addLifetimeKeepaliveSelectCount() {
        this._lifetimeKeepaliveSelectCount.incrementAndGet();
    }

    public long getLifetimeKeepaliveSelectCount() {
        return this._lifetimeKeepaliveSelectCount.get();
    }

    void addLifetimeClientDisconnectCount() {
        this._lifetimeClientDisconnectCount.incrementAndGet();
    }

    public long getLifetimeClientDisconnectCount() {
        return this._lifetimeClientDisconnectCount.get();
    }

    void addLifetimeRequestTime(long time) {
        this._lifetimeRequestTime.addAndGet(time);
    }

    public long getLifetimeRequestTime() {
        return this._lifetimeRequestTime.get();
    }

    void addLifetimeReadBytes(long bytes) {
        this._lifetimeReadBytes.addAndGet(bytes);
    }

    public long getLifetimeReadBytes() {
        return this._lifetimeReadBytes.get();
    }

    void addLifetimeWriteBytes(long bytes) {
        this._lifetimeWriteBytes.addAndGet(bytes);
    }

    public long getLifetimeWriteBytes() {
        return this._lifetimeWriteBytes.get();
    }

    long getLifetimeThrottleDisconnectCount() {
        return this._lifetimeThrottleDisconnectCount.get();
    }

    public TcpSocketLink findConnectionByThreadId(long threadId) {
        ArrayList connList = new ArrayList(this._activeConnectionSet.keySet());
        for (TcpSocketLink conn : connList) {
            if (conn.getThreadId() != threadId) continue;
            return conn;
        }
        return null;
    }

    TcpSocketLink allocateConnection() throws IOException {
        TcpSocketLink startConn = this._idleConn.allocate();
        if (startConn == null) {
            int connId = this._connectionCount.incrementAndGet();
            QSocket socket = this._serverSocket.createSocket();
            startConn = new TcpSocketLink(connId, this, socket);
        }
        this._activeConnectionSet.put(startConn, startConn);
        this._activeConnectionCount.incrementAndGet();
        return startConn;
    }

    @Friend(value=TcpSocketLink.class)
    void closeConnection(TcpSocketLink conn) {
        if (this._activeConnectionSet.remove(conn) != null) {
            this._activeConnectionCount.decrementAndGet();
        } else if (!this.isClosed()) {
            Thread.dumpStack();
        }
        this._launcher.wake();
    }

    @Friend(value=TcpSocketLink.class)
    void free(TcpSocketLink conn) {
        this._idleConn.free(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeBind() {
        if (!this._lifecycle.toStop()) {
            return;
        }
        this.disable();
        this._launcher.close();
        QServerSocket serverSocket = this._serverSocket;
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                QServerSocket qServerSocket = serverSocket;
                synchronized (qServerSocket) {
                    serverSocket.notifyAll();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        TcpSocketLink conn;
        HashSet activeSet;
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " closing");
        }
        this._launcher.close();
        Alarm suspendAlarm = this._suspendAlarm;
        this._suspendAlarm = null;
        if (suspendAlarm != null) {
            suspendAlarm.dequeue();
        }
        QServerSocket serverSocket = this._serverSocket;
        this._serverSocket = null;
        InetAddress localAddress = null;
        int localPort = this.getLocalPort();
        if (this._port > 0) {
            localPort = this._port;
            localAddress = this._socketAddress;
        } else if (serverSocket != null) {
            localAddress = serverSocket.getLocalAddress();
            localPort = serverSocket.getLocalPort();
        }
        if (localPort == 0) {
            localPort = this._port;
        }
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                QServerSocket qServerSocket = serverSocket;
                synchronized (qServerSocket) {
                    serverSocket.notifyAll();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this._selectManager != null) {
            try {
                this._selectManager.onPortClose(this);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        ConcurrentHashMap<TcpSocketLink, TcpSocketLink> concurrentHashMap = this._activeConnectionSet;
        synchronized (concurrentHashMap) {
            activeSet = new HashSet(this._activeConnectionSet.keySet());
        }
        for (TcpSocketLink conn2 : activeSet) {
            try {
                conn2.requestDestroy();
            }
            catch (Exception e) {
                log.log(Level.FINEST, e.toString(), e);
            }
        }
        this._launcher.wake();
        if (localPort > 0) {
            int idleCount = this.getIdleThreadCount() + this.getStartThreadCount();
            for (int i = 0; i < idleCount + 10 && this.getIdleThreadCount() + this.getStartThreadCount() != 0; ++i) {
                InetSocketAddress addr;
                if (localAddress == null || localAddress.getHostAddress().startsWith("0.")) {
                    addr = new InetSocketAddress("127.0.0.1", localPort);
                    this.connectAndClose(addr);
                    addr = new InetSocketAddress("[::1]", localPort);
                    this.connectAndClose(addr);
                } else {
                    addr = new InetSocketAddress(localAddress, localPort);
                    this.connectAndClose(addr);
                }
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        while ((conn = this._idleConn.allocate()) != null) {
            conn.requestDestroy();
        }
        log.finest(this + " closed");
    }

    private void connectAndClose(InetSocketAddress addr) {
        try {
            Socket socket = new Socket();
            socket.connect(addr, 100);
            socket.close();
        }
        catch (ConnectException socket) {
        }
        catch (Throwable e) {
            log.log(Level.FINEST, e.toString(), e);
        }
    }

    public String toURL() {
        return this.getUrl();
    }

    public String toString() {
        if (this._url != null) {
            return this.getClass().getSimpleName() + "[" + this._url + "]";
        }
        return this.getClass().getSimpleName() + "[" + this.getAddress() + ":" + this.getPort() + "]";
    }

    public class SuspendReaper
    implements AlarmListener {
        private ArrayList<TcpSocketLink> _suspendSet = new ArrayList();
        private ArrayList<TcpSocketLink> _timeoutSet = new ArrayList();
        private ArrayList<TcpSocketLink> _completeSet = new ArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleAlarm(Alarm alarm) {
            try {
                TcpSocketLink conn;
                int i;
                this._suspendSet.clear();
                this._timeoutSet.clear();
                this._completeSet.clear();
                long now = CurrentTime.getCurrentTime();
                TcpPort.this._launcher.wake();
                this._suspendSet.addAll(TcpPort.this._suspendConnectionSet);
                for (i = this._suspendSet.size() - 1; i >= 0; --i) {
                    conn = this._suspendSet.get(i);
                    if (conn.getIdleExpireTime() < now) {
                        this._timeoutSet.add(conn);
                        continue;
                    }
                    long idleStartTime = conn.getIdleStartTime();
                    if (idleStartTime + TcpPort.this._suspendCloseTimeMax >= now || !conn.isReadEof()) continue;
                    this._completeSet.add(conn);
                }
                for (i = this._timeoutSet.size() - 1; i >= 0; --i) {
                    conn = this._timeoutSet.get(i);
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(this + " suspend idle timeout " + conn);
                    }
                    try {
                        conn.requestCometTimeout();
                        continue;
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, conn + ": " + e.getMessage(), e);
                    }
                }
                for (i = this._completeSet.size() - 1; i >= 0; --i) {
                    conn = this._completeSet.get(i);
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(this + " async end-of-file " + conn);
                    }
                    try {
                        conn.requestCometComplete();
                        continue;
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, conn + ": " + e.getMessage(), e);
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                if (!TcpPort.this.isClosed()) {
                    alarm.queue(TcpPort.this._suspendReaperTimeout);
                }
            }
        }
    }
}

