/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.network.listen;

import com.caucho.env.shutdown.ShutdownSystem;
import com.caucho.inject.Module;
import com.caucho.inject.RequestContext;
import com.caucho.loader.Environment;
import com.caucho.management.server.TcpConnectionInfo;
import com.caucho.network.listen.AbstractSelectManager;
import com.caucho.network.listen.AbstractSocketLink;
import com.caucho.network.listen.AcceptTask;
import com.caucho.network.listen.AsyncController;
import com.caucho.network.listen.CometResumeTask;
import com.caucho.network.listen.ConnectionTask;
import com.caucho.network.listen.DestroyTask;
import com.caucho.network.listen.DuplexReadTask;
import com.caucho.network.listen.KeepaliveRequestTask;
import com.caucho.network.listen.KeepaliveTimeoutTask;
import com.caucho.network.listen.Protocol;
import com.caucho.network.listen.ProtocolConnection;
import com.caucho.network.listen.RequestState;
import com.caucho.network.listen.SocketLinkCometListener;
import com.caucho.network.listen.SocketLinkDuplexController;
import com.caucho.network.listen.SocketLinkDuplexListener;
import com.caucho.network.listen.SocketLinkRequestState;
import com.caucho.network.listen.SocketLinkState;
import com.caucho.network.listen.SocketLinkThreadLauncher;
import com.caucho.network.listen.TcpAsyncController;
import com.caucho.network.listen.TcpPort;
import com.caucho.util.CurrentTime;
import com.caucho.util.Friend;
import com.caucho.util.L10N;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.QSocket;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.SocketTimeoutException;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

@Module
public class TcpSocketLink
extends AbstractSocketLink {
    private static final L10N L = new L10N(TcpSocketLink.class);
    private static final Logger log = Logger.getLogger(TcpSocketLink.class.getName());
    private static final ThreadLocal<ProtocolConnection> _currentRequest = new ThreadLocal();
    private final int _connectionId;
    private final String _id;
    private final String _name;
    private String _dbgId;
    private final TcpPort _port;
    private final QSocket _socket;
    private final ProtocolConnection _request;
    private final ClassLoader _loader;
    private final AcceptTask _acceptTask;
    private final KeepaliveRequestTask _keepaliveTask;
    private final KeepaliveTimeoutTask _keepaliveTimeoutTask;
    private final CometResumeTask _resumeTask;
    private DuplexReadTask _duplexReadTask;
    private SocketLinkState _state = SocketLinkState.INIT;
    private final AtomicReference<SocketLinkRequestState> _requestStateRef = new AtomicReference<SocketLinkRequestState>(SocketLinkRequestState.INIT);
    private TcpAsyncController _async;
    private long _idleTimeout;
    private long _suspendTimeout;
    private long _connectionStartTime;
    private long _requestStartTime;
    private long _idleStartTime;
    private long _idleExpireTime;
    private String _displayState;
    private volatile Thread _thread;

    TcpSocketLink(int connId, TcpPort listener, QSocket socket) {
        this._connectionId = connId;
        this._port = listener;
        this._socket = socket;
        int id = this.getId();
        this._loader = listener.getClassLoader();
        Protocol protocol = listener.getProtocol();
        this._request = protocol.createConnection(this);
        this._name = this._id = listener.getDebugId() + "-" + id;
        this._acceptTask = new AcceptTask(this);
        this._keepaliveTask = new KeepaliveRequestTask(this);
        this._keepaliveTimeoutTask = new KeepaliveTimeoutTask(this);
        this._resumeTask = new CometResumeTask(this);
    }

    public static ProtocolConnection getCurrentRequest() {
        return _currentRequest.get();
    }

    public static void setCurrentRequest(ProtocolConnection request) {
        _currentRequest.set(request);
    }

    @Override
    public int getId() {
        return this._connectionId;
    }

    public String getDebugId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public TcpPort getPort() {
        return this._port;
    }

    public SocketLinkThreadLauncher getLauncher() {
        return this.getPort().getLauncher();
    }

    public final ProtocolConnection getRequest() {
        return this._request;
    }

    public TcpConnectionInfo getConnectionInfo() {
        TcpConnectionInfo connectionInfo = null;
        if (this.isActive() && (connectionInfo = new TcpConnectionInfo(this.getId(), this.getThreadId(), this._port.getAddress(), this._port.getPort(), this.getDisplayState(), this.getRequestStartTime())).hasRequest()) {
            connectionInfo.setRemoteAddress(this.getRemoteHost());
            connectionInfo.setUrl(this.getRequestUrl());
        }
        return connectionInfo;
    }

    public String getRequestUrl() {
        ProtocolConnection request = this.getRequest();
        String url = request.getProtocolRequestURL();
        if (url != null && !"".equals(url)) {
            return url;
        }
        TcpPort port = this.getPort();
        String protocolName = port.getProtocolName();
        if (protocolName == null) {
            protocolName = "request";
        }
        if (port.getAddress() == null) {
            return protocolName + "://*:" + port.getPort();
        }
        return protocolName + "://" + port.getAddress() + ":" + port.getPort();
    }

    public void setIdleTimeout(long idleTimeout) {
        this._idleTimeout = idleTimeout;
        this._suspendTimeout = idleTimeout;
    }

    public long getIdleTimeout() {
        return this._idleTimeout;
    }

    @Override
    public boolean isPortActive() {
        return this._port.isActive();
    }

    @Override
    public SocketLinkState getState() {
        return this._state;
    }

    public final boolean isIdle() {
        return this._state.isIdle();
    }

    public boolean isActive() {
        return this._state.isActive();
    }

    public boolean isRequestActive() {
        return this._state.isRequestActive();
    }

    @Override
    public boolean isKeepaliveAllocated() {
        return this._state.isKeepaliveAllocated();
    }

    public boolean isClosed() {
        return this._state.isClosed();
    }

    public final boolean isDestroyed() {
        return this._state.isDestroyed() || this._requestStateRef.get().isDestroyed();
    }

    @Override
    public boolean isCometActive() {
        TcpAsyncController async = this._async;
        return this._state.isCometActive() && async != null && !async.isCompleteRequested();
    }

    public boolean isAsyncStarted() {
        return this._requestStateRef.get().isAsyncStarted();
    }

    public boolean isAsync() {
        return this._requestStateRef.get().isAsyncStarted() || this._requestStateRef.get().isAsyncWake();
    }

    public boolean isAsyncComplete() {
        TcpAsyncController async = this._async;
        return async != null && async.isCompleteRequested();
    }

    @Override
    public boolean isCometSuspend() {
        return this._state.isCometSuspend();
    }

    boolean isCometComplete() {
        TcpAsyncController async = this._async;
        return async != null && async.isCompleteRequested();
    }

    @Override
    public boolean isDuplex() {
        return this._state.isDuplex();
    }

    boolean isWakeRequested() {
        return this._requestStateRef.get().isAsyncWake();
    }

    SocketLinkRequestState getRequestState() {
        return this._requestStateRef.get();
    }

    public QSocket getSocket() {
        return this._socket;
    }

    @Override
    public InetAddress getLocalAddress() {
        return this._socket.getLocalAddress();
    }

    @Override
    public String getLocalHost() {
        return this._socket.getLocalHost();
    }

    @Override
    public int getLocalPort() {
        return this._socket.getLocalPort();
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this._socket.getRemoteAddress();
    }

    @Override
    public String getRemoteHost() {
        return this._socket.getRemoteHost();
    }

    @Override
    public int getRemoteAddress(byte[] buffer, int offset, int length) {
        return this._socket.getRemoteAddress(buffer, offset, length);
    }

    @Override
    public int getRemotePort() {
        return this._socket.getRemotePort();
    }

    @Override
    public boolean isSecure() {
        return this._socket.isSecure() || this._port.isSecure();
    }

    @Override
    public String getVirtualHost() {
        return this.getPort().getVirtualHost();
    }

    @Override
    public String getCipherSuite() {
        return this._socket.getCipherSuite();
    }

    @Override
    public String getSslProtocol() {
        return this._socket.getSslProtocol();
    }

    @Override
    public int getKeySize() {
        return this._socket.getCipherBits();
    }

    @Override
    public X509Certificate[] getClientCertificates() throws CertificateException {
        return this._socket.getClientCertificates();
    }

    public final long getThreadId() {
        Thread thread = this._thread;
        if (thread != null) {
            return thread.getId();
        }
        return -1L;
    }

    public final Thread getThread() {
        return this._thread;
    }

    public final long getConnectionStartTime() {
        return this._connectionStartTime;
    }

    public final long getRequestStartTime() {
        return this._requestStartTime;
    }

    public long getIdleExpireTime() {
        return this._idleExpireTime;
    }

    public long getIdleStartTime() {
        return this._idleStartTime;
    }

    private Runnable getAcceptTask() {
        return this._acceptTask;
    }

    private ConnectionTask getKeepaliveTask() {
        if (this._state.isDuplex()) {
            return this._duplexReadTask;
        }
        return this._keepaliveTask;
    }

    private ConnectionTask getKeepaliveTimeoutTask() {
        return this._keepaliveTimeoutTask;
    }

    private ConnectionTask getResumeTask() {
        return this._resumeTask;
    }

    public String getDisplayState() {
        return this._displayState;
    }

    private void setStatState(String state) {
        this._displayState = state;
    }

    @Friend(value=TcpPort.class)
    boolean isReadEof() {
        QSocket socket = this._socket;
        if (socket == null) {
            return true;
        }
        try {
            StreamImpl s = socket.getStream();
            return s.isEof();
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return true;
        }
    }

    @Friend(value=SocketLinkThreadLauncher.class)
    AcceptTask requestAccept() {
        if (this._requestStateRef.get().toAccept(this._requestStateRef)) {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " request-accept " + this.getName() + " (count=" + this._port.getThreadCount() + ", idle=" + this._port.getIdleThreadCount() + ")");
            }
            return this._acceptTask;
        }
        return null;
    }

    void requestWakeKeepalive() {
        if (this._requestStateRef.get().toWakeKeepalive(this._requestStateRef) && !this.getLauncher().offerResumeTask(this.getKeepaliveTask())) {
            log.severe(L.l("Schedule failed for {0}", (Object)this));
        }
    }

    void requestTimeoutKeepalive() {
        if (this._requestStateRef.get().toWakeKeepalive(this._requestStateRef) && !this.getLauncher().offerResumeTask(this.getKeepaliveTimeoutTask())) {
            log.severe(L.l("Schedule failed for {0}", (Object)this));
        }
    }

    void requestWakeComet() {
        if (this._requestStateRef.get().toAsyncWake(this._requestStateRef) && !this.getLauncher().offerResumeTask(this.getResumeTask())) {
            log.severe(L.l("Schedule failed for {0}", (Object)this));
        }
    }

    void requestCometComplete() {
        TcpAsyncController async = this._async;
        if (async != null) {
            async.setCompleteRequested();
        }
        try {
            this.requestWakeComet();
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    void requestCometTimeout() {
        TcpAsyncController async = this._async;
        if (async != null) {
            async.setTimeout();
        }
        try {
            this.requestWakeComet();
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    public final void requestDestroy() {
        if (this._requestStateRef.get().toDestroy(this._requestStateRef)) {
            if (!this.getLauncher().offerResumeTask(new DestroyTask(this))) {
                if (CurrentTime.isTest()) {
                    this.destroy();
                } else {
                    this.disconnect();
                }
            }
        } else if (CurrentTime.isTest()) {
            this.closeConnection();
        } else {
            this.disconnect();
        }
    }

    private void destroy() {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + " destroying connection");
        }
        try {
            this._socket.forceShutdown();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SocketLinkState state = this._state;
        this._state = this._state.toDestroy(this);
        this.closeConnection(state);
    }

    private void disconnect() {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + " disconnecting connection");
        }
        try {
            this._socket.disconnect();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void requestShutdownBegin() {
        this._port.requestShutdownBegin();
    }

    @Override
    public void requestShutdownEnd() {
        this._port.requestShutdownEnd();
    }

    @Friend(value=ConnectionTask.class)
    final void startThread(Thread thread) {
        Thread oldThread;
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + " start thread " + thread.getName() + " (count=" + this._port.getThreadCount() + ", idle=" + this._port.getIdleThreadCount() + ")");
        }
        if ((oldThread = this._thread) != null) {
            throw new IllegalStateException("old: " + oldThread.getId() + "@" + oldThread + " current: " + thread.getId() + "@" + thread);
        }
        this._thread = thread;
        this._request.onAttachThread();
    }

    @Friend(value=ConnectionTask.class)
    final void finishThread(RequestState resultState) {
        Thread currentThread;
        Thread thread = this._thread;
        this._thread = null;
        this._request.onDetachThread();
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + " finish thread: " + Thread.currentThread().getName());
        }
        if (thread != (currentThread = Thread.currentThread())) {
            Thread.dumpStack();
            throw new IllegalStateException("old: " + thread + " current: " + currentThread);
        }
        if (this._port.isClosed()) {
            this.destroy();
            return;
        }
        if (this._requestStateRef.get().isDestroyed()) {
            this.destroy();
        }
        SocketLinkRequestState reqState = this._requestStateRef.get();
        SocketLinkState state = this._state;
        if (reqState.isAsyncStarted() || reqState.isAsyncWake()) {
            if (state.isClosed()) {
                this.destroy();
                return;
            }
            if (!reqState.toAsyncSuspendThread(this._requestStateRef) && !this.getLauncher().offerResumeTask(this.getResumeTask())) {
                log.severe(L.l("Schedule resume failed for {0}", (Object)this));
            }
            return;
        }
        if (!(state.isComet() || state.isDuplex() || resultState.isAsyncOrDuplex())) {
            try {
                this.closeAsyncIfNotAsync();
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        if (resultState.isKeepaliveSelect() && !state.isClosed()) {
            if (!reqState.toSuspendKeepalive(this._requestStateRef) && !this.getLauncher().offerResumeTask(this.getKeepaliveTask())) {
                log.severe(L.l("Schedule keepalive failed for {0}", (Object)this));
            }
            return;
        }
        if (resultState.isDetach() && !state.isClosed()) {
            return;
        }
        this.getPort().closeConnection(this);
        if (state.isAllowIdle() && this._requestStateRef.get().isAllowIdle()) {
            this._state = state.toIdle();
            try {
                this._requestStateRef.get().toIdle(this._requestStateRef);
                this._port.free(this);
            }
            catch (Exception e) {
                log.log(Level.FINEST, e.toString(), e);
            }
        } else if (!this.isDestroyed()) {
            if (resultState.isClosed()) {
                this.close();
            } else if (this._port.isActive()) {
                String msg = this + " Internal error unable to free:  result=" + (Object)((Object)resultState) + " requestState=" + (Object)((Object)reqState) + " " + (Object)((Object)this._requestStateRef.get());
                log.warning(msg);
            }
        }
    }

    @Friend(value=ConnectionTask.class)
    RequestState handleAcceptTask() throws IOException {
        this.getLauncher().onChildIdleBegin();
        try {
            RequestState requestState = this.handleAcceptTaskImpl();
            return requestState;
        }
        finally {
            this.getLauncher().onChildIdleEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Friend(value=AcceptTask.class)
    RequestState handleAcceptTaskImpl() throws IOException {
        TcpPort listener = this.getPort();
        SocketLinkThreadLauncher launcher = listener.getLauncher();
        RequestState result = RequestState.REQUEST_COMPLETE;
        while (result.isAcceptAllowed() && listener.isActive() && !this.getState().isDestroyed()) {
            this.setStatState("accept");
            this._state = this._state.toAccept();
            if (!this.accept() || !listener.isActive()) {
                this.setStatState("close");
                this.close();
                return RequestState.EXIT;
            }
            launcher.onChildIdleEnd();
            try {
                this.toStartConnection();
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " accept from " + this.getRemoteHost() + ":" + this.getRemotePort());
                }
                if (this._port.isAsyncThrottle()) {
                    this._state = this._state.toActiveWithKeepalive(this);
                    result = this.handleRequests(false);
                    continue;
                }
                result = this.handleRequests(true);
            }
            catch (IOException e) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, this + " handleAccept: " + e, e);
                } else if (log.isLoggable(Level.FINE)) {
                    log.fine(this + " handleAccept: " + e);
                }
                this.setStatState("close");
                this.close();
                RequestState requestState = RequestState.EXIT;
                return requestState;
            }
            finally {
                launcher.onChildIdleBegin();
            }
        }
        return result;
    }

    private boolean accept() {
        SocketLinkThreadLauncher launcher = this._port.getLauncher();
        if (launcher.isIdleOverflow()) {
            return false;
        }
        return this.getPort().accept(this.getSocket());
    }

    @Friend(value=KeepaliveRequestTask.class)
    RequestState handleKeepaliveTask() throws IOException {
        return this.handleRequests(true);
    }

    @Friend(value=KeepaliveTimeoutTask.class)
    RequestState handleKeepaliveTimeoutTask() throws IOException {
        this._state = this._state.toActiveNoKeepalive(this);
        this.close();
        return RequestState.CLOSED;
    }

    @Friend(value=DestroyTask.class)
    RequestState handleDestroyTask() throws IOException {
        this.destroy();
        return RequestState.EXIT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Friend(value=CometResumeTask.class)
    RequestState handleResumeTask() {
        try {
            block18: {
                do {
                    this._state = this._state.toCometResume(this);
                    TcpAsyncController async = this.getAsyncController();
                    if (async == null) {
                        this.close();
                        RequestState requestState = RequestState.EXIT;
                        return requestState;
                    }
                    if (async.isTimeout() && async.timeout()) {
                        this._request.handleResume();
                        this.close();
                        RequestState requestState = RequestState.EXIT;
                        return requestState;
                    }
                    async.toResume();
                    long requestTimeout = this.getPort().getRequestTimeout();
                    if (requestTimeout > 0L) {
                        this._socket.setRequestExpireTime(CurrentTime.getCurrentTime() + requestTimeout);
                    }
                    this.getRequest().handleResume();
                    if (!this.isAsync()) break block18;
                } while (!this.toSuspend());
                RequestState requestState = RequestState.ASYNC;
                return requestState;
            }
            if (this.isKeepaliveAllocated()) {
                this.closeAsync();
                RequestState requestState = this.handleRequests(false);
                return requestState;
            }
            this.closeAsync();
            this.close();
            RequestState requestState = RequestState.REQUEST_COMPLETE;
            return requestState;
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        catch (OutOfMemoryError e) {
            String msg = "TcpSocketLink OutOfMemory";
            ShutdownSystem.shutdownOutOfMemory(msg);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        finally {
            this._socket.setRequestExpireTime(0L);
        }
        return RequestState.EXIT;
    }

    @Friend(value=DuplexReadTask.class)
    RequestState handleDuplexRead(SocketLinkDuplexController duplex) throws IOException {
        this.toDuplexActive();
        RequestState result = RequestState.EXIT;
        ReadStream readStream = this.getReadStream();
        while ((result = this.processKeepalive()) == RequestState.REQUEST_COMPLETE) {
            this.toDuplexActive();
            long position = readStream.getPosition();
            duplex.serviceRead();
            if (position == readStream.getPosition()) {
                log.warning(duplex + " was not processing any data. Shutting down.");
                this.close();
                return RequestState.EXIT;
            }
            if (!duplex.isCompleteRequested()) continue;
            this.close();
            return RequestState.EXIT;
        }
        if (result.isClosed()) {
            this.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestState handleRequests(boolean isDataAvailable) throws IOException {
        Thread thread = this.getThread();
        RequestState result = RequestState.EXIT;
        try {
            result = this.handleRequestsImpl(isDataAvailable);
        }
        catch (ClientDisconnectException e) {
            this._port.addLifetimeClientDisconnectCount();
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.dbgId() + e);
            }
        }
        catch (InterruptedIOException e) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, this.dbgId() + e, e);
            }
        }
        catch (IOException e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, this.dbgId() + e, e);
            }
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, this.dbgId() + e, e);
            }
        }
        finally {
            thread.setContextClassLoader(this._loader);
            if (result == null) {
                result = RequestState.EXIT;
            }
        }
        switch (result) {
            case KEEPALIVE_SELECT: 
            case ASYNC: {
                return result;
            }
            case DUPLEX: {
                return this._duplexReadTask.doTask();
            }
            case EXIT: 
            case CLOSED: {
                this.close();
                return result;
            }
            case REQUEST_COMPLETE: {
                this.close();
                return result;
            }
        }
        throw new IllegalStateException(String.valueOf((Object)result));
    }

    private RequestState handleRequestsImpl(boolean isDataAvailable) throws IOException {
        RequestState result;
        do {
            result = RequestState.EXIT;
            if (this._port.isClosed()) {
                return RequestState.EXIT;
            }
            Thread.interrupted();
            if (!isDataAvailable && (result = this.processKeepalive()) != RequestState.REQUEST_COMPLETE) {
                return result;
            }
            this.getPort().addLifetimeRequestCount();
            try {
                result = this.handleRequest();
            }
            finally {
                if (!result.isAsyncOrDuplex()) {
                    this.closeAsyncIfNotAsync();
                }
            }
            isDataAvailable = false;
        } while (result.isRequestKeepalive() && this._state.isKeepaliveAllocated());
        return result;
    }

    private RequestState handleRequest() throws IOException {
        this.dispatchRequest();
        if (this._state == SocketLinkState.DUPLEX) {
            if (this._duplexReadTask == null) {
                throw new NullPointerException();
            }
            return RequestState.DUPLEX;
        }
        this.getWriteStream().flush();
        if (this.isAsync()) {
            if (this.toSuspend()) {
                return RequestState.ASYNC;
            }
            return this.handleResumeTask();
        }
        return RequestState.REQUEST_COMPLETE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchRequest() throws IOException {
        Thread thread = this.getThread();
        try {
            thread.setContextClassLoader(this._loader);
            _currentRequest.set(this._request);
            RequestContext.begin();
            this._requestStartTime = CurrentTime.getCurrentTime();
            long requestTimeout = this.getPort().getRequestTimeout();
            if (requestTimeout > 0L) {
                this._socket.setRequestExpireTime(this._requestStartTime + requestTimeout);
            }
            long readBytes = this._socket.getTotalReadBytes();
            long writeBytes = this._socket.getTotalWriteBytes();
            this._state = this._state.toActive(this, this._connectionStartTime);
            if (!this.getRequest().handleRequest()) {
                this.killKeepalive("dispatch handleRequest failed");
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this + " disabled keepalive because request failed " + this.getRequest());
                }
            }
            this._requestStartTime = 0L;
            long readBytesEnd = this._socket.getTotalReadBytes();
            long writeBytesEnd = this._socket.getTotalWriteBytes();
            this._port.addLifetimeReadBytes(readBytesEnd - readBytes);
            this._port.addLifetimeWriteBytes(writeBytesEnd - writeBytes);
        }
        finally {
            thread.setContextClassLoader(this._loader);
            _currentRequest.set(null);
            RequestContext.end();
            this._socket.setRequestExpireTime(0L);
        }
    }

    private RequestState processKeepalive() throws IOException {
        TcpPort port = this._port;
        this._idleStartTime = CurrentTime.getCurrentTimeActual();
        this._idleExpireTime = this._idleStartTime + this.getIdleTimeout();
        int available = this._port.getSelectManager() != null ? port.keepaliveThreadRead(this.getReadStream()) : 0;
        if (available > 0) {
            return RequestState.REQUEST_COMPLETE;
        }
        if (available < 0) {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " keepalive read failed: " + available);
            }
            this.killKeepalive("process-keepalive eof");
            this.setStatState(null);
            return RequestState.CLOSED;
        }
        this.getPort().addLifetimeKeepaliveCount();
        this._state = this._state.toKeepalive(this);
        if (this._port.getSelectManager() != null) {
            this._requestStateRef.get().toStartKeepalive(this._requestStateRef);
            this._state = this._state.toKeepaliveSelect();
            if (this._port.getSelectManager().keepalive(this)) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this.dbgId() + " keepalive (select)");
                }
                this.getPort().addLifetimeKeepaliveSelectCount();
                return RequestState.KEEPALIVE_SELECT;
            }
            log.warning(this.dbgId() + " failed keepalive (select)");
            System.out.println("FAILED_KA:");
            this._requestStateRef.get().toWakeKeepalive(this._requestStateRef);
        }
        return this.threadKeepalive();
    }

    private RequestState threadKeepalive() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.dbgId() + " keepalive (thread)");
        }
        long timeout = this.getIdleTimeout();
        long expires = timeout + CurrentTime.getCurrentTimeActual();
        do {
            try {
                long result;
                long delta = expires - CurrentTime.getCurrentTimeActual();
                if (delta < 0L) {
                    delta = 0L;
                }
                if ((result = (long)this.getReadStream().fillWithTimeout(delta)) > 0L) {
                    return RequestState.REQUEST_COMPLETE;
                }
                if (result < 0L) {
                    return RequestState.CLOSED;
                }
            }
            catch (SocketTimeoutException e) {
                log.log(Level.FINEST, e.toString(), e);
            }
            catch (IOException e) {
                log.log(Level.FINEST, e.toString(), e);
                break;
            }
        } while (CurrentTime.getCurrentTimeActual() < expires);
        this.killKeepalive("thread-keepalive timeout (" + timeout + "ms)");
        return RequestState.CLOSED;
    }

    private void toStartConnection() throws IOException {
        this._connectionStartTime = CurrentTime.getCurrentTime();
        this.setStatState("read");
        this.initSocket();
        this._request.onStartConnection();
    }

    private void initSocket() throws IOException {
        this._idleTimeout = this._port.getKeepaliveTimeout();
        this._suspendTimeout = this._port.getSuspendTimeMax();
        this.getWriteStream().init(this._socket.getStream());
        ReadStream is = this.getReadStream();
        is.init(this._socket.getStream(), null);
        byte[] buffer = is.getBuffer();
        int readLength = buffer.length;
        readLength = 0;
        int len = this._socket.acceptInitialRead(buffer, 0, readLength);
        if (len > 0) {
            is.setLength(len);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this.dbgId() + "starting connection " + this + ", total=" + this._port.getConnectionCount());
        }
    }

    @Override
    public void clientDisconnect() {
        this.killKeepalive("client disconnect");
        TcpAsyncController async = this._async;
        if (async != null) {
            async.complete();
        }
    }

    @Override
    public void killKeepalive(String reason) {
        Thread thread = Thread.currentThread();
        SocketLinkState state = this._state;
        if (thread != this._thread && !state.isAsyncStarted()) {
            throw new IllegalStateException(L.l("{0} killKeepalive called from invalid thread.\n  expected: {1}\n  actual: {2}", (Object)this, (Object)this._thread, (Object)thread));
        }
        this._state = state.toKillKeepalive(this);
        if (log.isLoggable(Level.FINE) && state.isKeepaliveAllocated()) {
            log.fine(this + " keepalive disabled from " + (Object)((Object)state) + ", reason=" + reason);
        }
    }

    TcpAsyncController getAsyncController() {
        return this._async;
    }

    @Override
    public AsyncController toComet(SocketLinkCometListener cometHandler) {
        Thread thread = Thread.currentThread();
        if (thread != this._thread) {
            throw new IllegalStateException(L.l("{0} toComet called from invalid thread.\n  expected: {1}\n  actual: {2}", (Object)this, (Object)this._thread, (Object)thread));
        }
        TcpAsyncController async = this._async;
        if (async != null && async.isCompleteRequested()) {
            throw new IllegalStateException(L.l("Comet cannot be requested after complete()."));
        }
        this._requestStateRef.get().toAsyncStart(this._requestStateRef);
        this._state = this._state.toComet();
        if (async == null) {
            this._async = async = new TcpAsyncController(this);
        }
        async.initHandler(cometHandler);
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " starting comet " + cometHandler);
        }
        return async;
    }

    @Override
    public AsyncController toCometRestart(SocketLinkCometListener cometHandler) {
        TcpAsyncController async = this._async;
        if (async != null && async.isCompleteRequested()) {
            return async;
        }
        return this.toComet(cometHandler);
    }

    private boolean toSuspend() {
        this._idleStartTime = CurrentTime.getCurrentTime();
        this._idleExpireTime = this._idleStartTime + this._suspendTimeout;
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " suspending comet");
        }
        this._state = this._state.toCometSuspend(this);
        return this._requestStateRef.get().toAsyncSuspendRequest(this._requestStateRef);
    }

    @Override
    public SocketLinkDuplexController startDuplex(SocketLinkDuplexListener handler) {
        Thread thread = Thread.currentThread();
        if (thread != this._thread) {
            throw new IllegalStateException(L.l("{0} toComet called from invalid thread", (Object)this));
        }
        this._state = this._state.toDuplex(this);
        SocketLinkDuplexController duplex = new SocketLinkDuplexController(this, handler);
        this._duplexReadTask = new DuplexReadTask(this, duplex);
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " starting duplex " + handler);
        }
        try {
            handler.onStart(duplex);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return duplex;
    }

    private void toDuplexActive() {
        this._state = this._state.toDuplexActive(this);
    }

    private void close() {
        this.setStatState(null);
        this.closeAsync();
        this.closeConnection();
    }

    private void closeConnection() {
        SocketLinkState state = this._state;
        this._state = state.toClosed(this);
        this.closeConnection(state);
    }

    private void closeConnection(SocketLinkState state) {
        AbstractSelectManager selectManager = this._port.getSelectManager();
        if (selectManager != null && state.isKeepalive()) {
            selectManager.closeKeepalive(this);
        }
        if (state.isClosed() || state.isIdle()) {
            return;
        }
        try {
            this.getWriteStream().close();
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        try {
            this.getReadStream().close();
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        TcpPort port = this.getPort();
        QSocket socket = this._socket;
        if (port != null) {
            port.closeSocket(socket);
        }
        try {
            socket.close();
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        try {
            this.getRequest().onCloseConnection();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        if (log.isLoggable(Level.FINER)) {
            if (port != null) {
                log.finer(this.dbgId() + "closing connection " + this + ", total=" + port.getConnectionCount());
            } else {
                log.finer(this.dbgId() + "closing connection " + this);
            }
        }
    }

    private void closeAsyncIfNotAsync() {
        SocketLinkState state = this._state;
        if (state.isComet() || state.isDuplex()) {
            return;
        }
        this.closeAsync();
    }

    private void closeAsync() {
        DuplexReadTask duplexTask = this._duplexReadTask;
        this._duplexReadTask = null;
        TcpAsyncController async = this._async;
        this._async = null;
        if (async != null) {
            ((AsyncController)async).onClose();
            ((AsyncController)async).close();
        }
        if (duplexTask != null) {
            duplexTask.onClose();
        }
    }

    private String dbgId() {
        if (this._dbgId == null) {
            Object serverId = Environment.getAttribute("caucho.server-id");
            this._dbgId = serverId != null ? this.getClass().getSimpleName() + "[id=" + this.getId() + "," + serverId + "] " : this.getClass().getSimpleName() + "[id=" + this.getId() + "] ";
        }
        return this._dbgId;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this._id + "," + this._port.toURL() + "," + (Object)((Object)this._state) + "]";
    }

    static enum Task {
        ACCEPT,
        KEEPALIVE;

    }
}

