/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.mysql;

import com.caucho.quercus.lib.db.QuercusResultSetMetaData;
import com.caucho.quercus.mysql.MysqlColumn;
import com.caucho.util.L10N;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

public class MysqlResultSetMetaData
implements QuercusResultSetMetaData {
    private static final Logger log = Logger.getLogger(MysqlResultSetMetaData.class.getName());
    private static final L10N L = new L10N(MysqlResultSetMetaData.class);
    private int _columnCount;
    private ArrayList<MysqlColumn> _columns = new ArrayList();

    MysqlResultSetMetaData() {
    }

    public int getColumnCount() {
        return this._columnCount;
    }

    public void setColumnCount(int columnCount) {
        this._columnCount = columnCount;
        while (this._columns.size() < columnCount) {
            this._columns.add(new MysqlColumn());
        }
    }

    public ArrayList<MysqlColumn> getColumns() {
        return this._columns;
    }

    public MysqlColumn getColumn(int column) {
        if (column < 1 || this._columnCount < column) {
            throw new IllegalArgumentException(L.l("{0} is an invalid column [1-{1}]", column, this._columnCount));
        }
        return this._columns.get(column - 1);
    }

    public boolean isAutoIncrement(int column) {
        return this.getColumn(column).isAutoIncrement();
    }

    public boolean isCaseSensitive(int column) {
        return true;
    }

    public boolean isSearchable(int column) {
        return false;
    }

    public boolean isCurrency(int column) {
        return false;
    }

    public int isNullable(int column) {
        if (this.getColumn(column).isNotNull()) {
            return 0;
        }
        return 1;
    }

    public int getColumnDisplaySize(int column) {
        return this.getColumn(column).getPrecision();
    }

    public String getColumnLabel(int column) {
        return this.getColumnName(column);
    }

    public String getColumnName(int column) {
        return this.getColumn(column).getName();
    }

    public String getColumnOrigName(int column) {
        return this.getColumn(column).getOrigName();
    }

    public String getColumnSchema(int column) {
        return this.getColumn(column).getSchema();
    }

    public boolean isSigned(int column) {
        return !this.getColumn(column).isUnsigned();
    }

    public int getPrecision(int column) {
        return this.getColumn(column).getPrecision();
    }

    public int getScale(int column) {
        return this.getColumn(column).getScale();
    }

    public String getSchemaName(int column) {
        return this.getColumn(column).getSchema();
    }

    public String getTableName(int column) {
        return this.getColumn(column).getTable();
    }

    public String getOrigTableName(int column) {
        return this.getColumn(column).getOrigTable();
    }

    public String getCatalogName(int column) {
        return this.getColumn(column).getCatalog();
    }

    public int getColumnType(int column) {
        return this.getColumn(column).getSQLType();
    }

    public String getColumnTypeName(int column) {
        return this.getColumn(column).getTypeName();
    }

    public boolean isReadOnly(int column) {
        throw new UnsupportedOperationException();
    }

    public boolean isWritable(int column) {
        throw new UnsupportedOperationException();
    }

    public boolean isDefinitelyWritable(int column) {
        throw new UnsupportedOperationException();
    }

    public String getColumnClassName(int column) {
        throw new UnsupportedOperationException();
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isBlob(int column) {
        return this.getColumn(column).isBlob();
    }

    public boolean isMultipleKey(int column) {
        return this.getColumn(column).isMultipleKey();
    }

    public boolean isZeroFill(int column) {
        return this.getColumn(column).isZeroFill();
    }

    public boolean isUnsigned(int column) {
        return this.getColumn(column).isUnsigned();
    }

    public boolean isUniqueKey(int column) {
        return this.getColumn(column).isUniqueKey();
    }

    public boolean isPrimaryKey(int column) {
        return this.getColumn(column).isPrimaryKey();
    }

    public boolean isNotNull(int column) {
        return this.getColumn(column).isNotNull();
    }

    public int getLength(int column) {
        return this.getColumn(column).getLength();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

