/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.relaxng;

import com.caucho.config.ConfigException;
import com.caucho.relaxng.RelaxException;
import com.caucho.relaxng.pattern.AnyNamePattern;
import com.caucho.relaxng.pattern.AttributePattern;
import com.caucho.relaxng.pattern.ChoiceNamePattern;
import com.caucho.relaxng.pattern.ChoicePattern;
import com.caucho.relaxng.pattern.DataPattern;
import com.caucho.relaxng.pattern.ElementPattern;
import com.caucho.relaxng.pattern.EmptyPattern;
import com.caucho.relaxng.pattern.ExcludeNamePattern;
import com.caucho.relaxng.pattern.GrammarPattern;
import com.caucho.relaxng.pattern.GroupPattern;
import com.caucho.relaxng.pattern.InterleavePattern;
import com.caucho.relaxng.pattern.NameClassPattern;
import com.caucho.relaxng.pattern.NamePattern;
import com.caucho.relaxng.pattern.NsNamePattern;
import com.caucho.relaxng.pattern.Pattern;
import com.caucho.relaxng.pattern.RefPattern;
import com.caucho.relaxng.pattern.TextPattern;
import com.caucho.relaxng.pattern.ZeroOrMorePattern;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.xml.QName;
import java.util.ArrayList;
import java.util.HashMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RelaxBuilder
extends DefaultHandler {
    private static final String RELAX_S = "http://relaxng.org/ns/structure/1.0";
    private static final L10N L = new L10N(RelaxBuilder.class);
    private GrammarPattern _rootGrammar;
    private GrammarPattern _grammar;
    private Pattern _pattern;
    private String _ns = "";
    private HashMap<String, String> _nsMap = new HashMap();
    private CharBuffer _cb = new CharBuffer();
    private ArrayList<Pattern> _patternStack = new ArrayList();
    private ArrayList<String> _nsStack = new ArrayList();
    private ArrayList<HashMap<String, String>> _nsMapStack = new ArrayList();

    RelaxBuilder() {
    }

    public GrammarPattern getGrammar() {
        return this._rootGrammar;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this._nsMapStack.add(this._nsMap);
        this._nsMap = new HashMap<String, String>(this._nsMap);
        this._nsMap.put(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this._nsMapStack.add(this._nsMap);
        this._nsMap = this._nsMapStack.remove(this._nsMapStack.size() - 1);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        this._cb.clear();
        try {
            if (RELAX_S.equals(uri)) {
                this._patternStack.add(this._pattern);
                this._nsStack.add(this._ns);
                String ns = attrs.getValue("ns");
                if (ns != null) {
                    this._ns = ns;
                }
                if (localName.equals("grammar")) {
                    this._grammar = new GrammarPattern();
                    if (this._rootGrammar == null) {
                        this._rootGrammar = this._grammar;
                    }
                    this._pattern = null;
                } else if (localName.equals("start")) {
                    if (this._pattern != null || this._grammar == null) {
                        throw new RelaxException("<start> must be a direct child of <grammar>.");
                    }
                    this._pattern = new GroupPattern();
                    this._grammar.setStart(this._pattern);
                } else if (localName.equals("define")) {
                    if (this._pattern != null || this._grammar == null) {
                        throw new RelaxException("<define> must be a direct child of <grammar>.");
                    }
                    String name = attrs.getValue("name");
                    if (name == null || name.equals("")) {
                        throw new RelaxException(L.l("<define> requires a `name' attribute."));
                    }
                    this._pattern = new GroupPattern();
                    this._grammar.setDefinition(name, this._pattern);
                } else if (localName.equals("name")) {
                    if (this._pattern == null) {
                        throw new RelaxException("<name> must be child of <element> or <attribute>.");
                    }
                    this._pattern = null;
                } else if (localName.equals("nsName")) {
                    if (this._pattern == null) {
                        throw new RelaxException("<nsName> must be child of <element> or <attribute>.");
                    }
                    this._pattern = new NsNamePattern();
                } else if (localName.equals("anyName")) {
                    if (this._pattern == null) {
                        throw new RelaxException("<anyName> must be child of <element> or <attribute>.");
                    }
                    this._pattern = new AnyNamePattern();
                } else if (localName.equals("except")) {
                    if (this._pattern == null) {
                        throw new RelaxException("<except> must be child of <nsName> or <anyName>.");
                    }
                    this._pattern = new ExcludeNamePattern();
                } else {
                    if (this._grammar == null) {
                        this._rootGrammar = this._grammar = new GrammarPattern();
                        this._pattern = new GroupPattern();
                        this._grammar.setStart(this._pattern);
                        this._patternStack.set(this._patternStack.size() - 1, this._pattern);
                    }
                    Pattern child = null;
                    if (localName.equals("element")) {
                        String name = attrs.getValue("name");
                        String defName = this._grammar.generateId();
                        child = new ElementPattern(defName);
                        if (name != null) {
                            QName eltQName = this.getName(name);
                            child.addNameChild(new NamePattern(eltQName));
                        }
                        if (name != null) {
                            QName attrQName = this.getName(name);
                            child.addNameChild(new NamePattern(attrQName));
                        }
                        this._grammar.setDefinition(defName, child);
                    } else if (localName.equals("attribute")) {
                        String name = attrs.getValue("name");
                        child = new AttributePattern();
                        if (name != null) {
                            QName attrQName = new QName(name, this._ns);
                            child.addNameChild(new NamePattern(attrQName));
                        }
                    } else if (localName.equals("empty")) {
                        child = new EmptyPattern();
                    } else if (localName.equals("text")) {
                        child = new TextPattern();
                    } else if (localName.equals("data")) {
                        String type = attrs.getValue("type");
                        if (type == null) {
                            throw new RelaxException(L.l("<data> requires a `type' attribute."));
                        }
                        child = new DataPattern(type);
                    } else if (localName.equals("value")) {
                        child = new DataPattern("string");
                    } else if (localName.equals("choice")) {
                        AttributePattern attrPattern;
                        ElementPattern eltPattern;
                        if (this._pattern instanceof ElementPattern && (eltPattern = (ElementPattern)this._pattern).getNameChild() == null) {
                            child = new ChoiceNamePattern();
                            eltPattern.addNameChild((NameClassPattern)child);
                            this._pattern = child;
                            return;
                        }
                        if (this._pattern instanceof AttributePattern && (attrPattern = (AttributePattern)this._pattern).getNameChild() == null) {
                            child = new ChoiceNamePattern();
                            attrPattern.addNameChild((NameClassPattern)child);
                            this._pattern = child;
                            return;
                        }
                        child = new ChoicePattern();
                    } else if (localName.equals("group")) {
                        child = new GroupPattern();
                    } else if (localName.equals("interleave")) {
                        child = new InterleavePattern();
                    } else if (localName.equals("zeroOrMore")) {
                        child = new ZeroOrMorePattern();
                    } else if (localName.equals("oneOrMore")) {
                        child = new ZeroOrMorePattern();
                    } else {
                        if (localName.equals("optional")) {
                            ChoicePattern choice = new ChoicePattern();
                            ((Pattern)choice).addChild(new EmptyPattern());
                            choice.setParent(this._pattern);
                            GroupPattern group = new GroupPattern();
                            group.setParent(choice);
                            ((Pattern)choice).addChild(group);
                            this._pattern = group;
                            return;
                        }
                        if (localName.equals("ref")) {
                            String name = attrs.getValue("name");
                            if (name == null || name.equals("")) {
                                throw new RelaxException(L.l("<define> requires a `name' attribute."));
                            }
                            child = new RefPattern(this._grammar, name);
                        } else {
                            throw new ConfigException(L.l("<{0}> is an unknown relax element.", (Object)localName));
                        }
                    }
                    child.setParent(this._pattern);
                    if (child.getElementName() == null) {
                        child.setElementName(this._pattern.getElementName());
                    }
                    this._pattern = child;
                }
            }
        }
        catch (Exception e) {
            throw new SAXException(this.getLocation() + e.getMessage(), e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this._cb.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if (RELAX_S.equals(uri)) {
                NameClassPattern nameChild = null;
                Pattern child = this._pattern;
                String ns = this._ns;
                this._pattern = this._patternStack.remove(this._patternStack.size() - 1);
                this._ns = this._nsStack.remove(this._nsStack.size() - 1);
                if (localName.equals("name")) {
                    nameChild = new NamePattern(this.getName(this._cb.toString()));
                    if (this._pattern != null) {
                        this._pattern.addNameChild(nameChild);
                    }
                } else if (localName.equals("nsName")) {
                    NsNamePattern nsName = (NsNamePattern)child;
                    nsName.setNamespace(ns);
                    if (this._pattern != null) {
                        this._pattern.addNameChild(nsName);
                    }
                } else if (localName.equals("anyName")) {
                    nameChild = (AnyNamePattern)child;
                    if (this._pattern != null) {
                        this._pattern.addNameChild(nameChild);
                    }
                } else if (localName.equals("except")) {
                    ExcludeNamePattern exclude = (ExcludeNamePattern)child;
                    if (this._pattern instanceof NsNamePattern) {
                        NsNamePattern nsPattern = (NsNamePattern)this._pattern;
                        nsPattern.setExcept(exclude.getNameChild());
                    }
                    if (this._pattern instanceof AnyNamePattern) {
                        AnyNamePattern anyNamePattern = (AnyNamePattern)this._pattern;
                        anyNamePattern.setExcept(exclude.getNameChild());
                    }
                } else if (localName.equals("optional")) {
                    if (this._pattern != null) {
                        this._pattern.addChild(child.getParent());
                    }
                } else if (localName.equals("oneOrMore")) {
                    ZeroOrMorePattern starPattern = (ZeroOrMorePattern)child;
                    Pattern subPattern = starPattern.getPatterns();
                    GroupPattern group = new GroupPattern();
                    ((Pattern)group).addChild(subPattern);
                    ((Pattern)group).addChild(starPattern);
                    if (this._pattern != null) {
                        this._pattern.addChild(group);
                    }
                } else if (!(child instanceof NameClassPattern)) {
                    if (child != null) {
                        child.endElement();
                    }
                    if (this._pattern != null) {
                        this._pattern.addChild(child);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new SAXException(this.getLocation() + e.getMessage(), e);
        }
    }

    private QName getName(String name) {
        int p = name.lastIndexOf(58);
        if (p > 0) {
            String prefix = name.substring(0, p);
            String ns = this._nsMap.get(prefix);
            if (ns != null) {
                return new QName(name, ns);
            }
            return new QName(name, this._ns);
        }
        return new QName(name, this._ns);
    }

    public String getLocation() {
        return "";
    }
}

