/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.remote.websocket;

import com.caucho.remote.websocket.FrameInputStream;
import com.caucho.remote.websocket.UnmaskedFrameInputStream;
import com.caucho.remote.websocket.WebSocketBlockingQueue;
import com.caucho.remote.websocket.WebSocketConstants;
import com.caucho.remote.websocket.WebSocketInputStream;
import com.caucho.remote.websocket.WebSocketOutputStream;
import com.caucho.remote.websocket.WebSocketPrintWriter;
import com.caucho.remote.websocket.WebSocketProtocolException;
import com.caucho.remote.websocket.WebSocketWriter;
import com.caucho.util.Base64;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import com.caucho.websocket.WebSocketContext;
import com.caucho.websocket.WebSocketEncoder;
import com.caucho.websocket.WebSocketListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.cert.X509Certificate;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class WebSocketClient
implements WebSocketContext,
WebSocketConstants {
    private static final Logger log = Logger.getLogger(WebSocketClient.class.getName());
    private static final L10N L = new L10N(WebSocketClient.class);
    private String _url;
    private String _scheme;
    private String _host;
    private int _port;
    private String _path;
    private long _connectTimeout;
    private String _virtualHost;
    private boolean _isMasked;
    private WebSocketListener _listener;
    private Socket _s;
    private ReadStream _is;
    private WriteStream _os;
    private boolean _isClosed;
    private ClientContext _context;
    private FrameInputStream _frameIs;
    private WebSocketInputStream _wsIs;
    private WebSocketOutputStream _wsOs;
    private WebSocketWriter _wsWriter;

    public WebSocketClient(String url, WebSocketListener listener) {
        this.setUrl(url);
        this._listener = listener;
        if (url == null) {
            throw new IllegalArgumentException();
        }
        if (this._listener == null) {
            throw new IllegalArgumentException();
        }
    }

    private void setUrl(String url) {
        this._url = url;
        this.parseUrl(url);
    }

    public void setVirtualHost(String virtualHost) {
        this._virtualHost = virtualHost;
    }

    public void setConnectTimeout(long timeout) {
        this._connectTimeout = timeout;
    }

    public void setMasked(boolean isMasked) {
        this._isMasked = isMasked;
    }

    public void connect() throws IOException {
        this.connect(null, null);
    }

    public void connect(String userName, String password) throws IOException {
        if (this._s != null) {
            return;
        }
        this.connectImpl(userName, password);
    }

    private void parseUrl(String url) {
        String server;
        int p = url.indexOf("://");
        if (p < 0) {
            throw new IllegalArgumentException(L.l("'{0}' is an illegal URL because it is missing a scheme", (Object)url));
        }
        this._scheme = url.substring(0, p);
        int q = url.indexOf(47, p + 3);
        if (q < 0) {
            server = url.substring(p + 3);
            this._path = "/";
        } else {
            server = url.substring(p + 3, q);
            this._path = url.substring(q);
        }
        p = server.indexOf(58);
        if (p < 0) {
            this._host = server;
            this._port = "https".equals(this._scheme) ? 443 : 80;
        } else {
            this._host = server.substring(0, p);
            this._port = Integer.parseInt(server.substring(p + 1));
        }
    }

    protected void connectImpl(String userName, String password) throws IOException {
        if (this._listener == null) {
            throw new IllegalStateException("missing websocket listener");
        }
        int connectTimeout = (int)this._connectTimeout;
        this._s = new Socket();
        if (connectTimeout > 0) {
            this._s.connect(new InetSocketAddress(this._host, this._port), connectTimeout);
        } else {
            this._s.connect(new InetSocketAddress(this._host, this._port));
        }
        if ("https".equals(this._scheme)) {
            this._s = this.openSsl(this._s);
        }
        this._is = VfsStream.openRead(this._s.getInputStream());
        this._os = VfsStream.openWrite(this._s.getOutputStream());
        this._os.print("GET " + this._path + " HTTP/1.1\r\n");
        if (this._virtualHost != null) {
            this._os.print("Host: " + this._virtualHost + "\r\n");
        } else if (this._host != null) {
            this._os.print("Host: " + this._host + "\r\n");
        } else {
            this._os.print("Host: localhost\r\n");
        }
        byte[] clientNonce = new byte[16];
        String key = Base64.encode(clientNonce);
        this._os.print("Sec-WebSocket-Key: " + key + "\r\n");
        String version = "13";
        this._os.print("Sec-WebSocket-Version: " + version + "\r\n");
        if (!this._isMasked) {
            this._os.print("Sec-WebSocket-Extensions: x-unmasked\r\n");
        }
        this._os.print("Upgrade: WebSocket\r\n");
        this._os.print("Connection: Upgrade\r\n");
        this._os.print("\r\n");
        this._os.flush();
        this.parseHeaders(this._is);
        this._frameIs = new UnmaskedFrameInputStream();
        this._frameIs.init(this, this._is);
        this._os.flush();
        this._context = new ClientContext();
        this._listener.onStart(this);
        Thread thread = new Thread(this._context);
        thread.setDaemon(true);
        thread.start();
    }

    private Socket openSsl(Socket s) throws ConnectException {
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] cert, String foo) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] cert, String foo) {
                }
            };
            context.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory factory = context.getSocketFactory();
            return factory.createSocket(s, this._host, this._port, true);
        }
        catch (ConnectException e) {
            throw new ConnectException("SSL " + this._host + ":" + this._port + ": " + e.getMessage());
        }
        catch (Exception e) {
            throw new ConnectException("SSL " + this._host + ":" + this._port + ": " + e.toString());
        }
    }

    protected void parseHeaders(ReadStream in) throws IOException {
        String line;
        String status = in.readln();
        if (status == null) {
            throw new WebSocketProtocolException(L.l("Unexpected connection close", (Object)status));
        }
        if (!status.startsWith("HTTP")) {
            throw new WebSocketProtocolException(L.l("Unexpected response {0}", (Object)status));
        }
        while ((line = in.readln()) != null && line.length() != 0) {
            int p = line.indexOf(58);
            if (p <= 0) continue;
            String header = line.substring(0, p).trim();
            String string = line.substring(p + 1).trim();
        }
        if (!status.startsWith("HTTP/1.1 101")) {
            int ch;
            StringBuilder sb = new StringBuilder();
            while (in.available() > 0 && (ch = in.read()) >= 0) {
                sb.append((char)ch);
            }
            throw new WebSocketProtocolException(L.l("Unexpected response {0}\n\n{1}", (Object)status, (Object)sb));
        }
    }

    @Override
    public void disconnect() {
        WriteStream os = this._os;
        try {
            if (os != null) {
                ((OutputStream)os).close();
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    @Override
    public <T> BlockingQueue<T> createOutputQueue(WebSocketEncoder<T> encoder) {
        return new WebSocketBlockingQueue<T>(this, encoder, 256);
    }

    @Override
    public void setAutoFlush(boolean isAutoFlush) {
    }

    @Override
    public boolean isAutoFlush() {
        return false;
    }

    @Override
    public void flush() throws IOException {
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    @Override
    public void close() {
        this.close(1000, "ok");
    }

    @Override
    public void close(int code, String msg) {
        this._isClosed = true;
        WriteStream os = this._os;
        this._os = null;
        ReadStream is = this._is;
        this._is = null;
        Socket s = this._s;
        this._s = null;
        try {
            if (os != null) {
                ((OutputStream)os).close();
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        try {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        try {
            if (s != null) {
                s.close();
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public InputStream getInputStream() {
        return this._is;
    }

    @Override
    public OutputStream startBinaryMessage() throws IOException {
        if (this._wsOs == null) {
            WriteStream os = this._os;
            if (os == null) {
                throw new IllegalStateException(L.l("startBinaryMessage cannot be called with a closed context"));
            }
            this._wsOs = new WebSocketOutputStream(os, new byte[4096]);
        }
        this._wsOs.init();
        return this._wsOs;
    }

    @Override
    public PrintWriter startTextMessage() throws IOException {
        if (this._wsWriter == null) {
            WriteStream os = this._os;
            if (os == null) {
                throw new IllegalStateException(L.l("startTextMessage cannot be called with a closed context"));
            }
            this._wsWriter = new WebSocketWriter(os, new byte[4096]);
        }
        this._wsWriter.init();
        return new WebSocketPrintWriter(this._wsWriter);
    }

    @Override
    public long getTimeout() {
        return 0L;
    }

    @Override
    public void setTimeout(long timeout) {
    }

    @Override
    public void pong(byte[] message) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._url + "]";
    }

    @Override
    public void onClose(int closeCode, String closeMessage) {
    }

    class ClientContext
    implements Runnable {
        ClientContext() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread thread = Thread.currentThread();
            String name = thread.getName();
            try {
                thread.setName("web-socket-client");
                this.handleRequests();
            }
            catch (Exception e) {
                if (WebSocketClient.this._isClosed) {
                    log.log(Level.FINEST, e.toString(), e);
                } else {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            finally {
                try {
                    WebSocketClient.this._listener.onDisconnect(WebSocketClient.this);
                }
                catch (IOException e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
                WebSocketClient.this.close(1000, "");
                thread.setName(name);
            }
        }

        public void handleRequests() throws IOException {
            FrameInputStream is = WebSocketClient.this._frameIs;
            block6: while (is.readFrameHeader()) {
                int op = is.getOpcode();
                switch (op) {
                    case 2: {
                        if (WebSocketClient.this._wsIs == null) {
                            WebSocketClient.this._wsIs = new WebSocketInputStream(is);
                        }
                        WebSocketClient.this._wsIs.init();
                        try {
                            WebSocketClient.this._listener.onReadBinary(WebSocketClient.this, WebSocketClient.this._wsIs);
                            continue block6;
                        }
                        finally {
                            WebSocketClient.this._wsIs.close();
                            continue block6;
                        }
                    }
                    default: {
                        throw new IllegalStateException("Unknown WebSocket opcode 0x" + Integer.toHexString(op));
                    }
                }
            }
        }
    }
}

