/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.rewrite;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.rewrite.AbstractRegexpDispatchRule;
import com.caucho.server.dispatch.ForwardAbsoluteFilterChain;
import com.caucho.server.dispatch.ForwardFilterChain;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import java.util.regex.Matcher;
import javax.servlet.DispatcherType;
import javax.servlet.FilterChain;

@Configurable
public class Forward
extends AbstractRegexpDispatchRule {
    private static final L10N L = new L10N(Forward.class);
    private String _target;
    private boolean _isAbsolute;

    @Configurable
    public void setTarget(String target) {
        this._target = target;
    }

    @Configurable
    public void setAbsoluteTarget(String target) {
        this.setTarget(target);
        this._isAbsolute = true;
    }

    @Configurable
    public void setTargetHost(String target) {
    }

    @Override
    protected String rewriteTarget(Matcher matcher, String uri, String queryString) {
        queryString = null;
        if (this._target != null) {
            uri = matcher.replaceAll(this._target);
        }
        return super.rewriteTarget(matcher, uri, queryString);
    }

    public void init() throws ConfigException {
        if (this._target == null) {
            throw new ConfigException(L.l("'target' is a required attribute of '{0}' because Resin needs to know the destination URL.", (Object)this.getClass().getSimpleName()));
        }
    }

    @Override
    public FilterChain createDispatch(DispatcherType type, String uri, String queryString, String target, FilterChain next) {
        if (this._isAbsolute) {
            return new ForwardAbsoluteFilterChain(target, WebApp.getCurrent());
        }
        return new ForwardFilterChain(target);
    }
}

