/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.security.AbstractAuthenticator;
import com.caucho.security.Authenticator;
import com.caucho.security.Login;
import com.caucho.security.LoginException;
import com.caucho.security.NullAuthenticator;
import com.caucho.security.SingleSignon;
import com.caucho.server.session.SessionImpl;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.security.Principal;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class AbstractLogin
implements Login {
    private static final Logger log = Logger.getLogger(AbstractLogin.class.getName());
    protected Authenticator _auth;
    protected SingleSignon _singleSignon;
    @Inject
    private Instance<Authenticator> _authInstance;
    @Inject
    private Instance<SingleSignon> _signonInstance;
    private boolean _isSessionSaveLogin = true;
    private boolean _isLogoutOnTimeout = true;

    protected AbstractLogin() {
    }

    public void setAuthenticator(Authenticator auth) {
        this._auth = auth;
    }

    @Override
    public Authenticator getAuthenticator() {
        if (this._auth == null) {
            if (!this._authInstance.isUnsatisfied()) {
                this._auth = (Authenticator)this._authInstance.get();
            }
            if (this._auth == null) {
                this._auth = new NullAuthenticator();
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.toString() + " using " + this._auth);
            }
        }
        return this._auth;
    }

    protected SingleSignon getSingleSignon() {
        if (this._singleSignon == null) {
            Authenticator auth = this.getAuthenticator();
            if (this._auth instanceof AbstractAuthenticator) {
                AbstractAuthenticator abstractAuth = (AbstractAuthenticator)auth;
                this._singleSignon = abstractAuth.getSingleSignon();
            }
        }
        return this._singleSignon;
    }

    public boolean isLogoutOnSessionTimeout() {
        return this._isLogoutOnTimeout;
    }

    public void setLogoutOnSessionTimeout(boolean logout) {
        this._isLogoutOnTimeout = logout;
    }

    public void setSessionSaveLogin(boolean isSave) {
        this._isSessionSaveLogin = isSave;
    }

    public boolean isSessionSaveLogin() {
        return this._isSessionSaveLogin;
    }

    @PostConstruct
    public void init() throws ServletException {
        if (this._singleSignon == null && !this._signonInstance.isUnsatisfied()) {
            this._singleSignon = (SingleSignon)this._signonInstance.get();
        }
    }

    @Override
    public String getAuthType() {
        return "none";
    }

    @Override
    public boolean isLoginUsedForRequest(HttpServletRequest request) {
        return true;
    }

    @Override
    public Principal getUserPrincipal(HttpServletRequest request) {
        return this.getUserPrincipal(request, false);
    }

    private Principal getUserPrincipal(HttpServletRequest request, boolean isLogin) {
        Principal savedUser;
        Principal user = (Principal)request.getAttribute("caucho.user");
        if (user != null) {
            if (user != AbstractAuthenticator.NULL_USER) {
                return user;
            }
            if (!isLogin) {
                return null;
            }
        }
        if ((savedUser = this.findSavedUser(request)) != null && this.isSavedUserValid(request, savedUser)) {
            request.setAttribute("caucho.user", (Object)savedUser);
            return savedUser;
        }
        user = isLogin ? this.getLoginPrincipalImpl(request) : this.getUserPrincipalImpl(request);
        if (user != null) {
            request.setAttribute("caucho.user", (Object)user);
            this.saveUser(request, user);
        } else if (savedUser != null) {
            request.setAttribute("caucho.user", (Object)AbstractAuthenticator.NULL_USER);
            this.saveUser(request, null);
        } else {
            request.setAttribute("caucho.user", (Object)AbstractAuthenticator.NULL_USER);
        }
        return user;
    }

    @Override
    public Principal login(HttpServletRequest request, HttpServletResponse response, boolean isFail) {
        try {
            Principal savedUser = null;
            savedUser = this.findSavedUser(request);
            if (savedUser != null && this.isSavedUserValid(request, savedUser)) {
                request.setAttribute("caucho.user", (Object)savedUser);
                return savedUser;
            }
            Principal user = this.login(request, response);
            if (user != null || savedUser != null) {
                this.saveUser(request, user);
            }
            if (user != null) {
                this.loginSuccessResponse(user, request, response);
                return user;
            }
            if (isFail) {
                log.fine(this + " sending login challenge");
                this.loginChallenge(request, response);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LoginException(e);
        }
        return null;
    }

    protected Principal login(HttpServletRequest request, HttpServletResponse response) {
        return this.getUserPrincipal(request, true);
    }

    protected Principal findSavedUser(HttpServletRequest request) {
        SingleSignon singleSignon = this.getSingleSignon();
        SessionImpl session = (SessionImpl)request.getSession(false);
        String sessionId = session != null ? session.getId() : request.getRequestedSessionId();
        if (sessionId == null) {
            return null;
        }
        if (singleSignon != null) {
            Principal user = singleSignon.get(sessionId);
            if (user != null && log.isLoggable(Level.FINER)) {
                log.finer(this + " load user '" + user + "' from " + singleSignon);
            }
            return user;
        }
        if (this.isSessionSaveLogin() && session != null) {
            Principal user = (Principal)session.getAttribute("caucho.user");
            if (user != null && log.isLoggable(Level.FINER)) {
                log.finer(this + " load user '" + user + "' from session");
            }
            return user;
        }
        return null;
    }

    protected void saveUser(HttpServletRequest request, Principal user) {
        SingleSignon singleSignon = this.getSingleSignon();
        SessionImpl session = this.isSessionSaveLogin() ? (SessionImpl)request.getSession(true) : (SessionImpl)request.getSession(false);
        String sessionId = session != null ? session.getId() : request.getRequestedSessionId();
        if (sessionId != null) {
            if (singleSignon != null) {
                singleSignon.put(sessionId, user);
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " save user '" + user + "' in single signon " + singleSignon);
                }
            } else if (this.isSessionSaveLogin()) {
                session.setAttribute("caucho.user", user);
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " save user '" + user + "' in session " + session);
                }
            }
        }
    }

    @Override
    public boolean isPasswordBased() {
        return false;
    }

    protected Principal getUserPrincipalImpl(HttpServletRequest request) {
        return null;
    }

    protected boolean isSavedUserValid(HttpServletRequest request, Principal savedUser) {
        return true;
    }

    protected Principal getLoginPrincipalImpl(HttpServletRequest request) {
        return this.getUserPrincipalImpl(request);
    }

    protected void loginChallenge(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    protected void loginSuccessResponse(Principal user, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    @Override
    public boolean isUserInRole(Principal user, String role) {
        return this.getAuthenticator().isUserInRole(user, role);
    }

    @Override
    public void logout(Principal user, HttpServletRequest request, HttpServletResponse response) {
        String sessionId = request.getRequestedSessionId();
        this.logoutImpl(user, request, response);
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.removeAttribute("caucho.user");
        }
        request.removeAttribute("caucho.user");
        SingleSignon singleSignon = this.getSingleSignon();
        if (singleSignon != null) {
            singleSignon.remove(sessionId);
        }
    }

    @Override
    public void sessionInvalidate(HttpSession session, boolean isTimeout) {
        SingleSignon singleSignon;
        if (session != null && (singleSignon = this.getSingleSignon()) != null && (!isTimeout || this.isLogoutOnSessionTimeout())) {
            singleSignon.remove(session.getId());
        }
    }

    protected void logoutImpl(Principal user, HttpServletRequest request, HttpServletResponse response) {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }

    static class LoginPrincipal
    implements Serializable {
        private Principal _user;

        LoginPrincipal(Principal user) {
            this._user = user;
        }

        public Principal getUser() {
            return this._user;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._user + "]";
        }
    }

    static class PrincipalEntry {
        private Principal _principal;
        private ArrayList<SoftReference<SessionImpl>> _sessions;

        PrincipalEntry(Principal principal) {
            this._principal = principal;
        }

        Principal getPrincipal() {
            return this._principal;
        }

        void addSession(SessionImpl session) {
            if (this._sessions == null) {
                this._sessions = new ArrayList();
            }
            this._sessions.add(new SoftReference<SessionImpl>(session));
        }

        boolean logout(HttpSession timeoutSession) {
            ArrayList<SoftReference<SessionImpl>> sessions = this._sessions;
            if (sessions == null) {
                return true;
            }
            boolean isEmpty = true;
            for (int i = sessions.size() - 1; i >= 0; --i) {
                SoftReference<SessionImpl> ref = sessions.get(i);
                SessionImpl session = ref.get();
                try {
                    if (session == timeoutSession) {
                        sessions.remove(i);
                        continue;
                    }
                    if (session == null) {
                        sessions.remove(i);
                        continue;
                    }
                    isEmpty = false;
                    continue;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            return isEmpty;
        }

        void logout() {
            ArrayList<SoftReference<SessionImpl>> sessions = this._sessions;
            this._sessions = null;
            for (int i = 0; sessions != null && i < sessions.size(); ++i) {
                SoftReference<SessionImpl> ref = sessions.get(i);
                SessionImpl session = ref.get();
                try {
                    if (session == null) continue;
                    session.invalidateLogout();
                    continue;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        }
    }
}

