/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.admin;

import com.caucho.bam.ErrorPacketException;
import com.caucho.bam.RemoteConnectionFailedException;
import com.caucho.bam.RemoteListenerUnavailableException;
import com.caucho.bam.ServiceUnavailableException;
import com.caucho.bam.actor.ActorSender;
import com.caucho.bam.actor.RemoteActorSender;
import com.caucho.bam.manager.BamManager;
import com.caucho.bam.manager.SimpleBamManager;
import com.caucho.hmtp.HmtpClient;
import com.caucho.server.admin.AddUserQuery;
import com.caucho.server.admin.AddUserQueryReply;
import com.caucho.server.admin.HeapDumpQuery;
import com.caucho.server.admin.HmuxClientFactory;
import com.caucho.server.admin.JmxCallQuery;
import com.caucho.server.admin.JmxCallQueryReply;
import com.caucho.server.admin.JmxDumpQuery;
import com.caucho.server.admin.JmxListQuery;
import com.caucho.server.admin.JmxSetQuery;
import com.caucho.server.admin.JmxSetQueryReply;
import com.caucho.server.admin.JsonQueryReply;
import com.caucho.server.admin.LicenseAddQuery;
import com.caucho.server.admin.ListJmxQueryReply;
import com.caucho.server.admin.ListRestartsQuery;
import com.caucho.server.admin.ListUsersQuery;
import com.caucho.server.admin.ListUsersQueryReply;
import com.caucho.server.admin.LogLevelQuery;
import com.caucho.server.admin.ManagerProxyApi;
import com.caucho.server.admin.PdfReportQuery;
import com.caucho.server.admin.PdfReportQueryReply;
import com.caucho.server.admin.ProfileQuery;
import com.caucho.server.admin.RemoveUserQuery;
import com.caucho.server.admin.RemoveUserQueryReply;
import com.caucho.server.admin.ScoreboardQuery;
import com.caucho.server.admin.ServerStatusQuery;
import com.caucho.server.admin.ServerStatusWebAppQuery;
import com.caucho.server.admin.StatServiceValuesQueryReply;
import com.caucho.server.admin.StatsQuery;
import com.caucho.server.admin.StringQueryReply;
import com.caucho.server.admin.ThreadDumpQuery;
import com.caucho.server.cluster.ServletService;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ManagerClient {
    private static final Logger log = Logger.getLogger(ManagerClient.class.getName());
    private static final L10N L = new L10N(ManagerClient.class);
    private static final long MANAGER_TIMEOUT = 600000L;
    private BamManager _bamManager;
    private String _url;
    private ActorSender _bamClient;
    private String _managerAddress;
    private ManagerProxyApi _managerProxy;

    public ManagerClient() {
        ServletService server = ServletService.getCurrent();
        if (server == null) {
            throw new IllegalStateException(L.l("ManagerClient was not called in a Resin context. For external clients, use the ManagerClient constructor with host,port arguments."));
        }
        this._bamManager = server.getBamManager();
        this._bamClient = server.createAdminClient(this.getClass().getSimpleName());
        this._managerAddress = "manager@resin.caucho";
        this.initImpl();
    }

    public ManagerClient(String serverId) {
        ServletService server = ServletService.getCurrent();
        if (server == null) {
            throw new IllegalStateException(L.l("ManagerClient was not called in a Resin context. For external clients, use the ManagerClient constructor with host,port arguments."));
        }
        this._bamManager = server.getBamManager();
        this._bamClient = server.createAdminClient(this.getClass().getSimpleName());
        this._managerAddress = "manager@" + serverId + ".resin.caucho";
        this.initImpl();
    }

    public ManagerClient(ActorSender bamClient) {
        this(new SimpleBamManager(bamClient.getBroker()), bamClient);
    }

    public ManagerClient(BamManager bamManager, ActorSender bamClient) {
        this._bamManager = bamManager;
        this._bamClient = bamClient;
        this._managerAddress = "manager@resin.caucho";
        this.initImpl();
    }

    public ManagerClient(String host, int serverPort, int httpPort, String userName, String password) {
        String url;
        block9: {
            ErrorPacketException exn = null;
            try {
                if (serverPort > 0) {
                    HmuxClientFactory clientFactory = new HmuxClientFactory(host, serverPort, userName, password);
                    RemoteActorSender remoteClient = clientFactory.create();
                    this._bamManager = new SimpleBamManager(remoteClient.getBroker());
                    this._bamClient = remoteClient;
                }
                this._managerAddress = "manager@resin.caucho";
                if (this._bamClient != null) {
                    return;
                }
            }
            catch (RemoteConnectionFailedException e) {
                exn = new RemoteConnectionFailedException(L.l("Connection to '{0}:{1}' failed for remote admin. Check the server and make sure <resin:RemoteAdminService> is enabled in the resin.xml.\n  {2}", (Object)host, (Object)serverPort, (Object)e.getMessage()), e);
                if (httpPort == 0) {
                    throw exn;
                }
            }
            catch (RemoteListenerUnavailableException e) {
                exn = new RemoteListenerUnavailableException(L.l("HMTP request to '{0}:{1}' failed for remote admin, because remote administration was not enabled. Check that <resin:RemoteAdminService> is enabled in the resin.xml.\n  {2}", (Object)host, (Object)serverPort, (Object)e.getMessage()), e);
                if (httpPort != 0) break block9;
                throw exn;
            }
        }
        this._url = url = "http://" + host + ":" + httpPort + "/hmtp";
        HmtpClient client = new HmtpClient(url);
        try {
            client.setVirtualHost("admin.resin");
            client.connect(userName, password);
            this._bamManager = new SimpleBamManager(client.getBroker());
            this._bamClient = client;
            this._managerAddress = "manager@resin.caucho";
        }
        catch (RemoteConnectionFailedException e) {
            throw new RemoteConnectionFailedException(L.l("Connection to '{0}' failed for remote admin. Check the server and make sure <resin:RemoteAdminService> is enabled in the resin.xml.\n  {1}", (Object)url, (Object)e.getMessage()), e);
        }
        catch (RemoteListenerUnavailableException e) {
            throw new RemoteListenerUnavailableException(L.l("Remote admin request to '{0}' failed because remote administration has not been abled. Check the server and make sure <resin:RemoteAdminService> is enabled in the resin.xml.\n  {1}", (Object)url, (Object)e.getMessage()), e);
        }
        this.initImpl();
    }

    private void initImpl() {
        this._managerProxy = this.createAgentProxy(ManagerProxyApi.class, "manager-proxy@resin.caucho");
    }

    public String getUrl() {
        return this._url;
    }

    public ActorSender getSender() {
        return this._bamClient;
    }

    public <T> T createAgentProxy(Class<T> api, String address) {
        return this._bamManager.createProxy(api, this._bamManager.createActorRef(address), this.getSender());
    }

    private ManagerProxyApi getManagerProxy() {
        return this._managerProxy;
    }

    public AddUserQueryReply addUser(String user, char[] password, String[] roles) {
        AddUserQuery query = new AddUserQuery(user, password, roles);
        return (AddUserQueryReply)this.query(query);
    }

    public RemoveUserQueryReply removeUser(String user) {
        RemoveUserQuery query = new RemoveUserQuery(user);
        return (RemoveUserQueryReply)this.query(query);
    }

    public ListUsersQueryReply listUsers() {
        ListUsersQuery query = new ListUsersQuery();
        return (ListUsersQueryReply)this.query(query);
    }

    public StringQueryReply doThreadDump() {
        ThreadDumpQuery query = new ThreadDumpQuery();
        return (StringQueryReply)this.query(query);
    }

    public JsonQueryReply doJsonThreadDump() {
        ThreadDumpQuery query = new ThreadDumpQuery(true);
        return (JsonQueryReply)this.query(query);
    }

    public StringQueryReply doHeapDump(boolean raw) {
        HeapDumpQuery query = new HeapDumpQuery(raw);
        return (StringQueryReply)this.query(query);
    }

    public JsonQueryReply doJmxDump() {
        JmxDumpQuery query = new JmxDumpQuery();
        return (JsonQueryReply)this.query(query);
    }

    public StringQueryReply setLogLevel(String[] loggers, Level logLevel, long period) {
        LogLevelQuery query = new LogLevelQuery(loggers, logLevel, period);
        return (StringQueryReply)this.query(query);
    }

    public ListJmxQueryReply listJmx(String pattern, boolean isPrintAttributes, boolean isPrintValues, boolean isPrintOperations, boolean isAll, boolean isPlatform) {
        JmxListQuery query = new JmxListQuery(pattern, isPrintAttributes, isPrintValues, isPrintOperations, isAll, isPlatform);
        return (ListJmxQueryReply)this.query(query);
    }

    public JmxSetQueryReply setJmx(String pattern, String attribute, String value) {
        JmxSetQuery query = new JmxSetQuery(pattern, attribute, value);
        return (JmxSetQueryReply)this.query(query);
    }

    public JmxCallQueryReply callJmx(String pattern, String operation, int opIndex, String[] trailingArgs) {
        JmxCallQuery query = new JmxCallQuery(pattern, operation, opIndex, trailingArgs);
        return (JmxCallQueryReply)this.query(query);
    }

    public PdfReportQueryReply pdfReport(String path, String report, String serverId, long period, String logDirectory, long profileTime, long samplePeriod, boolean isSnapshot, boolean isWatchdog, boolean isReportReturned) {
        PdfReportQuery query = new PdfReportQuery(path, report, serverId, period, logDirectory, profileTime, samplePeriod, isSnapshot, isWatchdog, isReportReturned);
        long timeout = profileTime > 0L ? profileTime + 60000L : 60000L;
        return (PdfReportQueryReply)this.query(query, timeout);
    }

    public StringQueryReply profile(long activeTime, long period, int depth) {
        ProfileQuery query = new ProfileQuery(activeTime, period, depth);
        return (StringQueryReply)this.query(query);
    }

    public Date[] listRestarts(long period) {
        ListRestartsQuery query = new ListRestartsQuery(period);
        return (Date[])this.query(query);
    }

    public StringQueryReply addLicense(String licenseContent, String fileName, boolean overwrite, boolean restart) {
        LicenseAddQuery query = new LicenseAddQuery(licenseContent, fileName, overwrite, restart);
        return (StringQueryReply)this.query(query);
    }

    public StatServiceValuesQueryReply getStats(String[] meters, Date from, Date to) {
        StatsQuery query = new StatsQuery(meters, from, to);
        return (StatServiceValuesQueryReply)this.query(query);
    }

    public StringQueryReply status() {
        ServerStatusQuery status = new ServerStatusQuery();
        return (StringQueryReply)this.query(status);
    }

    public StringQueryReply statusWebApp() {
        ServerStatusWebAppQuery status = new ServerStatusWebAppQuery();
        return (StringQueryReply)this.query(status);
    }

    public StringQueryReply scoreboard(String type, boolean greedy) {
        ScoreboardQuery query = new ScoreboardQuery(type, greedy);
        return (StringQueryReply)this.query(query);
    }

    public String enable(String serverId) {
        ManagerProxyApi manager = this.getManagerProxy();
        return manager.enable();
    }

    public String disable(String serverId) {
        ManagerProxyApi manager = this.getManagerProxy();
        return manager.disable();
    }

    protected Serializable query(Serializable query) {
        try {
            return this._bamClient.query(this._managerAddress, query);
        }
        catch (ServiceUnavailableException e) {
            throw new ServiceUnavailableException("Manager service is not available, possibly because the resin.xml is missing a <resin:ManagerService> tag\n  " + e.getMessage(), e);
        }
    }

    protected Serializable query(Serializable query, long timeout) {
        try {
            return this._bamClient.query(this._managerAddress, query, timeout);
        }
        catch (ServiceUnavailableException e) {
            throw new ServiceUnavailableException("Manager service is not available, possibly because the resin.xml is missing a <resin:ManagerService> tag\n  " + e.getMessage(), e);
        }
    }

    public void close() {
        this._bamClient.close();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._bamClient + "]";
    }
}

