/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.AbstractHttpResponse;
import com.caucho.server.http.AbstractResponseStream;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.ResponseWrapper;
import com.caucho.server.httpcache.AbstractCacheEntry;
import com.caucho.server.httpcache.AbstractCacheFilterChain;
import com.caucho.server.webapp.ErrorPageManager;
import com.caucho.server.webapp.WebApp;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class CauchoResponseWrapper
implements CauchoResponse {
    private static final Logger log = Logger.getLogger(CauchoResponseWrapper.class.getName());
    private final CauchoRequest _request;
    private HttpServletResponse _response;

    public CauchoResponseWrapper() {
        this._request = null;
    }

    public CauchoResponseWrapper(CauchoRequest request) {
        this._request = request;
    }

    public CauchoResponseWrapper(CauchoRequest request, HttpServletResponse response) {
        this._request = request;
        if (response == null) {
            throw new IllegalArgumentException();
        }
        this._response = response;
    }

    public void setResponse(HttpServletResponse response) {
        this._response = response;
    }

    protected CauchoRequest getRequest() {
        return this._request;
    }

    public void setContentType(String type) {
        this._response.setContentType(type);
    }

    public String getContentType() {
        return this._response.getContentType();
    }

    public String getCharacterEncoding() {
        return this._response.getCharacterEncoding();
    }

    public void setCharacterEncoding(String charset) {
        this._response.setCharacterEncoding(charset);
    }

    public void setLocale(Locale locale) {
        this._response.setLocale(locale);
    }

    public Locale getLocale() {
        return this._response.getLocale();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this._response.getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        return this._response.getWriter();
    }

    public void setBufferSize(int size) {
        this._response.setBufferSize(size);
    }

    public int getBufferSize() {
        return this._response.getBufferSize();
    }

    public void flushBuffer() throws IOException {
        this._response.flushBuffer();
    }

    public boolean isCommitted() {
        return this._response.isCommitted();
    }

    public void reset() {
        this._response.reset();
    }

    public void resetBuffer() {
        this._response.resetBuffer();
    }

    public void setContentLength(int len) {
        this._response.setContentLength(len);
    }

    @Override
    public void setContentLength(long length) {
        if (this._response instanceof CauchoResponse) {
            CauchoResponse cRes = (CauchoResponse)this._response;
            cRes.setContentLength(length);
        } else if (length <= Integer.MAX_VALUE) {
            this._response.setContentLength((int)length);
        }
    }

    public void setStatus(int sc) {
        this._response.setStatus(sc);
    }

    public void sendError(int sc, String msg) throws IOException {
        if (!this.sendInternalError(sc, msg)) {
            this._response.sendError(sc, msg);
        }
    }

    public void sendError(int sc) throws IOException {
        this.sendError(sc, null);
    }

    protected boolean sendInternalError(int sc, String msg) {
        if (sc == 304) {
            return false;
        }
        CauchoRequest req = this._request;
        if (req == null) {
            return false;
        }
        WebApp webApp = req.getWebApp();
        if (webApp == null) {
            return false;
        }
        ErrorPageManager errorManager = webApp.getErrorPageManager();
        if (errorManager == null) {
            return false;
        }
        if (msg != null) {
            this.setStatus(sc, msg);
        } else {
            this.setStatus(sc);
        }
        try {
            errorManager.sendError(this._request, this, sc, this.getStatusMessage());
            this.killCache();
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
            return false;
        }
        return true;
    }

    public void sendRedirect(String location) throws IOException {
        this._response.sendRedirect(location);
    }

    public void setHeader(String name, String value) {
        this._response.setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        this._response.addHeader(name, value);
    }

    public boolean containsHeader(String name) {
        return this._response.containsHeader(name);
    }

    public void setDateHeader(String name, long date) {
        this._response.setDateHeader(name, date);
    }

    public void addDateHeader(String name, long date) {
        this._response.addDateHeader(name, date);
    }

    public void setIntHeader(String name, int value) {
        this._response.setIntHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        this._response.addIntHeader(name, value);
    }

    public void addCookie(Cookie cookie) {
        this._response.addCookie(cookie);
    }

    public String encodeURL(String url) {
        return this._response.encodeURL(url);
    }

    public String encodeRedirectURL(String name) {
        return this._response.encodeRedirectURL(name);
    }

    public void setStatus(int sc, String msg) {
        this._response.setStatus(sc, msg);
    }

    public String encodeUrl(String url) {
        return this._response.encodeUrl(url);
    }

    public String encodeRedirectUrl(String url) {
        return this._response.encodeRedirectUrl(url);
    }

    public int getStatus() {
        return this._response.getStatus();
    }

    @Override
    public String getHeader(String name) {
        try {
            return this._response.getHeader(name);
        }
        catch (AbstractMethodError ame) {
            return null;
        }
    }

    public Collection<String> getHeaders(String name) {
        return this._response.getHeaders(name);
    }

    public Collection<String> getHeaderNames() {
        return this._response.getHeaderNames();
    }

    @Override
    public AbstractResponseStream getResponseStream() {
        if (this._response instanceof CauchoResponse) {
            CauchoResponse cResponse = (CauchoResponse)this._response;
            return cResponse.getResponseStream();
        }
        return null;
    }

    @Override
    public void setResponseStream(AbstractResponseStream os) {
        if (this._response instanceof CauchoResponse) {
            ((CauchoResponse)this._response).setResponseStream(os);
        }
    }

    @Override
    public boolean isCauchoResponseStream() {
        if (this._response instanceof CauchoResponse) {
            return ((CauchoResponse)this._response).isCauchoResponseStream();
        }
        return false;
    }

    @Override
    public void setFooter(String key, String value) {
        if (this._response instanceof CauchoResponse) {
            ((CauchoResponse)this._response).setFooter(key, value);
        }
    }

    @Override
    public void addFooter(String key, String value) {
        if (this._response instanceof CauchoResponse) {
            ((CauchoResponse)this._response).addFooter(key, value);
        }
    }

    @Override
    public void close() throws IOException {
        if (this._response instanceof CauchoResponse) {
            ((CauchoResponse)this._response).close();
        }
    }

    @Override
    public boolean getForbidForward() {
        if (this._response instanceof CauchoResponse) {
            ((CauchoResponse)this._response).getForbidForward();
        }
        return false;
    }

    @Override
    public void setForbidForward(boolean forbid) {
        if (this._response instanceof CauchoResponse) {
            ((CauchoResponse)this._response).setForbidForward(forbid);
        }
    }

    @Override
    public String getStatusMessage() {
        if (this._response instanceof CauchoResponse) {
            return ((CauchoResponse)this._response).getStatusMessage();
        }
        return null;
    }

    @Override
    public boolean hasError() {
        if (this._response instanceof CauchoResponse) {
            return ((CauchoResponse)this._response).hasError();
        }
        return false;
    }

    @Override
    public void setHasError(boolean error) {
        if (this._response instanceof CauchoResponse) {
            ((CauchoResponse)this._response).setHasError(error);
        }
    }

    @Override
    public void setSessionId(String id) {
        if (this._response instanceof CauchoResponse) {
            ((CauchoResponse)this._response).setSessionId(id);
        }
    }

    @Override
    public void killCache() {
        if (this._response instanceof CauchoResponse) {
            ((CauchoResponse)this._response).killCache();
        }
    }

    @Override
    public void completeCache() {
        this.getResponseStream().completeCache();
    }

    @Override
    public void setNoCache(boolean killCache) {
        if (this._response instanceof CauchoResponse) {
            ((CauchoResponse)this._response).setNoCache(killCache);
        }
    }

    @Override
    public void setPrivateCache(boolean isPrivate) {
        if (this._response instanceof CauchoResponse) {
            ((CauchoResponse)this._response).setPrivateCache(isPrivate);
        }
    }

    @Override
    public boolean isNoCacheUnlessVary() {
        CauchoResponse cRes = this.getCauchoResponse();
        if (cRes != null) {
            return cRes.isNoCacheUnlessVary();
        }
        return false;
    }

    public CauchoResponse getCauchoResponse() {
        if (this._response instanceof CauchoResponse) {
            return (CauchoResponse)this._response;
        }
        return null;
    }

    @Override
    public AbstractHttpResponse getAbstractHttpResponse() {
        HttpServletResponse response = this._response;
        while (response != null) {
            AbstractHttpResponse httpRes;
            if (response instanceof CauchoResponse && (httpRes = ((CauchoResponse)response).getAbstractHttpResponse()) != null) {
                return httpRes;
            }
            if (response instanceof ServletResponseWrapper) {
                response = ((ServletResponseWrapper)response).getResponse();
                continue;
            }
            if (response instanceof ResponseWrapper) {
                response = ((ResponseWrapper)response).getResponse();
                continue;
            }
            response = null;
        }
        return null;
    }

    @Override
    public void setCacheInvocation(AbstractCacheFilterChain cacheFilterChain) {
    }

    @Override
    public boolean isCaching() {
        return false;
    }

    public void setMatchCacheEntry(AbstractCacheEntry cacheEntry) {
    }

    @Override
    public ServletResponse getResponse() {
        return this._response;
    }

    @Override
    public void setForwardEnclosed(boolean isForwardEnclosed) {
    }

    @Override
    public boolean isForwardEnclosed() {
        return false;
    }

    @Override
    public void writeHeaders(int length) throws IOException {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._response + "]";
    }

    @Override
    public String getCharacterEncodingAssigned() {
        return null;
    }
}

