/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.AbstractResponseStream;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.ResponseAdapter;
import com.caucho.server.http.ToCharResponseStream;
import com.caucho.util.FreeList;
import java.io.IOException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class ToCharResponseAdapter
extends ResponseAdapter {
    private static final FreeList<ToCharResponseAdapter> _freeList = new FreeList(32);
    private ToCharResponseStreamWrapper _responseStream;

    private ToCharResponseAdapter() {
    }

    public static ToCharResponseAdapter create(HttpServletResponse response) {
        ToCharResponseAdapter resAdapt = _freeList.allocate();
        if (resAdapt == null) {
            resAdapt = new ToCharResponseAdapter();
        }
        resAdapt.init(response);
        return resAdapt;
    }

    @Override
    protected AbstractResponseStream createWrapperResponseStream() {
        if (this._responseStream == null) {
            this._responseStream = new ToCharResponseStreamWrapper();
        }
        return this._responseStream;
    }

    @Override
    public void init(HttpServletResponse response) {
        this._responseStream.start();
        super.init(response);
    }

    @Override
    public void resetBuffer() {
        this._responseStream.clearBuffer();
        super.resetBuffer();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getResponse() + "]";
    }

    public static void free(ToCharResponseAdapter resAdapt) {
        resAdapt.free();
        _freeList.free(resAdapt);
    }

    class ToCharResponseStreamWrapper
    extends ToCharResponseStream {
        ToCharResponseStreamWrapper() {
        }

        @Override
        public String getEncoding() {
            ServletResponse response = ToCharResponseAdapter.this.getResponse();
            if (response instanceof CauchoResponse) {
                CauchoResponse cRes = (CauchoResponse)response;
                return cRes.getCharacterEncodingAssigned();
            }
            return response.getCharacterEncoding();
        }

        @Override
        public void flushChar() throws IOException {
            this.flushBuffer();
            ToCharResponseAdapter.this.getResponse().getWriter().flush();
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            ToCharResponseAdapter.this.getResponse().getWriter().flush();
        }

        @Override
        protected void writeNext(char[] buffer, int offset, int length) throws IOException {
            ToCharResponseAdapter.this.getResponse().getWriter().write(buffer, offset, length);
        }
    }
}

