/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.cloud.network.ClusterServerProgram;
import com.caucho.cloud.topology.CloudCluster;
import com.caucho.cloud.topology.CloudPod;
import com.caucho.cloud.topology.CloudServer;
import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.SchemaBean;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.server.resin.BootPodConfig;
import com.caucho.server.resin.BootResinConfig;
import com.caucho.server.resin.BootServerConfig;
import com.caucho.server.resin.BootServerMultiConfig;
import com.caucho.util.L10N;
import java.util.ArrayList;
import javax.annotation.PostConstruct;

public class BootClusterConfig
implements SchemaBean {
    private static final L10N L = new L10N(BootClusterConfig.class);
    private BootResinConfig _resinConfig;
    private String _id;
    private ContainerProgram _clusterProgram = new ContainerProgram();
    private ContainerProgram _serverDefaultProgram = new ContainerProgram();
    private ContainerProgram _elasticServerDefaultProgram = new ContainerProgram();
    private ArrayList<BootPodConfig> _pods = new ArrayList();
    private CloudCluster _cloudCluster;

    public BootClusterConfig(BootResinConfig resinConfig) {
        this._resinConfig = resinConfig;
    }

    @Override
    public String getSchema() {
        return "com/caucho/server/resin/cluster.rnc";
    }

    public String getId() {
        return this._id;
    }

    @Configurable
    public void setId(String id) {
        this._id = id;
    }

    @Configurable
    public void addServerDefault(ContainerProgram program) {
        this._serverDefaultProgram.addProgram(program);
    }

    public ContainerProgram getServerDefault() {
        return this._serverDefaultProgram;
    }

    public ContainerProgram getServerMultiDefault() {
        return this._elasticServerDefaultProgram;
    }

    @Configurable
    public BootPodConfig createPod() throws ConfigException {
        BootPodConfig pod = new BootPodConfig(this);
        return pod;
    }

    @Configurable
    public void addPod(BootPodConfig pod) {
        this._pods.add(pod);
    }

    @Configurable
    public BootServerConfig createServer() throws ConfigException {
        if (this._pods.size() == 0) {
            this.addPod(this.createPod());
        }
        BootPodConfig pod = this._pods.get(0);
        return pod.createServer();
    }

    @Configurable
    public void addServer(BootServerConfig server) {
        if (this._pods.size() == 0) {
            this.addPod(this.createPod());
        }
        BootPodConfig pod = this._pods.get(0);
        pod.addServer(server);
    }

    public void addServerMulti(BootServerMultiConfig multiServer) {
        int index = 0;
        this._elasticServerDefaultProgram.addProgram(multiServer.getServerProgram());
        for (String address : multiServer.getAddressList()) {
            boolean isExt = false;
            if (address.startsWith("ext:")) {
                isExt = true;
                address = address.substring("ext:".length());
            }
            int port = multiServer.getPort();
            int p = address.lastIndexOf(58);
            if (p > 0) {
                port = Integer.parseInt(address.substring(p + 1));
                address = address.substring(0, p);
            }
            boolean isAllowNonReservedIp = multiServer.isAllowNonReservedIp();
            BootServerConfig server = this.createServer();
            server.setId(multiServer.getIdPrefix() + index++);
            server.setAddress(address);
            server.setPort(port);
            if (isExt) {
                server.setExternalAddress(true);
            }
            if (isAllowNonReservedIp) {
                server.setAllowNonReservedIp(true);
            }
            multiServer.getServerProgram().configure(server);
            this.addServer(server);
        }
    }

    public ArrayList<BootPodConfig> getPodList() {
        return this._pods;
    }

    public void addContentProgram(ConfigProgram program) {
        this._clusterProgram.addProgram(program);
    }

    ConfigProgram getProgram() {
        return this._clusterProgram;
    }

    @PostConstruct
    public void init() {
        if (this._id == null) {
            throw new ConfigException(L.l("'id' is a required attribute for <cluster>"));
        }
    }

    void initTopology(CloudCluster cluster) {
        this._cloudCluster = cluster;
        cluster.putData(new ClusterServerProgram(this._serverDefaultProgram));
        for (BootPodConfig bootPod : this._pods) {
            this.initTopology(bootPod);
        }
    }

    void initTopology(BootPodConfig bootPod) {
        CloudCluster cluster = this._cloudCluster;
        if (cluster == null) {
            this._resinConfig.initTopology(this);
            cluster = this._cloudCluster;
        }
        CloudPod pod = cluster.createPod();
        bootPod.initTopology(pod);
    }

    public BootServerConfig addDynamicServer(CloudServer cloudServer) {
        BootServerConfig bootServer = this.createServer();
        bootServer.setId(cloudServer.getId());
        this.addServer(bootServer);
        bootServer.initTopology(cloudServer);
        return bootServer;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._id + "]";
    }
}

